;+
; BACK_MENU
;	Widget interface to set backgrounds.
;
; Usage:
;	back_menu, group=group
;
; Keyword:
;	group	long	input	group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly.
;
; History:
;	Original: 13/9/93; SJT
;	Change bg names to _bgc(d) from _c(d): 5/11/93; SJT
;	Move threshold setting out: 18/11/93; SJT
;	Complete restructuring to multiple alternately mappable bases
;		in place of single scrolling base: 19/12/94; SJT
;-

pro back_event, event

@bg_para
@back_wid
@settings
@flags
@spec_flags
@pad_flags

widget_control, get_uvalue=but, event.id

case but.name of
    'CANCEL': begin			; Cancel
	widget_control, event.top, /destroy
    end

    'DO': begin			; Do it
        for jhead = 0, n_elements(nchhd)-1 do begin
            for j = 0, nchhd(jhead)-1 do begin
                for k = 0, 1 do begin
                    widget_control, txtwids(jhead, j, k), get_value = st
                    case (jhead) of
                        0: f1_bgc(j, k) = float(st(0))	    	
                        1: m1_bgc(j, k) = float(st(0))	    	
                        2: w_bgc(j, k) = float(st(0))	    	
                        3: z_bgc(j, k) = float(st(0))	    	
                        4: f2_bgc(j, k) = float(st(0))	    	
                        5: m2_bgc(j, k) = float(st(0))	    	
                        6: d_bgc(j, k) = float(st(0))	    	
                        7: s_bgc(j, k) = float(st(0))
                    endcase
                endfor
	    endfor
	endfor
	bg_present = 1
	widget_control, chwid, get_value=bgcs
	bgc_time = conv_time_str(bgcs(0))
	widget_control, event.top, /destroy
        if (bg_subtract) then begin
	    if (bg_flag) then replot_ok = 0
	    spc_replot_ok = 0
	    pad_replot_ok = 0
        endif
    end

    "CHANGE":			; Ignore events in the time window.

    "RESTORE": begin		; Restore defaults.
	f1_bgc = f1_bgcd
	f2_bgc = f2_bgcd
	m1_bgc = m1_bgcd
	m2_bgc = m2_bgcd
	d_bgc  = d_bgcd
	w_bgc  = w_bgcd
	z_bgc  = z_bgcd
	s_bgc = s_bgcd
	bgc_time = bgc_timed
	widget_control, event.top, /destroy
	bg_present = max([f1_bgc, f2_bgc, m1_bgc, m2_bgc, w_bgc, $
		z_bgc, d_bgc, s_bgc]) gt 0
        if (bg_subtract) then begin
	    if (bg_flag) then replot_ok = 0
	    spc_replot_ok = 0
	    pad_replot_ok = 0
        endif
    end
    
    "HEAD": begin
        widget_control, headbase(imapped), map = 0
        imapped = but.numb
        widget_control, headbase(imapped), /map
    end
    
    'BACK': begin
        tw = txtwids(but.numb, 0:nchhd(but.numb)-1, *)
	i = (where(event.id eq tw) + 1) mod (2*nchhd(but.numb))
	widget_control, tw(i(0)), /input_focus
    end

endcase

end

function bg_subunit, base, label, labela, labelb, uv1=uv1, uv2=uv2, $
	v1=v1, v2=v2

@wid_fonts

if (base gt 0) then a = widget_base(base, /row) $
else		    a = widget_base(/row)

b = widget_label(a, value=label, font=normal_v)
c = widget_label(a, value=labela, font=normal_v)
d = widget_text(a, /frame, /edit, xsize = 12, value = v1, uvalue = $
                uv1, font = normal_f)
e = widget_label(a, value=labelb, font=normal_v)
f = widget_text(a, /frame, /edit, xsize = 12, value = v2, uvalue = $
                uv2, font = normal_f)

return, [a,b,c,d,e,f]

end


pro back_menu, group=group

@bg_para
@back_wid
@wid_fonts
@settings
@flags
@wid_set

;	Check if already present

if (xregistered('back')) then return

;	Set values for uninitializeds

if (n_elements(bg_subtract) eq 0) then bg_subtract = 0
if (n_elements(bg_flag) eq 0) then bg_flag = 0

;	Channels list, in IDF.DAT order

prime = "'"
cf60 = strcompress(/remove, ['E'+sar(4)+prime, 'FP'+sar(5,7)+prime])
cm120 = strcompress(/remove, ['P'+sar(8)+prime])
cw60 = strcompress(/remove, ['W'+sar(8)])
cz = strcompress(/remove, ['Z2', 'Z2A', 'Z3', 'Z4'])
cf150 = strcompress(/remove, ['E'+sar(4), 'FP'+sar(5, 7)])
cm30 = strcompress(/remove, ['P'+sar(8)])
cde = strcompress(/remove, ['DE'+sar(4)])
cs = strcompress(/remove, ['B', 'C', 'D', 'M', 'F', 'M'+prime, $
                           'F'+prime])

nchhd = [7, 8, 8, 4, 7, 8, 4, 7]

chans = {chanlist, lefs60:cf60, lems120:cm120, wart:cw60, z:cz, $
         Lefs150:cf150, Lems30:cm30, de:cde, single:cs}

heads = ['LEFS60', 'LEMS120', 'CA60', 'CA60 (Z)', 'LEFS150', 'LEMS30', $
         'Wart - B', 'Singles']
headuv = replicate({uval_type, name:'HEAD', numb:0}, 8)
headuv.numb = indgen(8)
headbase = lonarr(8)

if (n_elements(imapped) eq 0) then imapped = 0

if (bg_present) then bgs = string(bgc_time, format="(5(i4,:,','))") $
else		     bgs = ''

txtwids = lonarr(8, 8, 2)

;	Create menus

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(/column, /frame, xpad = 5, $
                                     ypad = 5, $
                                     title = 'Background Levels', $
                                     /scroll, x_scroll_size = xss, $
                                     y_scroll_size = yss) $
else base = widget_base(/column, /frame, xpad = 5, ypad = 5, $
                        title = 'Background Levels')

junk = widget_label(base, value='HI-SCALE backgrounds', frame=2, font=large_v)

;	Select which set of channels:

jb = widget_base(base, /column, /frame)
junk = widget_label(jb, value = 'Head selection', font = normal_v)

xmenu, heads, jb, uvalue = headuv, /exclusive, row = 2, button = jbut, $
  font = normal_v, /no_release
widget_control, jbut(imapped), /set_button

;	Background inputs

bgbase = widget_base(base, /frame)

for jhead = 0, 7 do begin
    headbase(jhead) = widget_base(bgbase, /column)
    junk = widget_label(headbase(jhead), value = 'Background levels: ' $
                        + heads(jhead), font = large_v) 
    
    if (bg_present) then begin
        case jhead of
            0: vs = reform(string(f1_bgc, format = "(g9.3)"), $
                           nchhd(jhead), 2) 
            1: vs = reform(string(m1_bgc, format = "(g9.3)"), $
                           nchhd(jhead), 2) 
            2: vs = reform(string(w_bgc, format = "(g9.3)"), $
                           nchhd(jhead), 2) 
            3: vs = reform(string(z_bgc, format = "(g9.3)"), $
                           nchhd(jhead), 2) 
            4: vs = reform(string(f2_bgc, format = "(g9.3)"), $
                           nchhd(jhead), 2) 
            5: vs = reform(string(m2_bgc, format = "(g9.3)"), $
                           nchhd(jhead), 2) 
            6: vs = reform(string(d_bgc, format = "(g9.3)"), $
                           nchhd(jhead), 2) 
            7: vs = reform(string(s_bgc, format = "(g9.3)"), $
                           nchhd(jhead), 2) 
        endcase
    endif else vs = strarr(nchhd(jhead), 2)
    
    for j = 0, nchhd(jhead)-1 do begin
        uv1 = {uval_type, 'BACK', jhead}
        uv2 = {uval_type, 'BACK', jhead}
        ja = bg_subunit(headbase(jhead), heads(jhead)+' - ' + $
                        chans.(jhead)(j), 'Before: ', 'After: ', v1 = $
                        vs(j, 0), v2 = vs(j, 1), uv1 = uv1, uv2 = uv2)
        txtwids(jhead, j, *) = ja([3, 5])
    endfor
    
    if (jhead ne imapped) then widget_control, headbase(jhead),  $
      map = 0
endfor      
    
;	Changeover time

jb = widget_base(base, /row)
junk = widget_label(jb, value = 'Changeover time', font = normal_v)
chwid = widget_text(jb, /frame, /edit, xsize = 24, uvalue = $
                    {uval_type, 'CHANGE', 0}, value = bgs, $
                    font = normal_f)

;	Exit buttons

jb = widget_base(base, /row)
junk = widget_button(jb, value = 'Cancel',  $
                     uvalue = {uval_type, 'CANCEL', 0}, $
                     font = normal_v)
junk = widget_button(jb, value = 'Restore Defaults', uvalue = $
                     {uval_type, 'RESTORE', 0}, font = $
                     normal_v)
junk = widget_button(jb, value = 'Do it', uvalue =  $
                     {uval_type, 'DO', 0}, font = normal_v)

widget_control, base, /real, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1) and not iscroll) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif

xmanager, 'back', base, group=group

end
