;+
; ARCHIVE_MENU
;	Select archive type from menu.
;
; Usage:
;	archive_menu
;
; Arguments: none
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly.
;
; History:
;	Original: 8/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Add UAF archives: 23/7/93; SJT
;	Force scrolling if the base is to big: 21/4/94; SJT
;	Add CUAV & CUAF archives: 22/8/94; SJT
;-

pro archive_event, event

;	Event handler

@settings
@flags
@b_flags
@spec_flags
@pad_flags
@rate_wid
@file_info
@arc_wid

widget_control, event.id, get_uvalue=but

case but of 
    'CANCEL': begin
	widget_control, event.top, /destroy
	return
    end

    'ULA': begin
        archive = 0
        arc_prefix = 'ula'
        arc_suffix = '.rat'
        arc_resolution = 0.005
        arc_duration = 1
        arc_comp = 1b
    end
    
    'UAV': begin
        archive = 1
        arc_prefix = 'uav'
        arc_suffix = '.lan'
        arc_resolution = 1.0
        arc_duration = 32
        arc_comp = 0b
    end
    
    '1D': begin
        archive = 2
        arc_prefix = 'cmp1d'
        arc_suffix = '.lan'
        arc_resolution = 24.
        arc_duration = 366
        arc_comp = 1b
    end
    'UAF': begin
        archive = 3
        arc_prefix = 'uaf'
        arc_suffix = '.lan'
        arc_resolution = 1.0
        arc_duration = 32
        arc_comp = 0b
    end

    '6H': begin
        archive = 4
        arc_prefix = 'cmp6h'
        arc_suffix = '.lan'
        arc_resolution = 6.0
        arc_duration = 32
        arc_comp = 1b
    end

    'CUAF': begin
        archive = 5
        arc_prefix = 'cuaf'
        arc_suffix = '.lan'
        arc_resolution = 1.0
        arc_duration = 366
        arc_comp = 1b
    end
    
    'USER': begin
        archive = -1
        widget_control, userbase, /sensitive
        widget_control, prf_txt, /input_focus
    end
    
    'PRF': widget_control, sff_txt, /input_focus
    'SFF': widget_control, res_txt, /input_focus
    'RES': widget_control, dur_txt, /input_focus
    'DUR': widget_control, prf_txt, /input_focus
    
    'SPARSE': icomp = 0b
    'FILLED': icomp = 1b
    
    'S': begin
        widget_control, res_txt, get_value = ress
        res = float(ress(0))/unit_fix(iunit)
        iunit = 0
        res = res*unit_fix(iunit)
        widget_control, res_txt, set_value = strtrim(string(res), 2), $
          /input_focus
    end
    'M': begin
        widget_control, res_txt, get_value = ress
        res = float(ress(0))/unit_fix(iunit)
        iunit = 1
        res = res*unit_fix(iunit)
        widget_control, res_txt, set_value = strtrim(string(res), 2), $
          /input_focus
    end
    'H': begin
        widget_control, res_txt, get_value = ress
        res = float(ress(0))/unit_fix(iunit)
        iunit = 2
        res = res*unit_fix(iunit)
        widget_control, res_txt, set_value = strtrim(string(res), 2), $
          /input_focus
    end
    'D': begin
        widget_control, res_txt, get_value = ress
        res = float(ress(0))/unit_fix(iunit)
        iunit = 3
        res = res*unit_fix(iunit)
        widget_control, res_txt, set_value = strtrim(string(res), 2), $
          /input_focus
    end
        
    'DO': begin
        widget_control, prf_txt, get_value = prf
        arc_prefix = prf(0)
        widget_control, sff_txt, get_value = sff
        arc_suffix = sff(0)
        widget_control, res_txt, get_value = ress
        arc_resolution = float(ress(0))/unit_fix(iunit)
        arc_comp = icomp
        widget_control, dur_txt, get_value = durs
        arc_duration = fix(durs(0))
        widget_control, event.top, /destroy
    end
    
    else:
endcase

replot_ok = 0
pad_replot_ok = 0
spc_replot_ok = 0
b_replot_ok = 0
if (archive ge 0) then widget_control, event.top, /destroy

if (n_elements(bid) gt 8) then begin
    if (widget_info(bid(8), /valid)) then widget_control, bid(8), $
      sensitive = archive ne 0 or (flux eq 8 or flux eq 6)
endif

end

pro archive_menu, group=group

;	Set up menus

@settings
@wid_fonts
@wid_set
@file_info
@arc_wid

if (xregistered('archive')) then return	; Don't make a second copy.

if (n_elements(archive) eq 0) then begin
    archive = 0
    arc_prefix = 'ula'
    arc_suffix = '.rat'
    arc_resolution = 0.005
    arc_duration = 1
    arc_comp = 1b
endif
icomp = arc_comp

arctypes = ['ULA - Raw Data', 'UAV - (Hourly) Averages', $
	    'CMP1D - Daily Averages', 'UAF - filtered averages', $
            'CMP6H - 6 Hour Averages', 'CUAF - Filtered compressed', $
            'User defined']
arcval = ['ULA', 'UAV', '1D', 'UAF', '6H', 'CUAF', 'USER']
arcdef = intarr(n_elements(arcval))

if (archive ge 0) then arcdef(archive) = 1 $
else arcdef(n_elements(arcdef)-1) = 1

base = widget_base(title = 'Archive Type', /column, xpad = 5, ypad = 5)

txt = widget_label(base, value = 'Hiscale Data Archive Type', frame = 2, $
	font=large_v)

xmenuplus, arctypes, base, uvalue=arcval, font=normal_v, $
	column = 2, boxes = arcdef

;	Menus for user defined archive

userbase = widget_base(base, /column, /frame)
junk = widget_label(userbase, value = 'User Defined Archive', font = $
                    large_v)

;	File name template.

jb = widget_base(userbase, /row)
junk = widget_label(jb, value = 'File name:', font = normal_v)
prf_txt = widget_text(jb, /edit, /frame, xsize = 8, uval = 'PRF', $
                      value = arc_prefix, font = normal_f)
junk = widget_label(jb, value = 'yyddd', font = normal_f)
sff_txt = widget_text(jb, /edit, /frame, xsize = 4, uval = 'SFF', $
                      value = arc_suffix, font = normal_f)

;	Time resolution

units = ['S', 'M', 'H', 'D']
unit_fix = [3600., 60., 1., 1./24.]

if (arc_resolution ge 24.0) then begin
    arr = arc_resolution/24.0
    iunit = 3
endif else if (arc_resolution ge 1.0) then begin
    arr = arc_resolution
    iunit = 2
endif else if (arc_resolution*60. ge 1.0) then begin
    arr = arc_resolution*60.
    iunit = 1
endif else begin
    arr = arc_resolution*3600.
    iunit = 0
endelse

jb = widget_base(userbase, /row)
junk = widget_label(jb, value = 'Data cadence:', font = normal_v)
res_txt = widget_text(jb, /edit, /frame, uvalue = 'RES', value = $
                      strtrim(string(arr), 2), font = normal_f, xsize = 10)
xmenu, units, jb, uvalue = units, /exclusive, /row, font = normal_v, $
  buttons = unitbut, /no_release

widget_control, unitbut(iunit), /set_button

; Duration and sparse/filled

jb = widget_base(userbase, /row)
jbb = widget_base(jb, /row)
junk = widget_label(jbb, value = 'File duration:', font = normal_v)
dur_txt = widget_text(jbb, xsize = 4, value =  $
                      strtrim(string(arc_duration), 2), $
                      uvalue = 'DUR', /edit, /frame, font = normal_v)
junk = widget_label(jbb, value = 'Days', font = normal_v)

filling = ['Sparse', 'Filled']

jbb = widget_base(jb, /row)
junk = widget_label(jbb, value = 'Filling:', font = normal_v)
xmenu, filling, jbb, /exclusive, uvalue = strupcase(filling), buttons $
  = fillbut, /row, /no_release, font = normal_v
widget_control, fillbut(arc_comp), /set_button

dobut = widget_button(userbase, value = 'Do it', uvalue = 'DO', font = $
                      normal_v)

widget_control, userbase, sensitive = (archive lt 0)

canbut = widget_button(base, value='Cancel', uvalue='CANCEL', font=normal_v)

widget_control, base, /real
if (archive eq -1) then widget_control, prf_txt, /input_focus
xmanager, 'archive', base, group=group

end
