pro Add_stack, timeplot, new=new, pha=pha

;+
; ADD_STACK
;	Add the current plot transform to the stack.
;
; Usage:
;	add_stack, timeplot[, /new, /pha]
;
; Argument:
;	timeplot  byte	input	If non-zero then the current transform is
;				on a time axis.
;
; Keyword:
;	new	input	If set then clear the stack and start over
;			again (else append to stack).
;	pha	input	Plot transform is for a PHA matrix
;
; History:
;	Original: 1/6/94; SJT
;	Add PHA key: 23/11/95; SJT
;-

@trans_stack

if (n_elements(zoom) eq 0) then zoom = 0

if (keyword_set(new)) then begin
    ptfm = !P
    xtfm = !X
    ytfm = !Y
    istime = (timeplot ne 0)
    ispha = keyword_set(pha)
    
endif else begin
    ptfm = [ptfm, !P]
    xtfm = [xtfm, !X]
    ytfm = [ytfm, !Y]
    istime = [istime, (timeplot ne 0)]
    
endelse

ctfm = n_elements(istime)-1

end
