function exponential_funct,x_values,coefficients
   return,[[1.0],[alog(x_values)],[x_values]]
end  

function power_funct,x_values,coefficients
   return,[[1.0],[alog(x_values)]]
end   

function fit_spectrum,x_values,y_values,measure_errors,x_min,x_max,fit_params,force_fit

;
; program to compute spectra for all species using 
; 
; call, result = fit_spectrum(x_values,y_values,measure_errors,x_min,x_max,fit_params,force_fit)

; get the energy limits of ULEIS channels 

rates_h = exp(y_values)
err_h   = measure_errors*rates_h

deg_freedom = intarr(15)
deg_freedom = indgen(15) + 1
mean_chi    = fltarr(15)
mean_chi    = [0.455,0.693,0.789,0.839,0.870,0.891,0.907,0.918,0.927,0.934,0.940,0.945,0.949,0.953,0.956]
frac_chi    = 0.01
        
sigma_e = fltarr(400)
sigma_e = indgen(400)*0.005 +0.005
frac_err = 0.000001

sigma_lowe = lonarr(10000000)
sigma_lowe = lindgen(10000000)*0.000001 +0.000001

max_chi = 1.1
min_chi = 0.9
    
min_points = 3
sigma_a = fltarr(3)

cnt_fit = force_fit

cnt_h = n_elements(x_values)
    
    if (cnt_fit gt min_points) then begin    
       a = [1,1,1]
       result_a = svdfit(x_values,y_values,a=a,Measure_errors=measure_errors,function_name='exponential_funct',sigma=sigma,yfit=yfit,chisq=chisq)       
      
     deg_free = cnt_h-3.
     chinos = 0L
     while (chinos lt 15) do begin
         if (deg_free eq deg_freedom(chinos)) then begin
             min_chi = mean_chi(chinos)-frac_chi
             max_chi = mean_chi(chinos)+frac_chi
         endif     
      chinos = chinos + 1
     endwhile
     
     do_h2:
     ; second fit
     if (chisq/(cnt_h-3.) lt min_chi) then begin 
     k_sigma = 0L
     while (k_sigma lt n_elements(sigma_e)) do begin           
       locs = where(measure_errors gt frac_err)
       sig_e = sigma_e(k_sigma)
       measure_errors(locs) = measure_errors(locs) - sig_e*measure_errors(locs) 
       result_a = svdfit(x_values,y_values,a=a,Measure_errors=measure_errors,function_name='exponential_funct',sigma=sigma,yfit=yfit,chisq=chisq)       
        if (chisq/(cnt_h-3.) gt max_chi) then goto, do_h1 
        if (chisq/(cnt_h-3.) lt min_chi) then begin
            k_sigma = k_sigma + 1 
        endif else begin
            k_sigma = n_elements(sigma_e)
        endelse
        endwhile    
       endif
     
    ; stop
     
     if (chisq/(cnt_h-3.) gt max_chi) then begin 
     k_sigma = 0L
     while (k_sigma lt n_elements(sigma_e)) do begin           
       sig_e = sigma_e(k_sigma)
       delta_e = x_max-x_min
       par_a0  = exp(result_a(0))
       par_a1  = -1.*result_a(1)
       par_a2  = -1.0/result_a(2)
       diff_je = -1.0*par_a0*exp(-1.0*x_values/par_a2)*(par_a1/x_values^(1.0+par_a1) + 1.0/(par_a2*x_values^par_a1))
       sig_j2  = sig_e*delta_e*diff_je/(2*x_values)
       err_y   = sqrt(err_h^2 + sig_j2^2)         
       err_y   = err_y/rates_h
       measure_errors = err_y
       
       result_a = svdfit(x_values,y_values,a=a,Measure_errors=measure_errors,function_name='exponential_funct',sigma=sigma,yfit=yfit,chisq=chisq)       
        if (chisq/(cnt_h-3.) lt min_chi) then goto, do_h2
        if (chisq/(cnt_h-3.) gt max_chi) then begin
            k_sigma = k_sigma + 1 
        endif else begin
            k_sigma = n_elements(sigma_e)
        endelse
        endwhile    
       endif
       do_h1:
      
       
       ;stop
     ; calculate uncertainty
   
     ; do a0   
     y_fit = result_a(0) + result_a(1)*alog(x_values) + x_values*result_a(2)
     n_sigma = 0L
     while (n_sigma lt n_elements(sigma_lowe)) do begin 
       y_fit = sigma_lowe(n_sigma)*result_a(0)+result_a(0) + result_a(1)*alog(x_values) + x_values*result_a(2)
       new_chisq = total((y_values-y_fit)^2/measure_errors^2)
          if (new_chisq gt chisq + 1) then goto, doa0
          if (new_chisq le chisq + 1) then begin
             n_sigma = n_sigma + 1             
             y_fit = sigma_lowe(n_sigma)*result_a(0)+result_a(0)+ result_a(1)*alog(x_values) + x_values*result_a(2)
             new_chisq = total((y_values-y_fit)^2/measure_errors^2)
          endif
       endwhile 
      doa0:
       sigma_a(0) = abs(sigma_lowe(n_sigma)*result_a(0))
 
     ; do a1   
     y_fit = result_a(0) + result_a(1)*alog(x_values) + x_values*result_a(2)
     n_sigma = 0L
     while (n_sigma lt n_elements(sigma_lowe)) do begin 
       y_fit = result_a(0) + (sigma_lowe(n_sigma)*result_a(1)+result_a(1))*alog(x_values) + x_values*result_a(2)
       new_chisq = total((y_values-y_fit)^2/measure_errors^2)
          if (new_chisq gt chisq + 1) then goto, doa1
          if (new_chisq le chisq + 1) then begin
             n_sigma = n_sigma + 1             
             y_fit = result_a(0) + (sigma_lowe(n_sigma)*result_a(1)+result_a(1))*alog(x_values) + x_values*result_a(2)
             new_chisq = total((y_values-y_fit)^2/measure_errors^2) 
          endif
       endwhile 
      doa1:
       sigma_a(1) = abs(sigma_lowe(n_sigma)*result_a(1))
            
     ; do a2   
     y_fit = result_a(0) + result_a(1)*alog(x_values) + x_values*result_a(2)
     n_sigma = 0L
     while (n_sigma lt n_elements(sigma_lowe)) do begin 
       y_fit = result_a(0) + result_a(1)*alog(x_values) + x_values*(sigma_lowe(n_sigma)*result_a(2)+result_a(2))
       new_chisq = total((y_values-y_fit)^2/measure_errors^2)
          if (new_chisq gt chisq + 1) then goto, doa2
          if (new_chisq le chisq + 1) then begin
             n_sigma = n_sigma + 1             
             y_fit = result_a(0) + result_a(1)*alog(x_values) + x_values*(sigma_lowe(n_sigma)*result_a(2)+result_a(2))
             new_chisq = total((y_values-y_fit)^2/measure_errors^2) 
          endif
       endwhile 
      doa2:
      sigma_a(2) = abs(sigma_lowe(n_sigma)*result_a(2))
    fit_params = [result_a(0:2),sigma_a(0:2),chisq/(cnt_h-3.)]
    endif    
    
    if (cnt_fit le 3) then begin    
        a = [1,1]
        result_a = svdfit(x_values,y_values,a=a,Measure_errors=measure_errors,function_name='power_funct',sigma=sigma,yfit=yfit,chisq=chisq)       
                
     deg_free = cnt_h-2.
     if (deg_free eq 0.) then begin
        deg_free = 1
     endif   
     chinos = 0L
     while (chinos lt 15) do begin
         if (deg_free eq deg_freedom(chinos)) then begin
             min_chi = mean_chi(chinos)-frac_chi
             max_chi = mean_chi(chinos)+frac_chi
         endif     
      chinos = chinos + 1
     endwhile
     
     do_h4: 
     ; second fit
     if (chisq/(cnt_h-2.) lt min_chi) then begin 
     k_sigma = 0L
     while (k_sigma lt n_elements(sigma_e)) do begin           
       locs = where(measure_errors gt frac_err)
       sig_e = sigma_e(k_sigma)
       measure_errors(locs) = measure_errors(locs) - sig_e*measure_errors(locs) 
       result_a = svdfit(x_values,y_values,a=a,Measure_errors=measure_errors,function_name='power_funct',sigma=sigma,yfit=yfit,chisq=chisq)       
        if (chisq/(cnt_h-2.) gt max_chi) then goto, do_h3 
        if (chisq/(cnt_h-2.) lt min_chi) then begin
            k_sigma = k_sigma + 1 
        endif else begin
            k_sigma = n_elements(sigma_e)
        endelse
        endwhile    
       endif
     
     ;stop
     
     if (chisq/(cnt_h-2.) gt max_chi) then begin 
     k_sigma = 0L
     while (k_sigma lt n_elements(sigma_e)) do begin           
       sig_e = sigma_e(k_sigma)
       delta_e = x_max-x_min
       par_a0  = exp(result_a(0))
       par_a1  = -1.*result_a(1)
       diff_je = -1.0*par_a0*(par_a1/x_values^(1.0+par_a1))
       sig_j2  = sig_e*delta_e*diff_je/(2*x_values)
       err_y   = sqrt(err_h^2 + sig_j2^2)         
       err_y   = err_y/rates_h
       measure_errors = err_y
       
       result_a = svdfit(x_values,y_values,a=a,Measure_errors=measure_errors,function_name='power_funct',sigma=sigma,yfit=yfit,chisq=chisq)       
        if (chisq/(cnt_h-2.) lt min_chi) then goto, do_h4
        if (chisq/(cnt_h-2.) gt max_chi) then begin
            k_sigma = k_sigma + 1 
        endif else begin
            k_sigma = n_elements(sigma_e)
        endelse
        endwhile    
       endif
       do_h3:
       
  ; stop
       ; calculate uncertainty   
     ; do a0   
     y_fit = result_a(0) + result_a(1)*alog(x_values)
     n_sigma = 0L
     while (n_sigma lt n_elements(sigma_lowe)) do begin 
       y_fit = sigma_lowe(n_sigma)*result_a(0)+result_a(0) + result_a(1)*alog(x_values)
       new_chisq = total((y_values-y_fit)^2/measure_errors^2)
          if (new_chisq gt chisq + 1) then goto, dop0
          if (new_chisq le chisq + 1) then begin
             n_sigma = n_sigma + 1             
             y_fit = sigma_lowe(n_sigma)*result_a(0)+result_a(0)+ result_a(1)*alog(x_values)
             new_chisq = total((y_values-y_fit)^2/measure_errors^2)
          endif
       endwhile 
      dop0:
       sigma_a(0) = abs(sigma_lowe(n_sigma)*result_a(0))
 
     ; do a1   
     y_fit = result_a(0) + result_a(1)*alog(x_values)
     n_sigma = 0L
     while (n_sigma lt n_elements(sigma_lowe)) do begin 
       y_fit = result_a(0) + (sigma_lowe(n_sigma)*result_a(1)+result_a(1))*alog(x_values)
       new_chisq = total((y_values-y_fit)^2/measure_errors^2)
          if (new_chisq gt chisq + 1) then goto, dop1
          if (new_chisq le chisq + 1) then begin
             n_sigma = n_sigma + 1             
             y_fit = result_a(0) + (sigma_lowe(n_sigma)*result_a(1)+result_a(1))*alog(x_values)
             new_chisq = total((y_values-y_fit)^2/measure_errors^2) 
          endif
       endwhile 
      dop1:
       sigma_a(1) = abs(sigma_lowe(n_sigma)*result_a(1))
        
       fit_params = [result_a(0:1),0,sigma_a(0:1),0,chisq/(cnt_h-2.)]
    endif          

; the fit parameters must be converted as follows.
; h_params = [exp(result_a(0)),exp(result_a(0))*sigma(0),-1.*result_a(1),sigma(1),-1.0/result_a(2),sigma(2)/result_a(2)^2,chisq]     
  
;stop                                  
return,fit_params 
  
                    
end