c
c       The following are standard functions and subroutines used 
c       frequently by STEP and ULEIS data analysis programs
c        modified 10/7/98 fot Y2K
c
c       Contents:
c             subroutine convert_time(ptime,sktime,fktime)
c
c             integer function day_of_year(yy,mm,dd)
c
c             integer function IDAYS_PER_YEAR(IYEAR)
c
c             subroutine convert_to_sampextime(iyear,idoy,ihour,imin,iseconds,stime)
c
c             subroutine sampex_timcon(stime,yyyy,mo,da,hr,mn,se,doy,isotime)
c
c
c
c***************************************************
c
      subroutine convert_time(ptime,sktime,fktime)
c
c***************************************************
c     Takes the string ptime, containing the start and finish date and time
c     of the major frame, and creates two strings:
c     sktime is the start date and time
c     fk is the finish date and time
c
c     Revisions:           
c              10/6/95 by J. Dwyer  commented code
c              10/7/98 by J. Dwyer added dates past year 2000
c
      character*40 ptime   ! input string
      character*24 sktime,fktime  ! output strings
c
c      iso_time_c24(1:24)='    -  -  T  :  :       '
c                          123456789012345678901234
c
      if (ptime(2:2).eq.'9') then
          sktime(1:4)='19'//ptime(2:3)
      else
          sktime(1:4)='20'//ptime(2:3)
      end if    
      sktime(5:7)='-'//ptime(5:6)
      sktime(8:10)='-'//ptime(8:9)
      sktime(11:19)='T'//ptime(11:18)
      sktime(20:24)='     '
c
      if (ptime(21:21).eq.'9') then
          fktime(1:4)='19'//ptime(21:22)
      else
          fktime(1:4)='20'//ptime(21:22)
      end if  
      fktime(5:7)='-'//ptime(24:25)
      fktime(8:10)='-'//ptime(27:28)
      fktime(11:19)='T'//ptime(30:37)
      fktime(20:24)='     '
c
      return
      end   ! end convert_time
c
c
c
c
c***************************************************
c
       integer function day_of_year(yy,mm,dd)
c
c***************************************************
c
c    Takes the date and returns the number of the day (1-365) in the year  
c    yy = year (e.g. 1995)
c    mm = month (1-12)
c    dd = day
c
c     Revisions:
c                10/6/95 by J. Dwyer  Changed from subroutine to function and
c                                                  commented code.
c    
c
      integer yy, mm, dd, mm0
      integer dm(12)/31,28,31,30,31,30,31,31,30,31,30,31/  ! days per month
c
      mm0 = mm-1  
      day_of_year = dd
      if (mm0.eq.0) return
      do 4000 i=1,mm0
        day_of_year = day_of_year + dm(i)
4000    continue
      if (mm0.ge.2 .and. mod(yy,4).eq.0)
     1           day_of_year = day_of_year + 1      
c
      return
      end  ! end day_of_year
c
c
c
c
c
c
c****************************************************
c
        integer function idays_per_year(iyear)
c
c****************************************************
c
c    	Function to return the number of days per year for the 
c	add mod test 5/8/08   /gm
c      iyear = year (e.g. 1995)
c
c      Revisions:  10/7/98 by J. Dwyer added more leap years
c
c
	      integer	iyear
c
   	   if (mod(iyear,4).eq.0) then
	     	 idays_per_year=366
   	  else
   	  	idays_per_year=365
	     end if
c
       return
       end   ! end idays_per_year
c
c
c
c
c*****************************************************
c	    
       subroutine convert_to_sampextime(iyear,
     1  idoy,ihour,imin,iseconds,stime)
c
c*****************************************************
c
c   	This subroutine accepts a year, day of year, hour of day,
c	   minutes, and seconds of day and converts these to a 
c	   sampex time (seconds since midnight 1 January 1992).
c
c					J. Mazur  3/25/94
c
c   	Revisions:
c                 10/6/95 by J. Dwyer added line  integer idays_per_year
c
c
	      INTEGER	IYEAR	! year
        INTEGER	IDOY	! day of year
	      INTEGER	IHOUR	! hour of day
	      INTEGER	IMIN	! minutes of day
        integer    idays_per_year
	      INTEGER*4	ISECONDS ! seconds of day
	      INTEGER*4	STIME	! sampex time
c
	      INTEGER*4	IYDUM	! year counter
	      INTEGER*4	IDAYS	! day counter
c			
c	First zero the day counter (for multiple
c	calls to convert_to_sampextime)
	      IDAYS=0
c
c	Find number of days since midnight 1 Jan 1992
	      IYDUM=1992
	      DO WHILE(IYDUM.LT.IYEAR)
	         IDAYS = IDAYS + IDAYS_PER_YEAR(IYDUM)
	         IYDUM = IYDUM + 1
	      END DO
c	Add up the days, but subtract 1 since the first day 
c	of 1992 was day 1, not day 0.
	      IDAYS = IDAYS + IDOY - 1
c
c	Get the number of seconds since midnight 1 Jan 1992
      	STIME = (IDAYS*86400) + (IHOUR*3600) + (IMIN*60)+ ISECONDS
c
	      RETURN
	      END  ! end convert_to_sampextime
c
c
c
c
c*********************************************************
c
      subroutine sampex_timcon(stime,yyyy,mo,
     1             da,hr,mn,se,doy,isotime)
c
c*********************************************************
c	subroutine sampex_timcon(stime,yyyy,mo,da,hr,mn,se,doy,isotime)
c
c	subroutine to convert sampex time (seconds of 1992) to 
c	standard date, doy, etc.
c
c	gm	6/5/92
c		modifications:  
c		1/5/94		change error message to 
c				write on unit 6 instead of unit
c				5 to be compatible with batch jobs
c		6/8/95: 	extend end time to 2009
c		10/26/99	split implicit statement into two lines for
c				compatibility with new fortran compiler/gm
c				extend range to end of 2023 
c		20-Aug-2015	extend range to end of 2040 /gm
c
c	arguments:	stime 	= seconds since midnight 1/1/92
c				  i.e. stime = 1 corresponds to 
c					     00:00:01 1-Jan-92
c			yyyy  	= year (e.g. 1992)
c			mo	= month of year
c			da	= day of month	
c			hr	= hour of day
c			mn	= minute of hour
c			se 	= second of minute
c			doy 	= day of year (Jan. 1 = 1)
c			isotime = 20 character array  YYYY-MO-DA HR:MN:SE
c
c	Restrictions:   stime must be >0
c			no good beyond 12/31/2040 -- returns zeroes & 
c						     error message
c
	implicit double precision (a-h)
	implicit double precision (o-z)
	Integer*4 stime,yyyy,mo,da,hr,mn,se,doy
	character*20 isotime
	dimension amstart(12,2),yearstart(50),year(50)
	DATA aMSTART/1,32,60,91,121,152,182,213,244,274,305,335,
     *            1,32,61,92,122,153,183,214,245,275,306,336/,
     *  yearstart/0,366,731,1096,1461,1827,2192,2557,2922,3288,3653,
     *                      4018,4383,4749,5114,5479,5844,6210,6575,
     * 			    6940,7305,7671,8036,8401,8766,9132,9497,
     *                      9862,10227,10593,10958,11323,
     *              11688, 12054, 12419, 12784, 13149, 13515, 13880,
     *				14245, 14610, 14976, 15341, 15706, 16071, 16437,
     *				16802, 17167, 17532, 17898/
     *  year/1992,1993,1994,1995,1996,1997,1998,1999,2000,2001,2002,
     *                      2003,2004,2005,2006,2007,2008,2009,2010,
     *                      2011,2012,2013,2014,2015,2016,2017,2018,
     *                      2019,2020,2021,2022,2023,2024,2025,2026,
     *						2027,2028,2029,2030,2031,2032,2033,2034,
     *						2035,2036,2037,2038,2039,2040,2041/
c	check for time limit bounds
	if((stime.ge.0.).and.(stime.lt.(17898*86400))) goto 5
c	time out of bounds: zero results and type message
	write(6,1) stime
1	format(' illegal sampex_timcon() time: 'i10)
	yyyy=0
 	mo=0
	da=0
	hr=0
	mn=0
	se=0
	doy=0
	goto 200
c
c	calculate days since 1/1/92
c
5	dayno=dfloat(stime)/86400.d0
c	
c	find year number
c
	do 10 i=1,50
	iyear=i
	if((dayno.ge.yearstart(i)).and.(dayno.lt.yearstart(i+1)))
     *  goto 11
10	continue
11	yyyy=year(iyear)
c
c	check for leap year
c
	ileap=1
	if(mod(yyyy,4).eq.0) ileap=2
c
c	calculate day of year
c
	adoy=dayno - yearstart(iyear) +1.d0
	doy = adoy
c
c	calculate month
c
	do 15 i=1,11
	mo=i
	if(adoy.lt.amstart(i+1,ileap)) goto 20
15	continue
	mo=12
20	da = adoy - amstart(mo,ileap) + 1.d0
c
c	calculate hr,mn,se
c
c	seconds of the day:
	secday = dfloat(stime) - 86400.d0*dint(dayno)
	ahr = secday/3600.d0
 	hr = ahr
	amn = (secday - dint(ahr)*3600.d0)/60.d0
	mn=amn
	se = secday - dint(ahr)*3600.d0 - dint(amn)*60.d0
c
c	write out isotime
c
200	write(isotime,50) yyyy,mo,da,hr,mn,se
50	format( i5'-'i2.2'-'i2.2,i3.2':'i2.2':'i2.2)
	return
	end
