	function tof_ch_to_ns(nsc, channel)
c
c	gm 4/17/02
c
c	itype = 1 (entry tof_ch_to_ns)
c	input:  nsc (S/C:  1=Ahead;  2=Behind)
c		channel
c	output: tof (ns)
c
c	modification history:
c		17-April-02	adapted from uleis routine
c				see PWalpole e-mail 4/9/02
c		4-Feb-2005	adapt for fm1 2 segment linear fit /gm
c		7-Feb-2005	add inversion:  tof to ch; offsets /gm
c		22-Aug-2006	fix bug (tof_offset_cable not keyed to
c				the two units) /gm
c		14-Oct-2010	change location of tcal.dat files /gm

	dimension istart(2)
	data istart/2*0/     ! first call for fm1, fm2
	dimension c_slope(2,2,2)  ! c_slope(itype, nsc, segment)
	dimension c_int(2,2,2)    ! c_int(itype, nsc, segment)
	dimension c_break(2,2)    ! break channel number (itype,nsc)
	dimension tof_offset_cable(2)  ! offset due to cable lengths

	itype = 1

50	if(istart(nsc).gt.0) goto 300
	istart(nsc)=1
	goto (100,200), nsc	! read in calibrations if at start

c	read in fm1 coefficients
100	open(unit=60,name=
     *   '/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM1/TCAL.DAT;8',
     *   status='old')
	goto 250

200	open(unit=60,name=
     *   '/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM2/TCAL.DAT;6',
     *   status='old')


c	skip main header lines
250	read(60, 110)
c	
c	loop to read both sets of coefficients
c
	do 120 i=1,2
	read(60, 110)
110	format(x)
	read(60,*) c_int(i,nsc,1), c_slope(i,nsc,1), c_break(i,nsc)
120	read(60,*) c_int(i,nsc,2), c_slope(i,nsc,2)
c
c	read in the tof offset due to cable lengths
c
	read(60,*) tof_offset_cable(nsc)

	close (60)

300	goto(350,400), itype



c	channel to ns conversion
350	iseg = 1
	if(channel.ge.c_break(itype,nsc)) iseg = 2

	tof_ch_to_ns = c_int(itype,nsc,iseg) +
     *                 c_slope(itype,nsc,iseg)*channel

	tof_ch_to_ns = tof_ch_to_ns + tof_offset_cable(nsc)   ! cable length 


	if(tof_ch_to_ns.lt.0.) tof_ch_to_ns = 0.

	return



	entry tof_ns_to_ch(nsc, tof)
	itype = 2
	goto 50	

400	iseg = 1
	if(tof.ge.c_break(itype,nsc)) iseg = 2

	tof_ns_to_ch = c_int(itype,nsc,iseg) +
     *                 c_slope(itype,nsc,iseg)*tof

c	now subtract out correction due to cable lengths
	tof_ns_to_ch = tof_ns_to_ch 
     *          - tof_offset_cable(nsc)*c_slope(itype,nsc,iseg)



	if(tof_ns_to_ch.lt.0.) tof_ns_to_ch=0   ! no negative ch #s
	if(tof_ns_to_ch.gt.511.) tof_ns_to_ch=511 ! don't exceed 511

	return
	end

