		subroutine ssd_ch_to_mev(nsc, igain, channel, mev)
c
c	gm 4/17/02
c
c	input: channel (number)
c	       igain (0=high;  1=low)
c	       nsc (S/C:  1=Ahead;  2=Behind)
c
c	note:  in subroutine, 
c			itype = 1:  ch to MeV call
c			itype = 2:  MeV to ch call
c
c	output: MeV
c
c	modification history:
c		17-Apr-02	test version 
c				see P Walpole e-mail 4/9/02
c		1-Feb-05	flight polynomial fits installed /gm
c		4-Feb-05	inversion (MeV to channel) installed /gm
c		24-Aug-05	make call variable order same for both
c				ch to meV and meV to ch calls!  gm
c		29-Aug-05	increase dimension 4 of coef (..) to
c				accomodate 3rd order fits! /gm
c		14-Oct-2010	change directory location of ecal.dat files /gm
c
	real mev
c
	dimension istart(2)
	data istart/2*0/     ! first call for fm1, fm2
	dimension norder(2,2,2)    ! order of fit (itype, s/c, gain)
	dimension coef(2,2,2,4)    ! coefficients (itype, S/C, gain, order)
	dimension c_range(2,2,2,2)   ! channel range of polynomial fits
c				    c_range(itype, s/c,gain,low vs high bound)
	dimension c_linear(2,2,2)  ! linear gains (itype,S/C, gain)
	common /poly/ norder, coef, c_range, c_linear
	
	itype = 1

50	if(istart(nsc).gt.0) goto 300
	istart(nsc)=1
	goto (100,200), nsc	! read in calibrations if at start

c	read in fm1 coefficients
100	open(unit=60,name=
     *   '/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM1/ECAL.DAT;4',
     *   status='old')
	goto 250

200	open(unit=60,name=
     *   '/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM2/ECAL.DAT;1',
     *   status='old')


c	skip main header lines
250	read(60, 110)
c	
c	loop to read both sets of coefficients
c
	do 120 i = 1,2
	read(60, 110)
110	format(x)
	read(60,*) c_linear(i,nsc,1)       ! linear gain MeV/ch
	read(60,*) norder(i,nsc,1), 
     *      (c_range(i,nsc,1,j),j=1,2), (coef(i,nsc,1,j),
     *                                 j=1,norder(i,nsc,1)+1) ! high gain
	read(60,*) c_linear(i,nsc,2)       ! linear gain MeV/ch
120	read(60,*) norder(i,nsc,2), 
     *      (c_range(i,nsc,2,j),j=1,2), (coef(i,nsc,2,j),
     *                                 j=1,norder(i,nsc,2)+1) ! low gain
	close (60)




c	calculate MeV
300	if(itype .eq. 1) mev = convert_to_mev(itype, nsc, igain, channel)
	if(itype .eq. 2) 
     *         call convert_to_channel(itype, nsc, mev, igain, channel)

c	do not return negative MeV value
	if(mev.lt.0.0) mev=0.0
	if(channel.lt.0.) channel=0.
	if(channel.gt.2047.) channel=2047.


	return

	entry ssd_mev_to_ch(nsc, igain, channel, mev)
c	returns channel & gain setting
	itype = 2
	goto 50

	end

	function convert_to_mev(itype, nsc, igain, channel)
	
	real mev


	dimension norder(2,2,2)    ! order of fit (itype,s/c, gain)
	dimension coef(2,2,2,4)    ! coefficients (itype,S/C, gain, order)
	dimension c_range(2,2,2,2)   ! channel range of polynomial fits
c				    c_range(itype,s/c,gain,low vs high bound)
	dimension c_linear(2,2,2)  ! linear gains (itype, S/C, gain)
	common /poly/ norder, coef, c_range, c_linear
	
	mev = 0.
	c_save = channel

300	if(c_save.lt.c_range(itype,nsc,igain+1,1)) goto 400
	if(c_save.gt.c_range(itype,nsc,igain+1,2)) goto 500 
c
c	channel is within the bounds of the polynomial fit, so just use it
c
	do 350 j=1,norder(itype, nsc, igain+1) + 1
350	mev = mev + coef(itype, nsc, igain+1, j)*c_save**(j-1)
	
360	convert_to_mev = mev

	if(convert.lt.0.) convert=0.   ! no negative values returned

	return


c	case where the channel is outside the limits of the polynomial fit
c	in this case, calculate the polynomial fit value at its limit,
c	and then do a linear extrapolation up or down

c	channel is lower than polynomial fit range
400	c_save = c_range(itype, nsc,igain+1,1)
	goto 600

c	channel is higher than polynomial fit range
500	c_save = c_range(itype, nsc,igain+1,2)

600	do 650 j=1,norder(itype, nsc, igain+1) + 1
650	mev = mev + coef(itype, nsc, igain+1, j)*c_save**(j-1)
	mev = mev + (channel - c_save)*c_linear(itype, nsc,igain+1)

	goto 360

	end
	subroutine convert_to_channel(itype, nsc, mev, igain, channel)

	
	real mev


	dimension norder(2,2,2)    ! order of fit (itype,s/c, gain)
	dimension coef(2,2,2,4)    ! coefficients (itype,S/C, gain, order)
	dimension c_range(2,2,2,2)   ! channel range of polynomial fits
c				    c_range(itype,s/c,gain,low vs high bound)
	dimension c_linear(2,2,2)  ! linear gains (itype, S/C, gain)
	dimension channel_out(2), c_save(2)
	common /poly/ norder, coef, c_range, c_linear
	
	
c
c	calculate both high & low gain channels for this MeV
c
	do 1000 igain = 0,1

	channel_out(igain+1)=0.
	c_save(igain+1) = mev


	if(c_save(igain+1).lt.c_range(itype,nsc,igain+1,1)) goto 400
	if(c_save(igain+1).gt.c_range(itype,nsc,igain+1,2)) goto 500 
	goto 300

c	case where the mev value is outside the limits of the polynomial fit
c	in this case, calculate the polynomial fit value at its limit,
c	and then do a linear extrapolation up or down

c	channel is lower than polynomial fit range
400	c_save(igain+1) = c_range(itype, nsc,igain+1,1)
	goto 600

c	channel is higher than polynomial fit range
500	c_save(igain+1) = c_range(itype, nsc,igain+1,2)

600	do 650 j=1,norder(itype, nsc, igain+1) + 1
650	channel_out(igain+1) =
     *   channel_out(igain+1)  + 
     *   coef(itype, nsc, igain+1, j)*c_save(igain+1)**(j-1)
	channel_out(igain+1)  = 
     *   channel_out(igain+1) + 
     *   (mev - c_save(igain+1))*c_linear(itype, nsc,igain+1)

	goto 1000


c
c	channel is within the bounds of the polynomial fit, so just use it
c
300	do 350 j=1,norder(itype, nsc, igain+1) + 1
350	channel_out(igain+1)  = 
     *    channel_out(igain+1) + 
     *    coef(itype, nsc, igain+1, j)*c_save(igain+1)**(j-1)
	



1000	continue
	
c	select ramp depending on channel number calculated
	igain = 0
	if(channel_out(1).gt.2048) igain=1

	channel=channel_out(igain+1)

c	don't return negative or values greater than 2048
	if(channel.lt.0.) channel = 0
	if(channel.gt.2048.) channel = 2048

	end
