	subroutine fme_to_channel(xbin,ybin,nsc,ch_tof,ch_ssd,igain)
c
c	routine to calculate sit rate bin space from input channels
c	and also do inverse calculation
c
c	23-Apr-2002    gm
c
c	modification history:
c		23-Apr-2002	initial version
c		24-Aug-2005	make variable list identical for
c				calls to ssd_to_ch, tof_ch etc./gm
c
c
	data const/0.021/
c
	xctr = xbin
	yctr = ybin
c
	amass = exp((7./128.)*yctr - 1.)
	einc = exp((1./16.)*xctr - 5.5)
c
c
	tof = sqrt(1/(const*einc))

	ch_tof = tof_ns_to_ch(nsc,tof)
c
c
	essd = amass/(const*tof**2)
c
	call ssd_mev_to_ch(nsc,igain,ch_ssd,essd)
c
	return

	entry channel_to_fme(xbin,ybin,nsc,ch_tof,ch_ssd,igain)

c	skip events with channels out of bounds
	if(ch_tof.le.5.) goto 100
	if(ch_tof.ge.511) goto 100
	if(ch_ssd.le.5.) goto 100
	if(ch_ssd.ge.2047) goto 100



	tof = tof_ch_to_ns(nsc,ch_tof)

	call ssd_ch_to_mev(nsc,igain,ch_ssd,essd)

	amass = const*essd*tof**2
c	type *, ' const, essd, tof: ', const, essd, tof
c	type *,' essd, amass: ', essd, amass
	einc = essd/amass

	xbin = (alog(einc)+5.5)*16.
	ybin = (alog(amass)+1.)*128./7.

	return

c	trap for 0 or max channel numbers
c
100	xbin=0.
	ybin=0.

	end
