	subroutine convert_hk(hk, a_item)
c
c	converts 8 hk parameters to physical units
c
c	gm	15-Jul-2005
c		15-Oct-2010	change location of hk.dat files /gm


c	character  cal_file*120(2),cal_filename*120,cal_header*80
	character(120) :: cal_file(2), cal_filename   ! absoft syntax; see f95 ref document p 11
	character(80) :: cal_header      ! absoft syntax; see f95 ref document p 11
	integer hk(8)
	dimension a_item(8), a0(2,8), a1(2,8), vref(2), vslope(2)
c	character hk_name*15(8)
	character(15) :: hk_name(8)     ! absoft syntax; see f95 ref document p 11
        common /unit/ iunit   ! 0 = etu, 1 = fm1; 2 = fm2

	data ifirst/0/
	data hk_name(1)/'HV monitor     '/,
     *       hk_name(2)/ 'DTOF temp     '/,
     *       hk_name(3)/'foil temp      '/,
     *       hk_name(4)/'ssd temp       '/,
     *       hk_name(5)/'+3.3V monitor  '/,
     *       hk_name(6)/'+2.4V monitor  '/,
     *       hk_name(7)/'+5 V digital   '/,
     *       hk_name(8)/'+6V monitor    '/

	data cal_file(1)
     *   /'/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM1/HK.DAT;2'/,
     *   cal_file(2)
     *   /'/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM2/HK.DAT;3'/


	if(ifirst.eq.1) goto 110
c
c	read in calibration files if first call
c
	ifirst=1
	do 100 i=1,2
	open(unit=80,name=cal_file(i),action='read')
	inquire(80,name=cal_filename)
	read(80,10) cal_header
10	format(a80)
c	write(40,15) cal_filename, cal_header
15	format(/' input calibration file for hk: ',a120,/,
     *          ' file header: ',a80,/)
	do 90 j=1,8
	read(80,*) a0(i,j),a1(i,j)
c	write(40,20) hk_name(i), a0(i,j),a1(i,j)
90	continue
20	format( ' coefficients for 'a15,2f10.5)
	read(80,*) vref(i),vslope(i)
c	write(40,21) vref(i),vslope(i)
21	format(' +6V line correction coefficients for temp: ',
     *   'reference = ',f6.4' V; slope = ',f7.4' deg/V')
100	close(80)


c	now convert to physical units
c	ref:  PWalpole e-mail 8/20/04; and 2/1/05
110	do 115 j=1,8
115	a_item(j)=a0(iunit,j) + a1(iunit,j)*hk(j)

c	Mux no	item
c	0	hv
c	1	dtof temp
c	2	foil temp
c	3	ssd temp
c	4	+3.3 V monitor
c	5	+2.4 V monitor
c	6	+5Digital V monitor
c	7	+6 V monitor

c	now correct temperatures for variation with the 6V regulation
c	(ref:  P Walpole e-mail 2/1/05)

	do 120 i=2,4
120	a_item(i)=a_item(i)-(vref(iunit)-a_item(8))*vslope(iunit)
c	put the correction voltage in mux item 1 
c	a_item(1)=-(vref(iunit)-a_item(8))*vslope(iunit)
c
c	now fill in channel values for thermistors (*cal version only*)
c	do 125 i=2,4
c125	a_item(i+3)=hk(i)

c
	return
	end
