c	sit_cal_table_generator

c	program to read sit calibration tables and produce output
c	tables to be read into IDL analysis routines
c
c	gm      4-Aug-2006
c
c	Modification history:
c		4-Aug-2005	initial version
c
	include 'sct_include.f95'
	character date, time, zone
	integer date_time(9)

c
c	get run time
c
        call date_and_time(date,time,zone,date_time)
	do 10 i=1,6
10	rtime(i)=date_time(i+1)
	rtime(3)=date_time(1)   ! fix up month
c
c       get the unit number (etu, fm1, fm2) 
c
c
c
c	write out the tof calibration file
	call tof_file
c
c	write out the energy calibration file
	call energy_file
c
c	write out the housekeeping file
c
	call housekeeping_file
c
c	write out the mass file
	call mass_energy_file

	end


	subroutine tof_file
c
c	writes out the tof calibration
c
	include 'sct_include.f95'
	dimension tof_array(512,2)
	
	write(outfile,10) 
10	format('SIT_tof_calibration.dat')
        open(unit=34,name=outfile,status='new',recl=30000)
	write(34,20) rtime
20	format(' SIT- tof calibration generated: ',
     *    i2'/'i2.2'/'i4.4,i3':'i2.2':'i2.2,/,
     *    ' tof (ns)')



c	set up dummy variables and loop through all tof channels

	ssd_ch=500
	igain=1

	do 100 iunit=1,2
	do 100 tof_ch = 0,511
	call  sit_convert(iunit, float(ssd_ch), igain, float(tof_ch),
     *     Einc_tof, Einc_ssd, aMass, Emeas, tof_array(tof_ch+1,iunit))
	if(tof.le.0.) tof=0
100	continue

	write(34,90) tof_array
90	format(1x,1pe15.6)

	close(34)
	return
	end


	subroutine energy_file
c
c	writes out the tof calibration
c
	dimension energy_array(2048,2,2)
	include 'sct_include.f95'
	
	write(outfile,10) 
10	format('SIT_energy_calibration.dat')
        open(unit=34,name=outfile,status='new',recl=30000)
	write(34,20) rtime
20	format(' SIT- ssd calibration generated: ',
     *    i2'/'i2.2'/'i4.4,i3':'i2.2':'i2.2,/,
     *  ' Energy (MeV) hi gain   Energy (MeV) lo gain')

c	set up dummy variables and loop through all tof channels
	tof_ch = 256
	igain=1

	do 100 channel = 0,2047
	do 100 igain=0,1
	do 100 iunit=1,2
	ichannel=channel     ! required for absoft compile subscript must be integer
	call  sit_convert(iunit, channel, igain, float(tof_ch),
     *     Einc_tof, Einc_ssd, aMass, 
     *     Energy_array(ichannel+1,igain+1,iunit), tof )
	if(Energy_array(ichannel+1,igain+1,iunit).le.0.) 
     *     Energy_array(ichannel+1,igain+1,iunit)=0.
100	continue
1000	continue

	write(34,90) Energy_array
90	format(1x,1pe15.6)

	close(34)
	return
	end



	subroutine housekeeping_file

c	writes out the housekeeping file
c
	include 'sct_include.f95'
	integer hk(8)
	dimension a_item(8),array_hk(256,8,2)
	
	write(outfile,10) 
10	format('SIT_hk_calibration.dat')
        open(unit=34,name=outfile,status='new',recl=30000)
	write(34,20) rtime
20	format(' SIT- ssd calibration generated: ',
     *    i2'/'i2.2'/'i4.4,i3':'i2.2':'i2.2,/,
     *  ' HV volts, dtof temp (C), foil temp (C), SSD temp(C),',
     *  ' +3.3V, +2.5V, +5Dig V, +6V')


c	Mux no	item
c	0	hv
c	1	dtof temp
c	2	foil temp
c	3	ssd temp
c	4	+3.3 V monitor
c	5	+2.4 V monitor
c	6	+5Digital V monitor
c	7	+6 V monitor

c	now convert to physical units


	do 100 iunit=1,2
	do 100 i=0,255
	do 110 j=1,8
110	hk(j)=i
c	thic call puts all 8 values into a_item
	call convert_hk(hk,a_item)
	do 120 j=1,8
120	array_hk(i+1,j,iunit)=a_item(j)
100	continue

	write(34,125) array_hk
125	format(1x,1pe11.3)

	close (34)
	return
	end

c
	subroutine mass_energy_file
c	write out the mass and incident energy file
c
	include 'sct_include.f95'
	dimension einc_tof_array(2048,2,512,2)
	dimension einc_ssd_array(2048,2,512,2)
	dimension amass_array(2048,2,512,2)
c	                         e ch, gain, tof ch, sc

	write(outfile,10) 
10	format('SIT_einc_tof_array.dat')
        open(unit=34,name=outfile,status='new',recl=30000)
	write(outfile,11) 
11	format('SIT_einc_ssd_array.dat')
        open(unit=35,name=outfile,status='new',recl=30000)
	write(outfile,12) 
12	format('SIT_amass_array.dat')
        open(unit=36,name=outfile,status='new',recl=30000)

	write(34,20) rtime
20	format(' SIT-einc_tof calibration generated: ',
     *    i2'/'i2.2'/'i4.4,i3':'i2.2':'i2.2,/,
     *  8(' einc_tof,'))
	write(35,21) rtime
21	format(' SIT-einc_ssd calibration generated: ',
     *    i2'/'i2.2'/'i4.4,i3':'i2.2':'i2.2,/,
     *  8(' einc_ssd,'))
	write(36,22) rtime
22	format(' SIT-amass calibration generated: ',
     *    i2'/'i2.2'/'i4.4,i3':'i2.2':'i2.2,/,
     *  8(' mass,'))


c	close unit 122 (kal file) since it was left open from earlier calls to tof_file, energy_file,
c		and housekeekping_file subroutines (setup_special closes 122 after readin)  /gm
	close(122)
	do 100 iunit=1,2
		if( iunit .eq. 1) then
			call setup_special(iunit)
		endif
		if( iunit .eq. 2) then
			call setup_special(iunit)
		endif	
	do 100 i=0,511
	tof_ch=i
	if(mod(i,50).eq.0)
     *	  type *, ' energy-mass files fraction complete: ',float(i)/511.
	do 100 j=0,2047
	ssd_ch=j
	do 100 k=0,1
100	call sit_convert(iunit, float(ssd_ch), k, float(tof_ch),
     *     Einc_tof_array(j+1,k+1,i+1,iunit), 
     *     Einc_ssd_array(j+1,k+1,i+1,iunit), 
     *     aMass_array(j+1,k+1,i+1,iunit), Emeas, tof )


	write(34,90) einc_tof_array
	close(34)
	type *, ' einc_tof_array written'

	write(35,90) einc_ssd_array
	close(35)
	type *, ' einc_ssd_array written'

	write(36,90) amass_array
	close(36)
	type *, ' amass_array written'



90	format(8(1x,1pe10.4))

	return
	end
	subroutine setup_special(nsc)
c
c	routine for sit_cal_table_generator to read in sitmr.kal tables
c	for the 2 units when making the mass tables -- allows different sitmr
c	tables for the 2 units   /gm   9/9/2010
c
	real Einc_array(1000),tof_array(1000,50),
     *     Emeas_array(1000,50),Mass_array(50)
	real Edep_array(1000), tof_edep(1000,50)
	integer Einc_index, Edep_index, Einc_index_s, Edep_index_s
     *          , tof_first(50),Emeas_first(50)
	character*10 ibuf
	character*120 infile	

	common /tables/ Einc_array,tof_array,
     *     Emeas_array,Mass_array,Einc_index,Mass_index,Edep_index
     *     ,Edep_array, tof_edep
	common /search/ Einc_index_s,Edep_index_s,mass_index_s
     *          , tof_first,Emeas_first
        common /inputs/ iunit, idate
	data istart/0/

c	check to see if this routine has been called already; if so,
c	just return   6/18/99
c	if(istart.gt.0) return    -- commented out 9/9/2010 /gm
c	istart=1
c	**************** rezero the input file index counters ! ************* 9/9/2010
	Einc_index=0
c
c	use the file fmX_sitmr.kal from the local directory!
c
c	write(infile,60) nsc, nsc
c60	format('$USER:[MASON.STEREO.FLIGHT_TABLES.fm'i1,
c     *   ']fm'i1'_sitmr.kal;')
c ********************************* modified 9/9/2010 to remove version numbers /gm *****************
c ********************************* modified 10/15/2010 to have both files in default folder /gm ********
	if(nsc .eq. 1) then
c	  infile = '/Users/masongm1/Programs/fortran_vax/SIT/cal_table_generator/FM1/FM1_SITMR.KAL'
	  infile = 'fm1_sitmr.kal'
	else
c  	  infile = '/Users/masongm1/Programs/fortran_vax/SIT/cal_table_generator/FM2/FM2_SITMR.KAL'
	  infile = 'fm2_sitmr.kal'
	endif


	type *, 'subroutine setup_special opening inut file: ',infile
        OPEN(UNIT=122,NAME=infile,status='old',action='read',recl=32000)




c	infile = '$USER:[MASON.STEREO.FLIGHT_TABLES.GENERATOR]'
c	if(nsc.eq.1) infile = infile(1:44)//'fm1_sitmr.kal'
c	if(nsc.eq.2) infile = infile(1:44)//'fm2_sitmr.kal'
c	type *, infile
c	OPEN(UNIT=122,NAME=infile,status='old',action='read',recl=32000)


10	read(122, 20) ibuf
20	format(a10)
	if(ibuf(5:10).ne.'Masses') goto 10
	read(ibuf, 25) Mass_index
25	format(i3)
	read(122,*) (mass_array(i),i=1,mass_index)
	read(122,20) ibuf

c

50	Einc_index=Einc_index+1
	i=Einc_index
	read(122,*,end=1000) Einc_array(i),(tof_array(i,j),
     *    emeas_array(i,j),j=1,mass_index)
	goto 50
1000	continue
	type *, ' sitmr table read in by sitmr_special routine'
	close(122)

	Einc_index=Einc_index-1	

c	do 675 i=1,Einc_index-1
c675	write(6,676) Einc_array(i),(tof_array(i,j),
c     *    Emeas_array(i,j),j=10,mass_index)
c676	format(151(1pe11.3,','))
	


c	calculate search step sizes

	Einc_index_s = sqrt(float(Einc_index))
	Mass_index_s = sqrt(float(Mass_index))
c
c	find the first non-zero tof values in the tof & Emeas arrays
c
	do 650 j=1,Mass_index
	do 600 i=1,1000
	if(tof_array(i,j).le.0) goto 600
	tof_first(j)=i
	goto 650
600	continue
650	continue


	do 850 j=1,Mass_index
	do 800 i=1,1000
	if(Emeas_array(i,j).le.0.) goto 800
	Emeas_first(j)=i
	goto 850
800	continue
850	continue

c
c	now re-interpolate to get arrays with time of flights
c	indexed on a common array of E measured
c
c	first, fill up Edep_array from 100 keV to 200 MeV by 3% steps
c	** changed lower energy bound 2/26/07**
	Edep_array(1)=0.1
	i=1
200	i=i+1
	Edep_array(i)=Edep_array(i-1)*1.03
	if(Edep_array(i).lt.200.) goto 200
	Edep_index = i   ! length of array
	Edep_index_s = sqrt(float(Edep_index))  ! search index

c
c	now, for each mass in the table, find TOFs at each 
c	value of the Edep array
c
	do 300 i=1,mass_index
	do 300 j=1,Edep_index
	call find_tof(nsc, i, Edep_array(j), tof_edep(j,i))
300	continue
c
c	write out kaleidagraph file   -- reactivated 4/15/2011 /gm
c
	if( nsc .eq. 1 ) then 
		open(unit=166,name='fm1_Edep_array.kal',status='new',recl=32000)
	endif
	if( nsc .eq. 2 ) then 
		open(unit=166,name='fm2_Edep_array.kal',status='new',recl=32000)
	endif	
	write(166,400) (mass_array(i),i=1,mass_index)
400	format(' Edep,',50('Tof mass'f5.1','))
	do 500 i=1,edep_index
500	write(166,501) edep_array(i),(tof_edep(i,j),
     *   j=1,mass_index)
501	format( 101(1pe12.3','))
	close(166)

	return
	end

c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/sit_convert.f95'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/convert_hk.f95'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/ssd_ch_to_mev.f95'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/tof_ch_to_ns.f95'
