c	program test_sit_convert
100	type *, ' Enter: nsc, ssd_ch, igain, tof_ch'
	read(*,*) nsc, ssd_ch, igain, tof_ch
	call sit_convert(nsc, ssd_ch, igain, tof_ch, 
     *     Einc_tof, Einc_ssd, aMass, Emeas, tof )
	type *, ' Einc_tof: ', Einc_tof
	type *, ' Einc_ssd: ', Einc_ssd
	type *, ' Mass: ', aMass
	type *, ' Emeas: ', Emeas
	type *, ' tof: ', tof
	goto 100
200	end


	subroutine  sit_convert(nsc, ssd_ch, igain, tof_ch, 
     *     Einc_tof, Einc_ssd, aMass, Emeas, tof )

c
c	Converts STEREO/SIT PHA data to physical units
c
c	gm  4/17/02  -- note:  include stmnts changed 8/23/05, nothing else
c	gm 8/24/05	-- ordering of variables in ssd_ch.. and tof_ch
c			changed
c	gm 9/21/05	pass nsc to subroutine setup
c	gm 4/28/06	change 'mass' in call to amass
c			in subroutine find_mass, explicitly set
c			m_index if you run off end of search loop,
c			otherwise m_index is set = 1 and gives
c			bad interpolations
c
c********************************************************************
c
c	INPUT VARIABLES:  	type	content
c		nsc		i	S/C:  1=Ahead; 2=Behind
c		ssd_ch		r	ssd_channel
c		igain		i	0=high, 1=low
c		tof_ch		r	tof channel
c
c
c	OUTPUT VARIABLES:
c		Einc		r	Incident energy (MeV/n)
c		Mass		r	Mass (AMU)
c		Emeas		r	SSD measured energy
c		TOF		r	measured TOF
c
c********************************************************************
c
c	Modification history:
c		17-Apr-2002	Adapted from uleis_convert /gm
c		28-Apr-2006	declare mass real
c

	character*100 dsn  



c	convert to tof, energy


	call ssd_ch_to_mev(nsc, igain, ssd_ch, Emeas)
	tof = tof_ch_to_ns(nsc, tof_ch)

c
c	find mass, incident energy
c

	call sit_mass(nsc, tof, Emeas, amass, Einc_tof, Einc_ssd)
c


	return


	end
	subroutine sit_mass(nsc, tof, Emeas, tof_mass, 
     *       Einc_tof, Einc_ssd) 

c
c	gm 4/17/2002
c
c	input:  nsc, tof, Emeas 
c	units:   #    ns    MeV
c
c	output:  tof_mass, einc_tof,  einc_ssd
c	units:     ns      MeV/n       MeV/n
c
c	Modification history:
c		17-Apr-2002	adapted from uleis_mass / gm
c

	data istart/0/
c	read in tables if first call
	if(istart.eq.0) call setup(nsc)
	istart=1
c
c
	call find_mass(nsc, tof, Emeas, tof_mass) 

	call find_einc(nsc, tof, Emeas, tof_mass, einc_tof, einc_ssd) 


	return
	end
	subroutine setup(nsc)

	real Einc_array(1000),tof_array(1000,50),
     *     Emeas_array(1000,50),Mass_array(50)
	real Edep_array(1000), tof_edep(1000,50)
	integer Einc_index, Edep_index, Einc_index_s, Edep_index_s
     *          , tof_first(50),Emeas_first(50)
	character*10 ibuf
	character*120 infile	

	common /tables/ Einc_array,tof_array,
     *     Emeas_array,Mass_array,Einc_index,Mass_index,Edep_index
     *     ,Edep_array, tof_edep
	common /search/ Einc_index_s,Edep_index_s,mass_index_s
     *          , tof_first,Emeas_first
        common /inputs/ iunit, idate
	data istart/0/

c	check to see if this routine has been called already; if so,
c	just return   6/18/99
	if(istart.gt.0) return
	istart=1
c
c	use the file fmX_sitmr.kal from the local directory!
c
	write(infile,60) nsc
60	format('fm',i1,'_sitmr.kal' )
	type *, ' opening inut file: ',infile
        OPEN(UNIT=122,NAME=infile,status='old',recl=32000)




c	infile = '$USER:[MASON.STEREO.FLIGHT_TABLES.GENERATOR]'
c	if(nsc.eq.1) infile = infile(1:44)//'fm1_sitmr.kal'
c	if(nsc.eq.2) infile = infile(1:44)//'fm2_sitmr.kal'
c	type *, infile
c	OPEN(UNIT=122,NAME=infile,status='old',recl=32000)


10	read(122, 20) ibuf
20	format(a10)
	if(ibuf(5:10).ne.'Masses') goto 10
	read(ibuf, 25) Mass_index
25	format(i3)
	read(122,*) (mass_array(i),i=1,mass_index)
	read(122,20) ibuf

c

50	Einc_index=Einc_index+1
	i=Einc_index
	read(122,*,end=1000) Einc_array(i),(tof_array(i,j),
     *    emeas_array(i,j),j=1,mass_index)
	goto 50
	type *, ' sitmr table read in'
1000	continue
	Einc_index=Einc_index-1	

c	do 675 i=1,Einc_index-1
c675	write(6,676) Einc_array(i),(tof_array(i,j),
c     *    Emeas_array(i,j),j=10,mass_index)
c676	format(151(1pe11.3,','))
	


c	calculate search step sizes

	Einc_index_s = sqrt(float(Einc_index))
	Mass_index_s = sqrt(float(Mass_index))
c
c	find the first non-zero tof values in the tof & Emeas arrays
c
	do 650 j=1,Mass_index
	do 600 i=1,1000
	if(tof_array(i,j).le.0) goto 600
	tof_first(j)=i
	goto 650
600	continue
650	continue


	do 850 j=1,Mass_index
	do 800 i=1,1000
	if(Emeas_array(i,j).le.0.) goto 800
	Emeas_first(j)=i
	goto 850
800	continue
850	continue

c
c	now re-interpolate to get arrays with time of flights
c	indexed on a common array of E measured
c
c	first, fill up Edep_array from 10 keV to 200 MeV by 3% steps
c
	Edep_array(1)=0.1
	i=1
200	i=i+1
	Edep_array(i)=Edep_array(i-1)*1.03
	if(Edep_array(i).lt.200.) goto 200
	Edep_index = i   ! length of array
	Edep_index_s = sqrt(float(Edep_index))  ! search index

c
c	now, for each mass in the table, find TOFs at each 
c	value of the Edep array
c
	type *, mass_index, (mass_array(i),i=1,mass_index)

	do 300 i=1,mass_index
	do 300 j=1,Edep_index
	call find_tof(nsc, i, Edep_array(j), tof_edep(j,i))
300	continue
c
c	write out kaleidagraph file
c
	open(unit=166,name='Edep_array.kal',status='new',
     *    recl=32000)
	write(166,400) (mass_array(i),i=1,mass_index)
400	format(' Edep,',50('Tof mass'f5.1','))
	do 500 i=1,edep_index
500	write(166,501) edep_array(i),(tof_edep(i,j),
     *   j=1,mass_index)
501	format( 101(1pe12.3','))


	return
	end

	subroutine find_tof(nsc, m_index, Edep, tof)

c	input: mass index, energy deposit
c	output:  tof

	real Einc_array(1000),tof_array(1000,50),
     *     Emeas_array(1000,50),Mass_array(50)
	real Edep_array(1000), tof_edep(1000,50)
	integer Edep_index, e_index,Einc_index,Einc_index_s,Edep_index_s
     *          , tof_first(50),Emeas_first(50)
	
	common /tables/ Einc_array,tof_array,
     *     Emeas_array,Mass_array,Einc_index,Mass_index,Edep_index
     *     ,Edep_array, tof_edep

	common /search/ Einc_index_s,Edep_index_s,mass_index_s
     *          , tof_first,Emeas_first

c

c	find the entry in the table for the Einc

	e_index=Emeas_first(m_index)
	if(edep.lt.emeas_array(e_index,m_index)) goto 200
	istart=Emeas_first(m_index)+einc_index_s
	ilo=Emeas_first(m_index)
	do 90 i=istart,Einc_index,Einc_index_s
	if(edep.lt.emeas_array(i,m_index)) goto 95
	ilo=i
90	continue


95	do 100 i=ilo,Einc_index-1    ! 1/16/98 gm
	e_index=i
	if((edep.ge.emeas_array(i,m_index)).and.
     *   (edep.lt.emeas_array(i+1,m_index))) goto 200
100	continue

c	

200	continue

c
c	now do a log interpolation for the values
c
c	TOF first
c
400	continue
	call interpolate_ln( tof, Edep, 
     *   Emeas_array(e_index,m_index),
     *   Emeas_array(e_index+1,m_index),
     *   tof_array(e_index,m_index),tof_array(e_index+1,
     *     m_index))



	return

	end
	

	subroutine find_mass(nsc, tof, Emeas, tof_mass)

c	input:  tof, Emeas
c	output:  tof_mass

 
 	real Einc_array(1000),tof_array(1000,50),
     *     Emeas_array(1000,50),Mass_array(50)
	real Edep_array(1000), tof_edep(1000,50)
	integer Einc_index, Edep_index,e_index,Einc_index_s,Edep_index_s
     *          , tof_first(50),Emeas_first(50)
	
	common /tables/ Einc_array,tof_array,
     *     Emeas_array,Mass_array,Einc_index,Mass_index,Edep_index
     *     ,Edep_array, tof_edep

	common /search/ Einc_index_s,Edep_index_s,mass_index_s
     *          , tof_first,Emeas_first


c
c	traps for bad values
c
	tof_mass=0.
c	if ssd is out of range, dont process event
	if((Emeas.lt.0.01).or.(Emeas.gt.250.)) return
c
c	look up Emeas in Edep_array
c	
	e_index=1
	if(emeas.lt.edep_array(1)) goto 200
	ilo=1
	do 90 i=edep_index_s,edep_index,edep_index_s
	if(emeas.lt.edep_array(i)) goto 95
	ilo=i
90	continue

95	do 100 i=ilo,edep_index-1
	e_index=i
	if((emeas.ge.edep_array(i)).and.
     *     (emeas.lt.edep_array(i+1))) goto 200
100	continue
c
c	now find TOF values that bracket the stated values, tof first
c
200	m_index=1
	if(tof.lt.tof_edep(e_index,1)) goto 400
	ilo=1
	do 290 i=mass_index_s,mass_index,mass_index_s
	if(tof.lt.tof_edep(e_index,i)) goto 295
	ilo=i
290	continue

295	do 300 i=ilo,mass_index-1
	m_index=i
	if((tof.ge.tof_edep(e_index,i)).and.
     *     (tof.lt.tof_edep(e_index,i+1))) goto 400
300	continue
	m_index=mass_index-1   ! set m_index if we go off end of loop!
c
c	interpolate mass from tof:
c
400	continue


c	if tof out of range, skip 
	if((tof.lt.2.).or.(tof.gt.400.)) goto 3900


	call interpolate_ln( tof_lo, Emeas, 
     *   Edep_array(e_index),Edep_array(e_index+1),
     *   tof_edep(e_index,m_index),tof_edep(e_index+1,
     *     m_index))
	call interpolate_ln( tof_hi, Emeas, 
     *   Edep_array(e_index),Edep_array(e_index+1),
     *   tof_edep(e_index,m_index+1),tof_edep(e_index+1,
     *     m_index+1))
	call interpolate_ln( tof_mass, tof, tof_lo, 
     *     tof_hi, mass_array(m_index), mass_array(m_index+1))
c
c	limit the maximum returned mass to 400
c
3900	if(tof_mass.gt.400.) tof_mass=400.



	return
	end
	subroutine find_einc(nsc, tof, Emeas, tof_mass, 
     *    einc_tof, einc_ssd) 

c	input:  tof, Emeas, tof_mass
c	output:  einc_tof, einc_ssd
 
 	real Einc_array(1000),tof_array(1000,50),
     *     Emeas_array(1000,50),Mass_array(50)
	real Edep_array(1000), tof_edep(1000,50)
	integer Einc_index, Edep_index, e_index_lo,e_index_hi
	integer Einc_index_s,Edep_index_s
     *          , tof_first(50),Emeas_first(50)

	common /tables/ Einc_array,tof_array,
     *     Emeas_array,Mass_array,Einc_index,Mass_index,Edep_index
     *     ,Edep_array, tof_edep

	common /search/ Einc_index_s,Edep_index_s,mass_index_s
     *          , tof_first,Emeas_first


c	traps for bad values
	einc_tof=0.
	einc_ssd=0.
	if(tof_mass.eq.0.) return

c	first do einc_tof


c
c	find mass indices that bracket tof_mass
c
	m_index=1
	if(tof_mass.lt.mass_array(1)) goto 400
	ilo=1
	do 290 i=mass_index_s,mass_index,mass_index_s
	if(tof_mass.lt.mass_array(i)) goto 295
	ilo=i
290	continue

295	do 300 i=ilo,mass_index-1
	m_index=i
	if((tof_mass.ge.mass_array(i)).and.
     *     (tof_mass.lt.mass_array(i+1))) goto 400
300	continue
c
c	find indices that correspond to tof 
c
400	e_index_lo=tof_first(m_index)
	if(tof.gt.tof_array(e_index_lo,m_index)) goto 505
	istart=tof_first(m_index)+einc_index_s
	ilo=tof_first(m_index)
	do 490 i=istart,einc_index,einc_index_s
	if(tof.gt.tof_array(i,m_index)) goto 495
	ilo=i
490	continue

495	do 500 i=ilo,einc_index-1
	e_index_lo=i
	if((tof.le.tof_array(i,m_index)).and.
     *     (tof.gt.tof_array(i+1,m_index))) goto 505
500	continue

505	continue

	e_index_hi=tof_first(m_index+1)
	if(tof.gt.tof_array(e_index_hi,m_index+1)) goto 515
	istart=tof_first(m_index+1) +einc_index_s
	ilo=tof_first(m_index+1)
	do 507 i=istart,einc_index,einc_index_s
	if(tof.gt.tof_array(i,m_index+1)) goto 509
	ilo=i
507	continue

509	do 510 i=ilo,einc_index-1
	e_index_hi=i
	if((tof.le.tof_array(i,m_index+1)).and.
     *     (tof.gt.tof_array(i+1,m_index+1))) goto 515
510	continue

515	continue


	call interpolate_ln( einc_tof_lo, tof, 
     *   tof_array(e_index_lo,m_index),
     *   tof_array(e_index_lo+1,m_index),
     *   einc_array(e_index_lo),einc_array(e_index_lo+1))


	call interpolate_ln( einc_tof_hi, tof, 
     *   tof_array(e_index_hi,m_index+1),
     *   tof_array(e_index_hi+1,m_index+1),
     *   einc_array(e_index_hi),einc_array(e_index_hi+1))


	call interpolate_ln( einc_tof, tof_mass, 
     *   mass_array(m_index), mass_array(m_index+1),
     *   einc_tof_lo, einc_tof_hi)


c
c	limit einc_tof to 200
c
	if(einc_tof.gt.200.) einc_tof=200.



c	now do einc_ssd


c
c	find mass indices that brackets the tof mass
c

3950	m_index=1
	if(tof_mass.lt.mass_array(1)) goto 3400
	ilo=1
	do 3302 i=mass_index_s,mass_index,mass_index_s
	if(tof_mass.lt.mass_array(i)) goto 3305
	ilo=i
3302	continue

3305	do 3300 i=ilo,mass_index-1
	m_index=i
	if((tof_mass.ge.mass_array(i)).and.
     *     (tof_mass.lt.mass_array(i+1))) goto 3400
3300	continue
c
c	find indices that correspond to Einc for lower mass
c
3400	e_index_lo=Emeas_first(m_index)
	if(Emeas.lt.Emeas_array(e_index_lo,m_index)) goto 3505
	istart=Emeas_first(m_index)+einc_index_s
	ilo=Emeas_first(m_index)
	do 3490 i=istart,einc_index,einc_index_s
	if(Emeas.lt.Emeas_array(i,m_index)) goto 3495
	ilo=i
3490	continue


3495	do 3500 i=ilo,einc_index-1
	e_index_lo=i
	if((Emeas.gt.Emeas_array(i,m_index)).and.
     *     (Emeas.le.Emeas_array(i+1,m_index))) goto 3505
3500	continue

3505	continue
	
	e_index_hi=Emeas_first(m_index+1)
	if(Emeas.lt.Emeas_array(e_index_hi,m_index+1)) goto 3515
	istart=Emeas_first(m_index+1)+Einc_index_s
	ilo=Emeas_first(m_index+1)
	do 3507 i=istart,einc_index,einc_index_s
	if(Emeas.lt.Emeas_array(i,m_index+1)) goto 3509
	ilo=i
3507	continue

3509	do 3510 i=ilo,einc_index-1
	e_index_hi=i
	if((Emeas.gt.Emeas_array(i,m_index+1)).and.
     *     (Emeas.le.Emeas_array(i+1,m_index+1))) goto 3515
3510	continue

3515	continue



	call interpolate_ln( einc_ssd_lo, Emeas, 
     *   Emeas_array(e_index_lo,m_index),
     *   Emeas_array(e_index_lo+1,m_index),
     *   Einc_array(e_index_lo),Einc_array(e_index_lo+1))


	call interpolate_ln( einc_ssd_hi, Emeas, 
     *   Emeas_array(e_index_hi,m_index+1),
     *   Emeas_array(e_index_hi+1,m_index+1),
     *   einc_array(e_index_hi),einc_array(e_index_hi+1))

	call interpolate_ln( einc_ssd, tof_mass, 
     *   mass_array(m_index), mass_array(m_index+1),
     *   einc_ssd_lo, einc_ssd_hi)


c
c	limit einc_ssd to 200
c
	if(einc_ssd.gt.200.) einc_ssd=200.




	return
	end
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/interpolate_ln.inc'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/ssd_ch_to_mev.inc'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/tof_ch_to_ns.inc'
