c	program test fme to channel
c
c	nsc=1   -- 9/18/2014  /gm
	type *, 'Enter spacecraft number: (1 or 2):  '
	read(*,*,end=1000) nsc

	open(unit=25,name='test_channel_to_fme.kal',status='old')
	write(25,30)
30	format(' xbin1,ybin1,nsc,igain1,ch_tof1,ch_ssd1')

	do 1000 i=1,500
	do 1000 j=1,1000

c400	type *, 'Enter ssd ch, tof ch:  '
c	read(*,*,end=1000) j, i
	igain = 0
	ch_tof = i
	ch_ssd = j
	ch_tof1=ch_tof
	ch_ssd1=ch_ssd
	igain1=igain
	call channel_to_fme(xbin1,ybin1,nsc,ch_tof, ch_ssd,igain1)

	write(25,40) xbin1,ybin1,nsc,igain1,i,j
c	type *, xbin1,ybin1,nsc,igain1,i,j
40	format(2(f10.2,','),4(i6,','))
c	goto 400
1000	continue

	type *, ' fme_to_channel is finished;  output file is:  test_channel_to_fme.kal'
	end

c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/fme_to_channel.inc'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/ssd_ch_to_mev.inc'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/tof_ch_to_ns.inc'


	subroutine fme_to_channel(xbin,ybin,nsc,ch_tof,ch_ssd,igain)
c
c	routine to calculate sit rate bin space from input channels
c	and also do inverse calculation
c
c	23-Apr-2002    gm
c
c	modification history:
c		23-Apr-2002	initial version
c		24-Aug-2005	make variable list identical for
c				calls to ssd_to_ch, tof_ch etc./gm
c
c
	data const/0.021/

	type *, ' fme_to_channel entry'

c
	xctr = xbin
	yctr = ybin
c
	amass = exp((7./128.)*yctr - 1.)
	einc = exp((1./16.)*xctr - 5.5)
c
c
	tof = sqrt(1/(const*einc))

	ch_tof = tof_ns_to_ch(nsc,tof)
c
c
	essd = amass/(const*tof**2)
c
	call ssd_mev_to_ch(nsc,igain,ch_ssd,essd)
c
	return

	entry channel_to_fme(xbin,ybin,nsc,ch_tof,ch_ssd,igain)
c	type *, ' channel_to_fme entry', ch_tof, ch_ssd
c	skip events with channels out of bounds
	if(ch_tof.le.5.) goto 100
	if(ch_tof.ge.511) goto 100
	if(ch_ssd.le.5.) goto 100
	if(ch_ssd.ge.2047) goto 100



	tof = tof_ch_to_ns(nsc,ch_tof)

	call ssd_ch_to_mev(nsc,igain,ch_ssd,essd)

	amass = const*essd*tof**2
	
c	type *, tof, essd, amass
	
c	type *, ' const, essd, tof: ', const, essd, tof
c	type *,' essd, amass: ', essd, amass
	einc = essd/amass

	xbin = (alog(einc)+5.5)*16.
	ybin = (alog(amass)+1.)*128./7.
	
c	type *, xbin, ybin

	return

c	trap for 0 or max channel numbers
c
100	xbin=0.
	ybin=0.
c	type *, 'leaving via trap: '

	end

	function tof_ch_to_ns(nsc, channel)
c
c	gm 4/17/02
c
c	itype = 1 (entry tof_ch_to_ns)
c	input:  nsc (S/C:  1=Ahead;  2=Behind)
c		channel
c	output: tof (ns)
c
c	modification history:
c		17-April-02	adapted from uleis routine
c				see PWalpole e-mail 4/9/02
c		4-Feb-2005	adapt for fm1 2 segment linear fit /gm
c		7-Feb-2005	add inversion:  tof to ch; offsets /gm
c		22-Aug-2006	fix bug (tof_offset_cable not keyed to
c				the two units) /gm
c		14-Oct-2010	change location of tcal.dat files /gm

	dimension istart(2)
	data istart/2*0/     ! first call for fm1, fm2
	dimension c_slope(2,2,2)  ! c_slope(itype, nsc, segment)
	dimension c_int(2,2,2)    ! c_int(itype, nsc, segment)
	dimension c_break(2,2)    ! break channel number (itype,nsc)
	dimension tof_offset_cable(2)  ! offset due to cable lengths

	itype = 1

50	if(istart(nsc).gt.0) goto 300
	istart(nsc)=1
	goto (100,200), nsc	! read in calibrations if at start

c	read in fm1 coefficients
100	open(unit=60,name=
     *   '/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM1/TCAL.DAT;8',
     *   status='old')
	goto 250

200	open(unit=60,name=
     *   '/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM2/TCAL.DAT;6',
     *   status='old')


c	skip main header lines
250	read(60, 110)
c	
c	loop to read both sets of coefficients
c
	do 120 i=1,2
	read(60, 110)
110	format(x)
	read(60,*) c_int(i,nsc,1), c_slope(i,nsc,1), c_break(i,nsc)
120	read(60,*) c_int(i,nsc,2), c_slope(i,nsc,2)
c
c	read in the tof offset due to cable lengths
c
	read(60,*) tof_offset_cable(nsc)

	close (60)

300	goto(350,400), itype



c	channel to ns conversion
350	iseg = 1
	if(channel.ge.c_break(itype,nsc)) iseg = 2

	tof_ch_to_ns = c_int(itype,nsc,iseg) +
     *                 c_slope(itype,nsc,iseg)*channel

	tof_ch_to_ns = tof_ch_to_ns + tof_offset_cable(nsc)   ! cable length 


	if(tof_ch_to_ns.lt.0.) tof_ch_to_ns = 0.

	return



	entry tof_ns_to_ch(nsc, tof)
	itype = 2
	goto 50	

400	iseg = 1
	if(tof.ge.c_break(itype,nsc)) iseg = 2

	tof_ns_to_ch = c_int(itype,nsc,iseg) +
     *                 c_slope(itype,nsc,iseg)*tof

c	now subtract out correction due to cable lengths
	tof_ns_to_ch = tof_ns_to_ch 
     *          - tof_offset_cable(nsc)*c_slope(itype,nsc,iseg)



	if(tof_ns_to_ch.lt.0.) tof_ns_to_ch=0   ! no negative ch #s
	if(tof_ns_to_ch.gt.511.) tof_ns_to_ch=511 ! don't exceed 511

	return
	end


		subroutine ssd_ch_to_mev(nsc, igain, channel, mev)
c
c	gm 4/17/02
c
c	input: channel (number)
c	       igain (0=high;  1=low)
c	       nsc (S/C:  1=Ahead;  2=Behind)
c
c	note:  in subroutine, 
c			itype = 1:  ch to MeV call
c			itype = 2:  MeV to ch call
c
c	output: MeV
c
c	modification history:
c		17-Apr-02	test version 
c				see P Walpole e-mail 4/9/02
c		1-Feb-05	flight polynomial fits installed /gm
c		4-Feb-05	inversion (MeV to channel) installed /gm
c		24-Aug-05	make call variable order same for both
c				ch to meV and meV to ch calls!  gm
c		29-Aug-05	increase dimension 4 of coef (..) to
c				accomodate 3rd order fits! /gm
c		14-Oct-2010	change directory location of ecal.dat files /gm
c
	real mev
c
	dimension istart(2)
	data istart/2*0/     ! first call for fm1, fm2
	dimension norder(2,2,2)    ! order of fit (itype, s/c, gain)
	dimension coef(2,2,2,4)    ! coefficients (itype, S/C, gain, order)
	dimension c_range(2,2,2,2)   ! channel range of polynomial fits
c				    c_range(itype, s/c,gain,low vs high bound)
	dimension c_linear(2,2,2)  ! linear gains (itype,S/C, gain)
	common /poly/ norder, coef, c_range, c_linear
	
	itype = 1

50	if(istart(nsc).gt.0) goto 300
	istart(nsc)=1
	goto (100,200), nsc	! read in calibrations if at start

c	read in fm1 coefficients
100	open(unit=60,name=
     *   '/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM1/ECAL.DAT;4',
     *   status='old')
	goto 250

200	open(unit=60,name=
     *   '/Users/masongm1/Data/Instrument_cal_files/sit_cal/sit_electronic_cal/FM2/ECAL.DAT;1',
     *   status='old')


c	skip main header lines
250	read(60, 110)
c	
c	loop to read both sets of coefficients
c
	do 120 i = 1,2
	read(60, 110)
110	format(x)
	read(60,*) c_linear(i,nsc,1)       ! linear gain MeV/ch
	read(60,*) norder(i,nsc,1), 
     *      (c_range(i,nsc,1,j),j=1,2), (coef(i,nsc,1,j),
     *                                 j=1,norder(i,nsc,1)+1) ! high gain
	read(60,*) c_linear(i,nsc,2)       ! linear gain MeV/ch
120	read(60,*) norder(i,nsc,2), 
     *      (c_range(i,nsc,2,j),j=1,2), (coef(i,nsc,2,j),
     *                                 j=1,norder(i,nsc,2)+1) ! low gain
	close (60)




c	calculate MeV
300	if(itype .eq. 1) mev = convert_to_mev(itype, nsc, igain, channel)
	if(itype .eq. 2) 
     *         call convert_to_channel(itype, nsc, mev, igain, channel)

c	do not return negative MeV value
	if(mev.lt.0.0) mev=0.0
	if(channel.lt.0.) channel=0.
	if(channel.gt.2047.) channel=2047.


	return

	entry ssd_mev_to_ch(nsc, igain, channel, mev)
c	returns channel & gain setting
	itype = 2
	goto 50

	end

	function convert_to_mev(itype, nsc, igain, channel)
	
	real mev


	dimension norder(2,2,2)    ! order of fit (itype,s/c, gain)
	dimension coef(2,2,2,4)    ! coefficients (itype,S/C, gain, order)
	dimension c_range(2,2,2,2)   ! channel range of polynomial fits
c				    c_range(itype,s/c,gain,low vs high bound)
	dimension c_linear(2,2,2)  ! linear gains (itype, S/C, gain)
	common /poly/ norder, coef, c_range, c_linear
	
	mev = 0.
	c_save = channel

300	if(c_save.lt.c_range(itype,nsc,igain+1,1)) goto 400
	if(c_save.gt.c_range(itype,nsc,igain+1,2)) goto 500 
c
c	channel is within the bounds of the polynomial fit, so just use it
c
	do 350 j=1,norder(itype, nsc, igain+1) + 1
350	mev = mev + coef(itype, nsc, igain+1, j)*c_save**(j-1)
	
360	convert_to_mev = mev

	if(convert.lt.0.) convert=0.   ! no negative values returned

	return


c	case where the channel is outside the limits of the polynomial fit
c	in this case, calculate the polynomial fit value at its limit,
c	and then do a linear extrapolation up or down

c	channel is lower than polynomial fit range
400	c_save = c_range(itype, nsc,igain+1,1)
	goto 600

c	channel is higher than polynomial fit range
500	c_save = c_range(itype, nsc,igain+1,2)

600	do 650 j=1,norder(itype, nsc, igain+1) + 1
650	mev = mev + coef(itype, nsc, igain+1, j)*c_save**(j-1)
	mev = mev + (channel - c_save)*c_linear(itype, nsc,igain+1)

	goto 360

	end
	subroutine convert_to_channel(itype, nsc, mev, igain, channel)

	
	real mev


	dimension norder(2,2,2)    ! order of fit (itype,s/c, gain)
	dimension coef(2,2,2,4)    ! coefficients (itype,S/C, gain, order)
	dimension c_range(2,2,2,2)   ! channel range of polynomial fits
c				    c_range(itype,s/c,gain,low vs high bound)
	dimension c_linear(2,2,2)  ! linear gains (itype, S/C, gain)
	dimension channel_out(2), c_save(2)
	common /poly/ norder, coef, c_range, c_linear
	
	
c
c	calculate both high & low gain channels for this MeV
c
	do 1000 igain = 0,1

	channel_out(igain+1)=0.
	c_save(igain+1) = mev


	if(c_save(igain+1).lt.c_range(itype,nsc,igain+1,1)) goto 400
	if(c_save(igain+1).gt.c_range(itype,nsc,igain+1,2)) goto 500 
	goto 300

c	case where the mev value is outside the limits of the polynomial fit
c	in this case, calculate the polynomial fit value at its limit,
c	and then do a linear extrapolation up or down

c	channel is lower than polynomial fit range
400	c_save(igain+1) = c_range(itype, nsc,igain+1,1)
	goto 600

c	channel is higher than polynomial fit range
500	c_save(igain+1) = c_range(itype, nsc,igain+1,2)

600	do 650 j=1,norder(itype, nsc, igain+1) + 1
650	channel_out(igain+1) =
     *   channel_out(igain+1)  + 
     *   coef(itype, nsc, igain+1, j)*c_save(igain+1)**(j-1)
	channel_out(igain+1)  = 
     *   channel_out(igain+1) + 
     *   (mev - c_save(igain+1))*c_linear(itype, nsc,igain+1)

	goto 1000


c
c	channel is within the bounds of the polynomial fit, so just use it
c
300	do 350 j=1,norder(itype, nsc, igain+1) + 1
350	channel_out(igain+1)  = 
     *    channel_out(igain+1) + 
     *    coef(itype, nsc, igain+1, j)*c_save(igain+1)**(j-1)
	



1000	continue
	
c	select ramp depending on channel number calculated
	igain = 0
	if(channel_out(1).gt.2048) igain=1

	channel=channel_out(igain+1)

c	don''t return negative or values greater than 2048
	if(channel.lt.0.) channel = 0
	if(channel.gt.2048.) channel = 2048

	end
