c	program test_channel_to_fme_int
c
c	program to look up f(e) and f(m) index and box numbers given
c	unit #, and tof and ssd and gain settings
c
c	gm	23-Sept-2005
c
c	Modification history:
c		23-Sept-2005	initial version
c
c
c
	include 'table_checker_include.inc'

	call get_checksum        ! read in table; write table checksums

50	type *, ' Enter issdch, igain, itofch: '
	read(*,*,end=1000) issdch, igain, itofch
	call channel_to_fme_int(issdch, igain,
     *                                itofch, ixbin, iybin)
	type *, ' ixbin, iybin: ', ixbin, iybin
	
	if((ixbin.eq.0).or.(iybin.eq.0)) goto 100

	ibox_contents = ibox_array(ixbin, iybin)
	type *, ' raw box contents: ',ibox_contents
c	put the matrix rate number into iregbox
	call mvbits(ibox_array(ixbin, iybin),0,7,iregbox,0)
c	put beacon box number into ibeabox
	call mvbits(ibox_array(ixbin, iybin),8,4,ibeabox,0)
c	extract the priority bit
	call mvbits(ibox_array(ixbin, iybin),7,1,ipri,0)
	type *, ' regular box number: ',iregbox
	type *, ' beacon bax number: ',ibeabox
	type *, ' priority: ', ipri
	goto 50


100	type *, ' ibox = 0'
	goto 50

1000	end

	subroutine get_checksum
c
c

	include 'table_checker_include.inc'

c
c
	write(*,10) 
10	format(' Enter input hex filename: '$)
	read(*,20) iname_len, input_file
20	format(q,a80)
	open(unit=10,name=input_file,status='old')

	write(*,17)
17	format(' Enter unit number (1 or 2): '$)
	read(*,*) iunit

	
	read(10,30)   ! skip initial line header
30	format(x)


c	issdhi

	do 55 j=1,3
55	read(10,30)
	do 60 j=1,2048
60	read(10,70) issdhi(j)
70	format(2x,z6)

	do 75 j=1,3
75	read(10,30)
	do 80 j=1,2048
80	read(10,70) issdlo(j)

	do 90 j=1,3
90	read(10,30)
	do 100 i=1,128
	do 100 j=1,128
100	read(10,70) ibox_array(i,j)

	do 110 j=1,3
110	read(10,30)
	do 120 j=1,512
120	read(10,70) itof(j)

c
c	finish up
c
	close(25)

	return

	end

	subroutine channel_to_fme_int(issdch, igain, 
     *                                itofch, ixbin, iybin)
c*****************************************
c	this routine identical to the one in [mason.stereo.subroutines]
c	except for changed common to allow communitaction with this pgm
c*****************************************
c
c	calculates SIT matrix bins using integer data
c
c	gm	15-May-2002
c
c	modification history:
c		15-May-2002 original version
c		22-May-2002 rearrange calc to avoid overflows
c		24-May-2002 mods for flight simulator routine
c		12-Jun-2002 correct typo & bug in gain branch
c		25-Jun-2002 replace 1/7 divide by (1/8 + 1/64)

c	common /calib/ issdlo, issdhi, itof
c	integer issdlo(2048),issdhi(2048),itof(512)
	include 'table_checker_include.inc'


c       skip events with channels out of bounds
        if(itofch.le.itof(2)) goto 100
        if(itofch.ge.itof(3)) goto 100

	if(igain.eq.0) goto 50

	issd =     issdlo(issdch)
	ioffset =  issdlo(1)
 	issdlim1 = issdlo(2)
	issdlim2 = issdlo(3)

	goto 60

50	issd =     issdhi(issdch)
	ioffset =  issdhi(1)
	issdlim1 = issdhi(2)
	issdlim2 = issdhi(3)


60	if(issdch.le.issdlim1) goto 100
        if(issdch.ge.issdlim2) goto 100                     



	ilnmass = issd + itof(itofch)

	iybin = ilnmass
	iybin = iybin + 2**16
        iybin = iybin - ioffset      ! get rid of ssd offset
        iybin = iybin - itof(1)      ! get rid of tof offset
	itemp = iybin                
	iybin = (itemp/8) + (itemp/64)  ! eqiv to divide by 7 (within 1.6%)
        iybin = iybin/512            ! 1/512 = 128/2**16


	ilneinc = -itof(itofch) + itof(1)  ! offset is in xx(1)

	ixbin = ilneinc + 5.5*2**16
	ixbin = ixbin/4096           ! 1/4096 = 16/2**16


c	if ixbin or iybin falls outside bounds of rate lookup array,
c	mark this event for out of bounds box 

	if(ixbin.le.0) goto 100
	if(iybin.le.0) goto 100
	if(ixbin.gt.128) goto 100
	if(iybin.gt.128) goto 100

	return

100	ixbin = 0
	iybin = 0
	return


	end
