c	table_generator    for SIT
c
c	program to generate flight tables
c
c	gm	23-Aug-2005
c
c	Modification history:
c		23-Aug-2005	Modified from old pgm
c		1-Sept-2005	Initial version /gm
c		6-Sept-2005	put fm # in Rate table file name /gm
c		15-Sept-2005	fix ranges subroutine calc of box #; 
c				was including pri bit /gm
c		20-Sept-2005	1)fix bug on write out of matrix
c				2) fix offset on boxes
c		21-Sept-2005	split program into 2 parts, one
c				to write the tables only; the 
c				second to read the table file and
c				produce the output kaleidagraph checks /gm
c		28-Apr-2006	change priority assignment to high
c				priority for 6 =< M =< 60   /gm
c		23-Feb-2007	change issd value to 0 of ssd deposit =<0
c				change channel upper limit to 2048 /gm
c		11-Apr-2007	write out separate files for Kristin
c				to use for uploading /gm
c				modify algorithm for 3He box assignment
c				so that box goes to 4He if 4He impinges
c				on the box (otherwise low mass species
c				gets the box) /gm  
c		23-Jul-2008	install on Mac / Absoft compiler /gm
c
c
	character*35 filename, filename_sub
	common /inputs/ iunit, idate
        character*6 spacecraft(2)
        data spacecraft/'Ahead ', 'Behind'/

5	write(*,10)
10	format(' Enter unit number (1 or 2): ',$)
	read(*,*,end=1000) iunit
	if((iunit.eq.1).or.(iunit.eq.2)) goto 15
		type *, 'iunit must be 1 or 2'
		goto 5

15	write(*,20)
20	format(' Enter date in form mmddyy: '$)
	read(*,*,end=1000) idate

c	open the output files:  1 single file & 4 separate ones
	write(filename,30) adjustl(trim(spacecraft(iunit))),idate
30	format('sit_',a,'_tables_',i6.6,'.hex')
	type *, ' opening output file: ',filename
	open(unit=50,name=filename,status='new')
	write(filename_sub,31) adjustl(trim(spacecraft(iunit))),idate
31	format('sit_',a,'_ssdhi_',i6.6,'.hex')
	type *, ' opening output file: ',filename_sub
	open(unit=51,name=filename_sub,status='new')
	write(filename_sub,32) adjustl(trim(spacecraft(iunit))),idate
32	format('sit_',a,'_ssdlo_',i6.6,'.hex')
	type *, ' opening output file: ',filename_sub
	open(unit=52,name=filename_sub,status='new')
	write(filename_sub,33) adjustl(trim(spacecraft(iunit))),idate
33	format('sit_',a,'_toftab_',i6.6,'.hex')
	type *, ' opening output file: ',filename_sub
	open(unit=53,name=filename_sub,status='new')
	write(filename_sub,34) adjustl(trim(spacecraft(iunit))),idate
34	format('sit_',a,'_box_array_',i6.6,'.hex')
	type *, ' opening output file: ',filename_sub
	open(unit=54,name=filename_sub,status='new')


c
c	generate each of the 4 tables: 
c


	call ssdhi_gen   ! ssd hi table 

	call ssdlo_gen   ! ssd lo table 

	call box_gen     ! vector box array

	call tof_gen     ! tof table

1000	end


	subroutine ssdhi_gen

	real*8	damev
	common /inputs/ iunit, idate

c	write out the first line of the file, and the ssdhi header

	igain = 0 	! (high gain)

	write(50, 10) 
10	format('; SIT related tables needed for table lookups',
     *         ' in event processing algorithm',/,
     *         '; SSDHI         0x7000',/,
     *         'SITBINARY',/,
     *         '0x7000 0x800 0')
	write(51, 11) 
11	format('; SSDHI         0x7000',/,
     *         'SITBINARY',/,
     *         '0x7000 0x800 0')

c	loop to write out all the channels
c
100	do 200 i = 1,2048
	channel = i - 1

	call ssd_ch_to_mev(iunit, igain, channel, amev)

	if(amev.le.0) issd = 0
	damev=amev
	if(amev.gt.0.) issd =   (dlog(damev) + 8)*2**16
c	put in trap for 0 or very small energy deposits, which
c		can give issd < 0
	if(issd.lt.0) issd = 0

c	special cases for channels 0-4
	if(i.eq.1) issd = 8*2**16   ! offset
	if(i.eq.2) issd = 5   	! low channel limit
	if(i.eq.3) issd = 2048   	! high channel limit
	if(i.eq.4) goto 150 	! creation date
	if(i.eq.5) issd = iunit	! fm# (1 or 2)
	write(50,120) issd
	write(51+igain,120) issd
120	format('0x',z6.6)
	goto 200
150	write(50,121) idate
	write(51+igain,121) idate
121	format('0x',i6.6)  ! <-- this quantity written in decimal!
200	continue
	return

	entry ssdlo_gen

	igain = 1 	! (low)
	write(50, 250)
	write(52, 250)
250	format('; SSDLO         0x7800',/,
     *         'SITBINARY',/,
     *         '0x7800 0x800 0')


	goto 100
	end
	subroutine tof_gen

	real*8	dtof
	common /inputs/ iunit, idate

c	write out the first line of the file

	write(50, 10) 
	write(53, 10) 
10	format('; TOFTAB                0xC000',/,
     *         'SITBINARY',/,
     *         '0xc000 0x200 0')

c	loop to write out all the channels
c
100	do 200 i = 1,512
	channel = i - 1
	dtof =  tof_ch_to_ns(iunit, channel)

c	special case for channel 0
	if((i-1).eq.0) dtof = 0.   ! gives tof offset 
	if(dtof.le.0.) issd = 8*2**16
	if(dtof.gt.0.) issd = (dlog(0.021*dtof*dtof) + 8)*2**16
c	put in trap for values of issd < 0
	if(issd.le.0) issd = 8*2**16

c	special cases for channels 1-4
	if((i-1).eq.1) issd = 5   	! low channel limit
	if((i-2).eq.1) issd = 511   	! high channel limit
	if((i-3).eq.1) goto 150 	! creation date
	if((i-4).eq.1) issd = iunit	! fm# (1 or 2)
	write(50,120) issd
	write(53,120) issd
120	format('0x',z6.6)
	goto 200
150	write(50,121) idate	! <-- date written in decimal!
	write(53,121) idate	! <-- date written in decimal!
121	format('0x',i6.6)
200	continue

	return
	end
	subroutine box_gen
c	STEREO / SIT  Rate box generator
c		routine to generate SIT rate box matrix list 
c
c	G. Mason   18-Apr-2002
c
c	modification history:
c		18-Apr2002	initial version
c		23-May-2002	add write out of f_e vs. f_m array
c		24-May-2002	change junk to rate #4
c				add offset to compensate for
c				first element box number = 5 /gm
c		10-Jun-2002	add beacon rates
c				first element box number = 8 /gm
c		11-Jun-2002	add calculation of actual rate bin
c				energy limits /gm
c		12-Jun-2002	change bit assignment for beacon rates
c				and priority bit (now = 2^16 bit)
c		25-Jun-2002	change priority bit to 2^7 bit,
c				write output vector file in hex
c				renumber beacon boxes as N*256
c
	call array_fill
c
c
c
	call write_array       ! routine to just dump file
c
	end

	subroutine array_fill
c
c	reads in sit boxes, and fills up the array accordingly
	integer ibox_array(128,128), icolor(128), ibox(128),
     *               icolor_length(128)
	real Emin(128), Emax(128), Amin(128), Amax(128), Aavg(128), 
     *           Atno(128)
	character*120 file_name
	character*10 Box_name(128), element_color(128)
	common /boxes/ ibox_array, icolor, icolors, element_color,
     *               icolor_length, Box_name, ibfirst
	common /rates/ Emin, Emax, Amin, Amax, Aavg,Atno,ibox,ilast
	common /inputs/ iunit, idate
	logical typeit
	data ibox_array/16384*7/, icolor/128*1/    ! 7 is junk rate #
c
c	technique:
c		all the rate box lines are read in
c		then, for each cell in the rate table,
c		   the Einc and Mass is calculated at the cell''s center
c		   that value is compared with the rate boxes,
c			if there is a match, that cell gets the rate No.
c			if there is no match, is "junk" (=7)
c		   then, next cell in table is examined
c
c	note:  the search of rate bins for each cell is done in the
c	order in which they are read in;  usually that will be from
c	low mass to high mass, and low en to high en.  If a cell is
c	already assigned a rate bin number, then other rates will not
c	supplant it -- that will generally mean that the lower energy,
c	lower mass rates will be used in case of any bin overlap.
c
c	Read in rate boxes
c
	do 15 ivers = 99, 1, -1
	if(ivers .ge. 10) then 
		write(file_name,10) iunit, ivers
	else
		write(file_name,11) iunit,ivers
	endif
10	format('fm'i1'_sit_rate_boxes.dat;',i2)
11	format('fm'i1'_sit_rate_boxes.dat;',i1)
c	type *, ' opening: ', adjustl(trim(file_name))
	open(unit=10,name=adjustl(trim(file_name)),status='old',action='read',err=15)	
	goto 16
15	continue

16	read(10,20)  ! space over header line
20	format(x)

	
	ilast=1
	ibstart = 0
	do 100 i=1,128
c	type *, "read number: ", i
	read(10,*,end=200) box_name(ilast), Emin(ilast), Emax(ilast), 
     *           Amin(ilast),Amax(ilast), Aavg(ilast), Atno(ilast), 
     *           Ibox(ilast)   
c	type *,  box_name(ilast), Emin(ilast), Emax(ilast),
c     *           Amin(ilast),Amax(ilast), Aavg(ilast), Atno(ilast),
c     *           Ibox(ilast)
c	skip rates labeled as 'spare' -- rates
	if(box_name(ilast)(1:5).eq.'spare') goto 100
c	keep track of the first box that is a beacon rate (box # >=256)
	if(Ibox(ilast).lt.256) goto 90
	if(ibstart.eq.1) goto 90
	ibstart = 1
	ibfirst = ilast        ! this is the first box that's a beacon box
90      ilast=ilast+1  
100	continue
200	continue
c
c	now process table
c
	type *, ' starting to process table'

	do 300 i=1,128
	do 300 j=1,128
	typeit=.false.
c	if((i.eq.128).and.(j.eq.128)) typeit=.true.
c	i=115
c	j=100		! TEST mode
c
c	find Einc and Mass at the center of cell (i,k)
c
c	first find the channel numbers:

	xbin=i
	ybin=j
	call fme_to_channel(xbin+0.5,ybin+0.5,
     *            iunit,ch_tof,ch_ssd,igain)

	if(typeit) type *, i,j,iunit, ch_tof, ch_ssd, igain

c	now convert to actual mass and incident energy
	call sit_convert(iunit, ch_ssd, igain, ch_tof, 
     *    einc_tof, einc_ssd, amass, emeas, tof)
	
	if(typeit)	type *, "ch_ssd, igain, ch_tof,'
     *   ' einc_tof, einc_ssd, amass, emeas, tof",
     *   ch_ssd, igain, ch_tof,
     *    einc_tof, einc_ssd, amass, emeas, tof

c
c	if tof channel = 511, or ssd ch = 2048, put event
c	in 'junk' box
c
	if((ch_ssd.ge.2047.).or.(ch_tof.ge.511.)) goto 300
c
c	to avoid problems with crossing tracks in fm2_sitmr.kal, put any
c	events with Emeas < 0.02 MeV in the junk box
c										/gm 10/29/2010
	if((iunit.eq.2).and.(emeas.le.0.027)) goto 310

c	to avoid problems with crossing tracks in fm1_sitmr.kal, put any
c	events with Emeas < 0.07 MeV in the junk box (E channel 34 and below)
c										/gm 4/15/2011
	if((iunit.eq.1).and.(emeas.le.0.070)) goto 310


	goto 314
310	continue
c	type *, ' junk channel due to small Emeas for: ', xbin, ybin, amass, emeas, ch_ssd, iunit
	goto 300
314	continue
c
c	*********** if mass is 3.2 < m < 3.5, set to 3.6 to
c	keep box width from moving into 4He area   4/11/07 /gm
	if( (amass .lt. 2.7) .or. (amass .gt. 4.0) ) goto 315
	amass = 3.6
315	Ecell = einc_tof
	Amcell = amass


c	now loop through the rate boxes
c
	do 250 k=1,ilast    
	if(typeit)	type *, 'ecell, amass, k, emin(k), 
     *    emax(k), amin(k), amax(k): ',
     *   ecell, amass, k, emin(k), emax(k), amin(k), amax(k) 
	
	if(    (Ecell.ge.Emin(k)) .and. (Ecell.lt.Emax(k))
     *  .and.  (Amcell.ge.Amin(k)) .and. (Amcell.lt.Amax(k)) )
     *      goto 220
	goto 250

c	a match, so bump cell number if not already taken
220	continue
	if(typeit) type *, ' MATCHED BOX, ibox no. is:  ',ibox(k)
c	branch on whether or not this is a beacon rate
c	(note:  beacon rates are at the end of the input file, so will
c	be processed only after others are done)
	if(ibox(k).ge.256) goto 230
	if(ibox_array(i,j).ne.7) goto 250	
	ibox_array(i,j) = ibox(k)
c
c	priority bit setting ...
c	if average z .ge.6 & .le. 30 then set to high priority bit
c	unless a background rate
c
	if(box_name(k)(1:4).ne.'bkgd' ) goto 251
c	type *, ' background box: ',k,box_name(k)
	goto 250
251	if((aavg(k).ge.6.).and.(aavg(k).le.60.))
     *         ibox_array(i,j) = ibox_array(i,j) + 128
	
	goto 250

c	a beacon rate, so put add rate to box whether 'taken' or not
230	ibox_array(i,j) = ibox_array(i,j) + ibox(k)
	if(typeit)	type *, ' beacon rate'
	if(typeit)	type *, k, ibox(k), ibox_array(i,j), 
     *      mod(ibox_array(i,j),256),ibox_array(i,j)/256


250	continue   


300	continue	



	return
	end



	subroutine write_array
c
c	writes out ascii array with values
c
	integer ibox_array(128,128), icolor(128), ibox(128),
     *               icolor_length(128)
	integer iwrite(128,128)
	character*10 Box_name(128), element_color(128)
	common /boxes/ ibox_array, icolor, icolors, element_color,
     *               icolor_length, Box_name
	common /inputs/ iunit, idate


c	write header
	write(50,30)
	write(54,30)
30	format('; BOX_ARRAY             0x8000',/,
     *         'SITBINARY',/,
     *         '0x8000 0x4000 2')


c
	

	do 110 i=1,128
	do 110 j=1,128
	write(50,125) ibox_array(i,j)
	write(54,125) ibox_array(i,j)
c	type *, i,j,ibox_array(i,j)
125	format('0x',z6.6)

110	continue	
	return
	end
	
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/sit_convert.inc'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/convert_hk.inc'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/ssd_ch_to_mev.inc'
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/tof_ch_to_ns.inc'	
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/interpolate_ln.inc'	
c	include '/Users/masongm1/Programs/fortran_vax/SIT/sit_subroutines/fme_to_channel.inc'
