c	routine table_checksum
c
c	calculates checksum (mod 2^23) of sit tables
c
c	gm
c
c	Modification History:
c		4_Oct_2004	initial version
c		20-Apr-2011	adapted for Mac/Absoft compiler; add skip over heade lines  /gm
c	
	character*80  input, ssdhi_file, ssdlo_file, tof_file,
     *       matrix_table_file
	integer*8 isum, issdhi, issdlo, itof, imatrix, i24

c
c
	isum=0
	issdhi=0
	issdlo=0
	itof=0
	imatrix=0

c	ssdhi file

	type *, ' Type in name of ssdhi file: '
	read(*,20,end=1000) len, input
20	format(q,a80)
	open(unit=10,name=input,action='read')
	inquire(10,name=ssdhi_file)
c	skip over 3 header lines
	do 29 i = 1,3
29	read(10, 38) ichar

	do 30 i=1,2048
	read(10,25) ivalue
25	format(2x, z6.6)
30	issdhi=issdhi+ivalue
	close(10)


c	ssdlo file

	type *, ' Type in name of ssdlo file:'
	read(*,20,end=1000) len, input
	open(unit=10,name=input,action='read')
	inquire(10,name=ssdlo_file)
c	skip over 3 header lines
	do 39 i = 1,3
39	read(10, 38) ichar
38	format(a1)


	do 40 i=1,2048
	read(10,25) ivalue
40	issdlo=issdlo+ivalue
	close(10)


c	tof file

	type *, ' Type in name of tof file:'
	read(*,20,end=1000) len, input
	open(unit=10,name=input,action='read')
	inquire(10,name=tof_file)
c	skip over 3 header lines
	do 49 i = 1,3
49	read(10, 38) ichar

	do 50 i=1,512
	read(10,25) ivalue
50	itof=itof+ivalue
	close(10)


c	matrix table file


	type *, ' Type in name of matrix table file:'
	read(*,20,end=1000) len, input
	open(unit=10,name=input,action='read')
	inquire(10,name=matrix_table_file)
c	skip over 3 header lines
	do 59 i = 1,3
59	read(10, 38) ichar

	do 60 i=1,16384
	read(10,25) ivalue
60	imatrix=imatrix+ivalue

	close(10)


c	type out results

	type *, ' Table checksum run -- sums & input files'
	type *, ' ',issdhi, ' ',ssdhi_file
	type *, ' ',issdlo, ' ',ssdlo_file
	type *, ' ',itof, ' ', tof_file
	type *, ' ', imatrix, ' ',matrix_table_file
	type *, ' ' 
	isum=issdlo+issdhi+itof+imatrix
	type *, ' sum of tables: ', isum

	call mvbits(isum, 0, 24, i24, 0)

	type *, ' low order 24 bits of checksum : ', i24
	
	write(*,100) i24
100	format(/' checksum in hex:  ',z6.6)

1000	end
