c	program table_checker
c
c	routine to read in sit hex tables, calculate checksums,
c	and produce output kaleidagraph files
c
c	gm	21-Sept-2005
c
c	Modification history:
c		22-Sept-2005	adapted from old table_checksum and
c				table_generator programs
c		1-Mar-2007	modify format of .ranges output file
c				for use by SIT_LISTER /gm
c
c
c
	include 'table_checker_include.inc'

	call get_checksum        ! read in table; write table checksums

	call write_kalfile       ! table of 128x128 matrix

c	dont call write_ranges or write_calibration unless fm1 or fm2

	if(iunit.gt.0)	call write_ranges        ! table of actual energy ranges

	if(iunit.gt.0)	call write_calibration   ! table of calibrations/lookup
	
	end

	subroutine get_checksum
c
c

	include 'table_checker_include.inc'

c
c
	write(*,10) 
10	format(' Enter input hex filename: '$)
	read(*,20) iname_len, input_file
20	format(q,a80)
	open(unit=10,name=input_file,status='old')
	write(*,15)
15	format(' Enter reference boxfile: '$)
	read(*,21) input_boxfile
21	format(a80)
	open(unit=30,name=input_boxfile)
	write(*,17)
17	format(' Enter unit number (1 or 2): '$)
	read(*,*) iunit

c	open output file
	len_to_ext = index(input_file,'.')
	output_file = input_file(1:len_to_ext)//'checksum'
	open(unit=25,name=output_file,status='new')

	write(25,22) adjustl(trim(input_file(1:iname_len)))
22	format(' SIT table checksum for input file: ',
     *   a,/)
	
	read(10,30)   ! skip initial line header
30	format(x)

	do 50 i=1,4   ! zero the checksums
50	isum(i)=0

c	issdhi

	do 55 j=1,3
55	read(10,30)
	do 60 j=1,2048
	read(10,70) issdhi(j)
70	format(2x,z6)
60	isum(1)=isum(1)+issdhi(j)
	type *, ' finished issdhi'
	do 75 j=1,3
75	read(10,30)
	do 80 j=1,2048
	read(10,70) issdlo(j)
80	isum(2)=isum(2)+issdlo(j)
	type *, ' finished issdlo'
	do 90 j=1,3
90	read(10,30)
	do 100 i=1,128
	do 100 j=1,128
	read(10,70) ibox_array(i,j)
100	isum(3)=isum(3)+ibox_array(i,j)

	type *, ' box array sum: ',isum(3)

	do 110 j=1,3
110	read(10,30)
	do 120 j=1,512
	read(10,70) itof(j)
120	isum(4)=isum(4)+itof(j)
		type *, ' finished tof'

	write(25,200) (isum(i),i=1,4)
200	format(' ssdhi     table decimal checksum = 'i12,/,
     *         ' ssdlo     table decimal checksum = 'i12,/,
     *         ' box_array table decimal checksum = 'i12,/,
     *         ' tof       table decimal checksum = 'i12)
c
c	finish up
c
	isum(5)=isum(1)+isum(2)+isum(3)+isum(4)
	write(25,195) isum(5)
195	format(' total checksum: ',i12)	

	call mvbits(isum(5), 0, 24, i24, 0)

	write(25,95) i24, i24
95	format(' low order 24 bits of checksum: ',i12, ' decimal',/,
     *         ' low order 24 bits of checksum: ',z12, ' hex')
	close(25)
	return

	end

	subroutine write_kalfile
c
c	writes out a kaleidagraph file for display of boxes

c
	include 'table_checker_include.inc'


c
c	Read in rate boxes
c
	read(30,19)  ! space over header line
19	format(x)

	
	ilast=1
	ibstart = 0
	do 100 i=1,128
	read(30,*,end=200) box_name(ilast), Emin(ilast), Emax(ilast), 
     *           Amin(ilast),Amax(ilast), Aavg(ilast), Atno(ilast), 
     *           Ibox(ilast)   
c	type *,  box_name(ilast), Emin(ilast), Emax(ilast),
c     *           Amin(ilast),Amax(ilast), Aavg(ilast), Atno(ilast),
c     *           Ibox(ilast)
c	skip rates labeled as 'spare' -- rates
	if(box_name(ilast)(1:5).eq.'spare') goto 100
c	keep track of the first box that is a beacon rate (box # >=256)
	if(Ibox(ilast).lt.256) goto 90
	if(ibstart.eq.1) goto 90
	ibstart = 1
	ibfirst = ilast        ! this is the first box that's a beacon box
90      ilast=ilast+1  
100	continue


c
c	find number of types  rate boxes, 1 per atomic mass
c
200	ilast=ilast-1
	type *, ' arrays read in; ibfirst; ilast = ',ibfirst,ilast
c	(priority 0 and 1 boxes will be handled separately)
	element_type(1)='H'   ! name of this type
	itype_length(1)=1     ! number of characters in the name
	itype(1)=1            ! array of types
	alast = aavg(1)

	itypes = 1     
	do 150 i=2,ilast
	if(aavg(i).eq.alast) goto 130
	goto 140
130	itype(i) = itype(i-1)
	goto 150
140	itype(i) = itype(i-1) + 1
	itypes = itypes + 1
c	label rates with box number 256 and up as 'beacon'
	element_type(itypes) = box_name(i)
c	store length of this label
	itype_length(itypes)=
     *      index(element_type(itypes), " ") - 1
c	check for beacon rate
	if(ibox(i).lt.256) goto 149
c	label beacon rate as such
	element_type(itypes) = 'beacon '//element_type(itypes) 
c	adjust label length
	itype_length(itypes)=itype_length(itypes)+7
149	alast=aavg(i)
150	continue
c
c

c

c	do 199 i=1,128
c199	type *, 'box_name(i),Ibox(i),i, itype(i):'
c     *   , box_name(i),Ibox(i),i, itype(i), Ibox(i)/256
	type *, ' ibfirst = ', ibfirst




	type *, ' in subroutine kalfile; itypes = ',itypes
	do 998 i=1,itypes
998	type *, i, element_type(i),itype_length(i)

	output_file = input_file(1:len_to_ext)//'boxes'
	open(unit=12,name=output_file,recl=30000,status='new')


c	re-written to replace write(12,20) stmt below, 9/23/2010 /gm
	input_file = adjustl(trim(input_file(1:iname_len)))
	do 10 i = 1,128
10	element_type(i) =   (adjustl(trim(element_type(i))))
	write(12, 20)  input_file(1:iname_len),
     *     (element_type(i),i=1,itypes)

c	write(12, 20)  adjustl(trim(input_file(1:iname_len))), 
c    *        (adjustl(trim(element_type(i))),i=1,itypes)
20	format(' STEREO / SIT rate boxes: ',//,
     *     ' input hex file: ',a,//,
     *     ' f(e) cell, f(m) cell, Box No.,Beacon Box. No.,junk,', 
     *     'Pri 0,Pri 1,',
     *       128(a,','))

c	before examining the array, add up the elements & max & min box
	iboxmax=0
	iboxmin=200
	isumtotal=0
	do 699 i=1,128
	do 699 j=1,128
	if(ibox_array(i,j).gt.iboxmax) iboxmax=ibox_array(i,j)
	if(ibox_array(i,j).lt.iboxmin) iboxmin=ibox_array(i,j)
699	isumtotal=isumtotal+ibox_array(i,j)
	type *, ' iboxmax, iboxmin, isumtotal: ',
     *  iboxmax, iboxmin, isumtotal
	
	do 198 i=1,128
	do 198 j=1,128
c	process regular bin box first - 
c	put the matrix rate number into iregbox
	call mvbits(ibox_array(i,j),0,7,iregbox,0)
c	put beacon box number into ibeabox
	call mvbits(ibox_array(i,j),8,4,ibeabox,0)
c	extract the priority bit
	call mvbits(ibox_array(i,j),7,1,ipri,0)
	if((i.eq.80).and.(j.eq.20)) type *, ' ibox_array(i,j),iregbox,',
     *   ' ibeabox, ipri, itype(reg), itype (bea): ', ibox_array(i,j), 
     *     iregbox,ibeabox, ipri, itype(iregbox),
     *     itype(ibfirst+ibeabox-1)


c	type *, ipri,i,j,ibox_array(i,j),iregbox,ibeabox


	do 40 k=1,20
40	iout(k)=-1

	if(ibox_array(i,j).eq.7) iout(1)=j
	if(ipri.eq.0) iout(2)=j
	if(ipri.eq.1) iout(3)=j
c	if junk rate box, just write out at this point
	if(ibox_array(i,j).eq.7) goto 50



	do 45 k=1,itypes
	if(itype(iregbox-7).eq.k) iout(k+3)=j  ! subtract off the 7 fixed 
c						boxes  
c	see if there is a beacon rate also in this box, if so set
	if(ibeabox.eq.0) goto 45
	if(itype(ibeabox+ibfirst-1).eq.k) iout(k+3)=j
45	continue


50	write(12,55) i,j,iregbox,ibeabox,(iout(k),k=1,itypes+3)
55	format( <itypes+7>(i5','))

198	continue	

	return
	end
	subroutine write_ranges
c
c	search f_e and f_m matrix to find actual average start and 
c	end values for matrix rates
c
	include 'table_checker_include.inc'



c
c	look up actual average min & max energies for each rate 
c

	do 450 k = 1,ilast
	esum=0.
	apts=0.

	do 401 j=1,128
	do 400 i=1,128

c	type *, ' point 1, i,j,k, ibox_array(i,j), ibox(k): ',
c     *       i,j,k, ibox_array(i,j), ibox(k)

c	check to see if this cell has a beacon rate in it
	if(ibox(k).ge.256) goto 600
c	is a regular matrix rate, so look at low order 7 bits
c	(note:  bit 8 is the priority bit! / gm 9-15-05)
	if(mod(ibox_array(i,j),128).ne.ibox(k)) goto 400
	goto 601
c	beacon rate test
600	if(ibox_array(i,j)/256.ne.ibox(k)/256) goto 400


601	xbin=i
	ybin=j
c	type *, ' a hit:  ibox_array(i,j): ',ibox_array(i,j)
c	type *, ' pre fme call, i,j,k: ',i,j,k

	call fme_to_channel(xbin,ybin,
     *            iunit,ch_tof,ch_ssd,igain)
c	type *, ' post fme call, i,j,k: ',i,j,k


c	type *, i,j,iunit, ch_tof, ch_ssd, igain

c	now convert to actual mass and incident energy
c	type *, ' pre convert call, i,j,k: ',i,j,k
	call sit_convert(iunit, ch_ssd, igain, ch_tof, 
     *    einc_tof, einc_ssd, amass, emeas, tof)
c	type *, ' post convert call, i,j,k: ',i,j,k
	
	esum=esum+einc_tof
	apts=apts+1.
c	type *, esum, apts, einc_tof, esum/apts
	goto 401
	
400	continue
401	continue


	Emin_avg(k)=0.

	if(apts.le.0.) goto 450
	
	Emin_avg(k)=esum/apts

c
c	now search for the maximum average energy for each rate bin
c
	esum=0.
	apts=0.

	do 471 j=1,128
	do 470 i=128,1,-1

c	check to see if this cell has a beacon rate in it
	if(ibox(k).ge.256) goto 610
c	is a regular matrix rate, so look at low order bits
c	(note:  bit 8 is the priority bit! / gm 9-15-05)
	if(mod(ibox_array(i,j),128).ne.ibox(k)) goto 470
	goto 611
c	beacon rate test
610	if(ibox_array(i,j)/256.ne.ibox(k)/256) goto 470


611	xbin=i
	ybin=j
	call fme_to_channel(xbin+1.0,ybin+1.0,
     *            iunit,ch_tof,ch_ssd,igain)


c	type *, i,j,iunit, ch_tof, ch_ssd, igain

c	now convert to actual mass and incident energy
	call sit_convert(iunit, ch_ssd, igain, ch_tof, 
     *    einc_tof, einc_ssd, amass, emeas, tof)
	
	esum=esum+einc_tof
	apts=apts+1.
	goto 471

470	continue
471	continue

	Emax_avg(k)=0.

	if(apts.le.0.) goto 450
	
	Emax_avg(k)=esum/apts

c	type *, apts, Emin_avg(k), Emax_avg(k)
450	continue

c
c	now write out file with input and actual ranges
c
	output_file = input_file(1:len_to_ext)//'ranges'
	open(unit=20,name=output_file,status='new')


	
	write(20,500) adjustl(trim(input_file(1:iname_len)))
500	format(' STEREO / SIT actual box energies ',//,
     *    ' input sitmr file used: ',a,//,
     *    ' Element,box number,Emin_avg,Emax_avg,Emin,Emax,',
     *    'Amin,Amax,Aavg,Atno,')
	do 510 k=1,ilast
	write(20,505) box_name(k),ibox(k),emin_avg(k),emax_avg(k),
     *      emin(k),emax(k),amin(k), amax(k), aavg(k), atno(k)
510	continue
505	format(1x,a8','i4,','8(f8.4,','))


	return
	end

	subroutine write_calibration
c
c	routine to write out SSD and TOF calibrations from input hex files
c
	include 'table_checker_include.inc'

	output_file = adjustl(trim(input_file))//'calibration'
	open(unit=35,name=adjustl(trim(output_file)),status='new')
	write(35,40) adjustl(trim(input_file)), issdhi(4),issdlo(4),
     *     itof(4)
40	format(' SIT energy and tof calibrations',//,
     *    ' input hex file: ',a,/,
     *    ' creation date for issdhi: ',z6,/,
     *    ' creation date for issdlo: ',z6,/,
     *    ' creation date for itof:   ',z6,//,
     *    ' Channel, SSD hi gain MeV,SSD lo gain MeV,TOF ns,',
     *    'delta SSD hi,delta SSD lo,delta tof,')

c	get lower channel limits from issdhi array

	ioffset_ssdhi = issdhi(1)/2**16
	ioffset_ssdlo = issdlo(1)/2**16
	ioffset_tof = itof(1)/2**16


	do 100 i=issdhi(2),issdhi(3)
	ssdhi = issdhi(i)
	ssdhi=ssdhi/2**16
	ssdhi= ssdhi-ioffset_ssdhi
	ssdhi = exp(ssdhi)
	igain=0   ! high gain
	channel=i-1
	call ssd_ch_to_mev(iunit, igain, channel, amev)
	ssdhi_dif = ssdhi - amev


	ssdlo = issdlo(i)
	ssdlo=ssdlo/2**16
	ssdlo= ssdlo-ioffset_ssdlo
	ssdlo = exp(ssdlo)
	igain=1   ! high gain
	call ssd_ch_to_mev(iunit, igain, channel, amev)
	ssdlo_dif = ssdlo - amev


	tof = 0.
	tof_dif = 0.
	if(i.gt.512) goto 100   ! don't do tof channels above 512

	tof = itof(i)
	tof = tof/2**16
	tof = tof - ioffset_tof
	tof = exp(tof)
	tof = tof/0.021
	if(tof.gt.0.) tof = sqrt(tof)
	tof_dif = tof - tof_ch_to_ns(iunit, channel)

100	write(35,55) i, ssdhi, ssdlo, tof, ssdhi_dif, ssdlo_dif,
     *    tof_dif
55	format(2x,i4',',6(1pe12.4','))

	return
	end


c	include 'sit_convert.inc'
c	include 'fme_to_channel.inc'
c	include 'SSD_CH_TO_MEV.inc'
c	include 'tof_CH_TO_ns.inc'
c	include 'interpolate_ln.inc'
	
