#!/bin/bash
# Create a set of daily LET Level 1 ASCII data files for a given spacecraft,
# starting at given start YEAR/DOY, ending at given end YEAR/DOY.
# If PUBPRI=private, create EVP, BUF, Trig and singles data files, and
# also, create EVP, BUF, Trig, and singles rate plots
#
# Code depends upon $DS and $DE being three-digits, with leading zeros if necessary.

. /home/stereo/Software/procenv

# aliases do not get passed down, so run this anyway
. /usr/local/rsi/idl71/bin/idl_setup.bash

SC=$1
PUBPRI=$2
YS=$3
DS=$4
YE=$5
DE=$6

if [ $SC != "ahead" -a $SC != "behind" ]; then
   echo Usage: $0 SC, where SC is either ahead or behind
   exit 1
fi

if [ $PUBPRI != "public" -a $PUBPRI != "private" ]; then
   echo Usage: $0 SC pubpri, where pubpri is public or private
   exit 1
fi

export DOSTANDARD=1
export DOSUMMED=1
export DOSECTORED=1
if [ -z $DOPLOTS ]; then
   export DOPLOTS=1
fi
   

if [ $PUBPRI == "public" ]; then
   export DORATES=0
   export LET_L1_CALIB_DATA=$STEREOIDL/LETLevel1/calfiles_public
   export COMMENT="Verified Data - OK to distribute"
   LOGFILE=logs/runl1_short_public.log
   rm $LETL1PUBDATAHOME/Factors_files/LET_*.txt
   cp $LET_L1_CALIB_DATA/LET_*.txt $LETL1PUBDATAHOME/Factors_files
else
   export DORATES=1
   export LET_L1_CALIB_DATA=$STEREOIDL/LETLevel1/calfiles
   export COMMENT="UNVERIFIED DATA - for internal Caltech SRL use only - do not distribute"
   LOGFILE=logs/runl1_short.log
   rm $LETL1SRLONLYDATAHOME/Factors_files/LET_*.txt
   cp $LET_L1_CALIB_DATA/LET_*.txt $LETL1SRLONLYDATAHOME/Factors_files
fi

# LET Level 1 data Version number
L1VERSIONSTR=`awk '($1=="VERSION"){print $3; exit}' let_l1_common.pro`
L1VERSION=`expr "$L1VERSIONSTR" : '\([0-9]*\)'`
if [ $L1VERSION -lt 10 ]; then L1VERSION=0$L1VERSION; fi
export L1VERSION

INDIR=$L0HOME/$SC/Subsetted

echo `date` >> $LOGFILE
echo $SC >> $LOGFILE

cd $STEREOIDL/LETLevel1

YEDE=${YE}$DE
YCDC=${YS}$DS
IDX=0
while [ $YCDC -lt $YEDE ]
do
   read YEAR DOY3 < <( ./yeardoy.pl $YS $DS $IDX )
   YCDC=${YEAR}$DOY3
   # echo $YEAR $DOY3 $YCDC

   if [ $PUBPRI == "public" ]; then
      export DESTDIRL1=$LETL1PUBDATAHOME/$SC/1Minute/$YEAR
   else
      export DESTDIRL1=$LETL1SRLONLYDATAHOME/$SC/1Minute/$YEAR
   fi
   export DESTDIRRATES=$LETRATESDATAHOME/$SC/$YEAR

   if [ ! -d $DESTDIRL1 ]; then
      $ECHO $0: making $DESTDIRL1 and subdirs
      for species in H He3 He4 He C N O Ne Na Mg Al Si S Ar Ca Fe Ni
      do
         mkdir -p $DESTDIRL1/Standard/$species
         mkdir -p $DESTDIRL1/Summed/$species
      done
      if [ $YEAR -le 2010 ]; then
         for species in H_lo He3_lo He4_lo He4_hi He_lo CNO_lo CNO_hi NeMgSi_lo NeMgSi_hi Fe_lo Fe_hi
         do
            mkdir -p $DESTDIRL1/Sectored/$species
         done
      fi
      if [ $YEAR -eq 2010 ]; then
         for species in H_vlo H_hi Fe
         do
            mkdir -p $DESTDIRL1/Sectored/$species
         done
      fi
      if [ $YEAR -gt 2010 ]; then
         for species in H_vlo H_lo H_hi He4_lo He4_hi CNO_lo CNO_hi NeMgSi_lo NeMgSi_hi Fe
         do
            mkdir -p $DESTDIRL1/Sectored/$species
         done
      fi
   fi

   if [ ! -d $DESTDIRRATES ]; then
      $ECHO $0: making $DESTDIRRATES
      mkdir -p $DESTDIRRATES
   fi

   export YEAR SC


   INFILE=NoNoNo
#   echo $INDIR $SC $YEAR $DOY3
   INFILE1=`/bin/ls $INDIR/let_${SC}_${YEAR}* | grep 'let_'$SC'_'$YEAR'_'$DOY3'_.*.ptp' | tail -1`
   INFILE2=`/bin/ls $INDIR/let_${SC}_${YEAR}* | grep 'let_'$SC'_'$YEAR'_'$DOY3'_.*.fin' | tail -1`
   if [ $INFILE1 ]; then INFILE=$INFILE1; fi
   if [ $INFILE2 ]; then INFILE=$INFILE2; fi
   if [ -f $INFILE ]; then
      echo $DOY3  $INFILE >> $LOGFILE
      export DOY3 INFILE
      if [ $YCDC -lt 2010326 ]; then
         if [ $DOSECTORED -gt 0 ]; then
	    export DOSECTORED=1
	 fi
         idl -quiet runl1_2010326.bat >> $LOGFILE 2>&1
      fi
# Note: we run 2010326 TWICE, to produce data files for before and after the
# onboard definitions change for sectored data
      if [ $YCDC -eq 2010326 ]; then
         if [ $DOSECTORED -gt 0 ]; then 
	    export DOSECTORED=1
	 fi
         idl -quiet runl1_2010326.bat >> $LOGFILE 2>&1
         if [ $? -ne 0 ]; then
            echo $0: $SC: idl error. Exiting...
            exit 1
         fi
         if [ $DOSECTORED -gt 0 ]; then
	    export DOSECTORED=2
	 fi
         idl -quiet runl1.bat >> $LOGFILE 2>&1
         if [ $? -ne 0 ]; then
            echo $0: $SC: idl error. Exiting...
            exit 1
         fi
      fi
      if [ $YCDC -ge 2010326 ]; then
         if [ $DOSECTORED -gt 0 ]; then
	    export DOSECTORED=2
	 fi
         idl -quiet runl1.bat >> $LOGFILE 2>&1
         if [ $? -ne 0 ]; then
            echo $0: $SC: idl error. Exiting...
            exit 1
         fi
      fi
      if [ $PUBPRI == "private" -a $DOPLOTS -eq 1 ]; then
         ../CreateRATEplots.ksh $SC $YEAR $DOY3 >> ../rate_plots.log 2>&1
#         if [ $? -ne 0 ]; then
#            echo $0: $SC: Error creating EVP, BUF, Trig rate plots. Continuing...
#            exit 1
#         fi
         ../CreateSNGRATEplots.ksh $SC $YEAR $DOY3 >> ../sngrate_plots.log 2>&1
#         if [ $? -ne 0 ]; then
#            echo $0: $SC: Error creating singles rate plots. Continuing...
#            exit 1
#         fi
      fi
   fi

   IDX=$(($IDX+1))
done

