; Sum up count-rate in each LET energy range for a given species/energy bin

function sum_rates, R2idx, R3idx, R4idx, decom_rates
 
  common let_l1

  IF ((R2idx lt 0) AND (R3idx lt 0) AND (R4idx lt 0)) THEN BEGIN
     rate_sum = FILL_L
  ENDIF ELSE BEGIN
     R2tmp = 0L 
     R3tmp = 0L 
     R4tmp = 0L 
     IF R2idx ge 0 THEN R2tmp = decom_rates.L2FGRATES[R2idx]
     IF R3idx ge 0 THEN R3tmp = decom_rates.L3FGRATES[R3idx]
     IF R4idx ge 0 THEN R4tmp = decom_rates.PENFGRATES[R4idx]
     IF ((R2tmp lt 0L) OR (R3tmp lt 0L) OR (R4tmp lt 0L)) THEN $
        rate_sum = FILL_L $
     ELSE rate_sum = R2tmp + R3tmp + R4tmp
  ENDELSE
  return, long(rate_sum)
end
