#!/bin/bash
# Generate daily averages for LET Level 1 data, for sectored data

. /home/stereo/Software/procenv

YEAR=$1
PUBPRI=$2
REDO=$3
MERGEDAYS=$4
SC=$5

if [ $PUBPRI != "public" -a $PUBPRI != "private" ]; then
   echo Usage: $0 YYYY pubpri, where pubpri is public or private
   exit 1
fi

if [ $SC != "ahead" -a $SC != "behind" ]; then
   echo Usage: $0 YYYY pubpri redo mergedays sc, where sc is ahead or behind
   exit 1
fi
      
cd $STEREOIDL/LETLevel1

# LET Level 1 data Version number
L1VERSIONSTR=`gawk '($1=="VERSION"){print $3; exit}' let_l1_common.pro`
L1SOFTWAREVERSION=`expr "$L1VERSIONSTR" : '\([0-9]*\)'`
if [ $L1SOFTWAREVERSION -lt 10 ]; then L1SOFTWAREVERSION=0$L1SOFTWAREVERSION; fi
export L1SOFTWAREVERSION

# Figure out appropriate SDOY and EDOY
EDOY=`date +%j`
if [ $EDOY -le $MERGEDAYS -o $REDO -ne 0 ]; then
   SDOY=1
else
   SDOY=$((10#$EDOY-$MERGEDAYS))
fi

# Check if we are running a previous year
CYEAR=`date +%Y`
if [ $YEAR -lt $CYEAR ]; then
   EDOY=366
   if [ $REDO -ne 0 ]; then
      SDOY=1
   else
      SDOY=$((10#$EDOY-$MERGEDAYS))
   fi
fi

if [ $SDOY -eq $EDOY ]; then
   echo $0: Error: SDOY equal to EDOY: $SDOY
   exit 1
fi

   if [ $PUBPRI == "public" ]; then
      SRCDIR=$LETL1PUBDATAHOME/$SC/1Minute/$YEAR/Sectored
      export DESTDIRL1=$LETL1PUBDATAHOME/$SC/Daily/$YEAR/Sectored
      export COMMENT="Verified Data - OK to distribute"
   else
      SRCDIR=$LETL1SRLONLYDATAHOME/$SC/1Minute/$YEAR/Sectored
      export DESTDIRL1=$LETL1SRLONLYDATAHOME/$SC/Daily/$YEAR/Sectored
      export COMMENT="UNVERIFIED DATA - for internal Caltech SRL use only - do not distribute"
   fi

   if [ ! -d $DESTDIRL1 ]; then
      $ECHO $0: making $DESTDIRL1
      mkdir -p $DESTDIRL1
   fi

sed -e 's/YYYYYY/'$YEAR'/g' -e 's/VVVVVV/'$L1SOFTWAREVERSION'/g' \
       -e 's/SCSCSC/'$SC'/g' -e 's/COMMENT/'"$COMMENT"'/g' \
       -e 's/hourly/daily/g' -e 's/1 hour/1 day/g' \
       -e 's/1-hour/daily/g' -e 's/each hour/each day/g' \
       < LET_1hr_sectored_hdrs_template.txt > LET_1day_sectored_hdrs_$SC.txt

   slist="H_vlo H_lo H_hi He4_lo He4_hi CNO_lo CNO_hi NeMgSi_lo NeMgSi_hi Fe"   
   if [ $YEAR -lt 2010 ]; then
      slist="H_lo He3_lo He4_lo He4_hi He_lo CNO_lo CNO_hi NeMgSi_lo NeMgSi_hi Fe_lo Fe_hi"
   fi
   if [ $YEAR -eq 2010 ]; then
      slist="H_vlo H_lo H_hi He3_lo He4_lo He4_hi He_lo CNO_lo CNO_hi NeMgSi_lo NeMgSi_hi Fe_lo Fe_hi Fe"
   fi

   for species in $slist
   do
         # echo $YEAR $SC $species
         # If public, pass CHKDYTHRESH=1 to gen_LET_avg.pl, for heavies, for 2010 and 2011.
	 # Note: further refinement of this flag is done within gen_LET_avg.pl
         CHKDYTHRESH=0
         if [[ $PUBPRI == "public" ]] && [[ (( $YEAR == 2010 )) || (( $YEAR == 2011 )) ]]; then
            if [ $species != "H_vlo" -a $species != "H_lo" -a $species != "H_hi" -a $species != "He3_lo" -a $species != "He_lo" -a $species != "He4_lo" -a $species != "He4_hi" ]; then
               CHKDYTHRESH=1
            fi
         fi
	 PUBLIC=0
	 if [ $PUBPRI == "public" ]; then
	    PUBLIC=1
	 fi
										    
	 Sspecies=${species}_sectored
         ./gen_LET_avg.pl DAILYAV $YEAR $SDOY $EDOY $Sspecies $SC \
	 $SRCDIR/$species \
	 $STEREOIDL/LETLevel1/LET_1day_sectored_hdrs_$SC.txt \
	 $STEREOIDL/LETLevel1/LET_sectored_nbins.txt \
	 ./tmpdata \
   	 $L1SOFTWAREVERSION $CHKDYTHRESH $PUBLIC
	 if [ $? -ne 0 ]; then
	    echo $0: exiting due to bad gen_LET_avg.pl exit status
	    exit 1
	 fi

	 # Merge most-recent MERGEDAYS days of data into existing file
	 filenm=${Sspecies}_${SC}_${YEAR}_1day_level1_${L1SOFTWAREVERSION}.txt
	 # filenm08=${Sspecies}_${SC}_${YEAR}_1day_level1_08.txt
	 if [ $SDOY -gt 1 ]; then
	    if [ -f $DESTDIRL1/$filenm ]; then
	       $BEHEAD $DESTDIRL1/$filenm | $GAWK '($2<'$SDOY'){print}' > tmpdata/tmp.dat
	       $GAWK '{print; if ($1=="BEGIN") exit}' ./tmpdata/$filenm > $DESTDIRL1/$filenm
	       cat tmpdata/tmp.dat >> $DESTDIRL1/$filenm	
	       $BEHEAD ./tmpdata/$filenm >> $DESTDIRL1/$filenm
	    else
	       echo $0: Warning: $DESTDIRL1/$filenm does not exist. Data files will begin at ${YEAR}-$SDOY
	       cp ./tmpdata/$filenm $DESTDIRL1/$filenm
	    fi
	 else
	    cp ./tmpdata/$filenm $DESTDIRL1/$filenm
	 fi
   done
   rm -f ./tmpdata/*
