#!/bin/bash
# Generate 10minute averages for LET Level 1 summed data 

. /home/stereo/Software/procenv

YEAR=$1
PUBPRI=$2
REDO=$3
MERGEDAYS=$4
SC=$5

if [ $PUBPRI != "public" -a $PUBPRI != "private" ]; then
   echo Usage: $0 YYYY pubpri, where pubpri is public or private
   exit 1
fi
      
if [ $SC != "ahead" -a $SC != "behind" ]; then
   echo Usage: $0 YYYY pubpri redo mergedays sc, where sc is ahead or behind
   exit 1
fi
      
cd $STEREOIDL/LETLevel1

# LET Level 1 data Version number
L1VERSIONSTR=`gawk '($1=="VERSION"){print $3; exit}' let_l1_common.pro`
L1SOFTWAREVERSION=`expr "$L1VERSIONSTR" : '\([0-9]*\)'`
if [ $L1SOFTWAREVERSION -lt 10 ]; then L1SOFTWAREVERSION=0$L1SOFTWAREVERSION; fi
export L1SOFTWAREVERSION

# Figure out appropriate SDOY and EDOY
# 
EDOY=`date +%j`
if [ $EDOY -le $MERGEDAYS -o $REDO -ne 0 ]; then
   SDOY=1
else
   SDOY=$((10#$EDOY-$MERGEDAYS))
fi

# Check if we are running a previous year
CYEAR=`date +%Y`
if [ $YEAR -lt $CYEAR ]; then
   EDOY=366
   if [ $REDO -ne 0 ]; then
      SDOY=1
   else
      SDOY=$((10#$EDOY-$MERGEDAYS))
   fi
fi

if [ $SDOY -eq $EDOY ]; then
   echo $0: Error: SDOY equal to EDOY: $SDOY
   exit 1
fi

# Figure last month to process for Public data
read XXX YYY EYEARPUB EDOYPUB < <( ./getpubprocdates.pl < ./PublicProcDates.txt )

   if [ $PUBPRI == "public" ]; then
      SRCDIR=$LETL1PUBDATAHOME/$SC/1Minute/$YEAR/Summed
      export DESTDIRL1ROOT=$LETL1PUBDATAHOME/$SC/10Minute/$YEAR/Summed
      export COMMENT="Verified Data - OK to distribute"
   else
      SRCDIR=$LETL1SRLONLYDATAHOME/$SC/1Minute/$YEAR/Summed
      export DESTDIRL1ROOT=$LETL1SRLONLYDATAHOME/$SC/10Minute/$YEAR/Summed
      export COMMENT="UNVERIFIED DATA - for internal Caltech SRL use only - do not distribute"
   fi

   sed -e 's/YYYYYY/'$YEAR'/g' -e 's/VVVVVV/'$L1SOFTWAREVERSION'/g' \
       -e 's/SCSCSC/'$SC'/g' -e 's/COMMENT/'"$COMMENT"'/g' < LET_10min_summed_hdrs_template.txt > LET_10min_summed_hdrs_$SC.txt

   for species in H He3 He4 He C N O Ne Na Mg Al Si S Ar Ca Fe Ni
#   for species in H 
   do
         export DESTDIRL1=$DESTDIRL1ROOT/$species
         if [ ! -d $DESTDIRL1 ]; then
            $ECHO $0: making $DESTDIRL1
            mkdir -p $DESTDIRL1
         fi

         # echo $YEAR $SC $species $SRCDIR
         # If public, pass CHKDYTHRESH=1 to gen_LET_avg.pl, for heavies, for 2010 and 2011.
	 # Note: further refinement of this flag is done within gen_LET_avg.pl
         CHKDYTHRESH=0
         if [[ $PUBPRI == "public" ]] && [[ (( $YEAR == 2010 )) || (( $YEAR == 2011 )) ]]; then
            if [ $species != "H" -a $species != "He3" -a $species != "He4" -a $species != "He" ]; then
               CHKDYTHRESH=1
            fi
         fi
	 PUBLIC=0
	 if [ $PUBPRI == "public" ]; then
	    PUBLIC=1
	 fi

	 Sspecies=${species}_summed
         ./gen_LET_avg_new.pl 10MINAV $YEAR $SDOY $EDOY $Sspecies $SC \
	 $SRCDIR/$species \
	 $STEREOIDL/LETLevel1/LET_10min_summed_hdrs_$SC.txt \
	 $STEREOIDL/LETLevel1/LET_summed_nbins.txt \
	 ./tmpdata \
   	 $L1SOFTWAREVERSION $CHKDYTHRESH $PUBLIC
	 if [ $? -ne 0 ]; then
	    echo $0: exiting due to bad gen_LET_avg.pl exit status
	    exit 1
	 fi

         # Merge most-recent MERGEDAYS days of data into existing file
	 filenm=${Sspecies}_${SC}_${YEAR}_10min_level1_${L1SOFTWAREVERSION}.txt
	 if [ $SDOY -gt 1 ]; then
	    if [ -f $DESTDIRL1/$filenm ]; then
	       $BEHEAD $DESTDIRL1/$filenm | $GAWK '($2<'$SDOY'){print}' > tmpdata/tmp.dat
	       $GAWK '{print; if ($1=="BEGIN") exit}' ./tmpdata/$filenm > $DESTDIRL1/$filenm
	       cat tmpdata/tmp.dat >> $DESTDIRL1/$filenm	
	       $BEHEAD ./tmpdata/$filenm >> $DESTDIRL1/$filenm
	    else
	       echo $0: Warning: $DESTDIRL1/$filenm does not exist. Data files will begin at ${YEAR}-$SDOY
	       cp ./tmpdata/$filenm $DESTDIRL1/$filenm
	    fi
	 else
	    cp ./tmpdata/$filenm $DESTDIRL1/$filenm
	 fi
	 # Break yearly file into monthly files
#	 echo $YEAR $SDOY $EDOY
         $BEHEAD $DESTDIRL1/$filenm > ./tmpdata/tmpm.dat
	 $GAWK '{print; if ($1=="BEGIN") exit}' $DESTDIRL1/$filenm > ./tmpdata/tmpm2.dat
	 for month in 01 02 03 04 05 06 07 08 09 10 11 12
#	 for month in 04
	 do
	    read MONTHSTART MONTHEND MONTHNAME < <( ./monthdays.pl $YEAR $month )
	    if [ $MONTHSTART -gt $EDOY ]; then
	       break
	    fi
	    if [ $MONTHEND -lt $SDOY ]; then
	       continue
	    fi
	    if [ $YEAR -eq 2006 -a $month -lt 11 ]; then
	       continue
	    fi
	    if [ $PUBPRI == "public" -a $YEAR -eq $EYEARPUB -a $MONTHSTART -gt $EDOYPUB ]; then
	       break
	    fi
	    if [ $PUBPRI == "public" -a $YEAR -gt $EYEARPUB ]; then
	       break
	    fi
#	    echo $MONTHSTART $MONTHEND $MONTHNAME
   	    filenm=${Sspecies}_${SC}_${YEAR}_${month}_10min_level1_${L1SOFTWAREVERSION}.txt
            sed -e 's/for '$YEAR'/for '$MONTHNAME' '$YEAR'/g' < ./tmpdata/tmpm2.dat > ./tmpdata/$filenm
	    $GAWK 'BEGIN{end='$MONTHEND' + 0.99999} \
	    	($2>='$MONTHSTART')&&($2<=end){print}' \
		./tmpdata/tmpm.dat >> ./tmpdata/$filenm
            cp ./tmpdata/$filenm $DESTDIRL1/$filenm
	 done
   done
   rm -f ./tmpdata/*
