#!/bin/bash

. /home/stereo/Software/procenv

cd $STEREOIDL/LETLevel1

if [ -f running_daily.txt ]; then
   echo $0: Exiting - previous instance of run_daily appears to be still running
   exit 1
fi

if [ ! -d /users/asc/utils ]; then
   echo run_daily: /users/asc/utils does not exist
   exit 1
fi

/bin/touch running_daily.txt

# do private 1-minute data files update
NBACKPRIVATE=5
read SYEAR SDOY < <( ./ndays_ago.pl $NBACKPRIVATE )
read EYEAR EDOY < <( ./ndays_ago.pl 0 )

YEAR=2013

export DOPLOTS=1

BART=2420

/bin/touch running_daily.txt

# do private 1-minute data files update
./update_l1_files.bash ahead private $SYEAR $SDOY $EYEAR $EDOY
./update_l1_files.bash behind private $SYEAR $SDOY $EYEAR $EDOY

# exit

MERGEDAYS=75	# ignored, for redo. 

./run_gen_LET_1hr.ksh $YEAR private 0 $MERGEDAYS ahead
./run_gen_LET_1hr.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_1hr_summed.ksh $YEAR private 0 $MERGEDAYS ahead
./run_gen_LET_1hr_summed.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_1hr_sectored.ksh $YEAR private 0 $MERGEDAYS ahead
./run_gen_LET_1hr_sectored.ksh $YEAR private 0 $MERGEDAYS behind

./run_gen_LET_1day.ksh $YEAR private 0 $MERGEDAYS ahead
./run_gen_LET_1day.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_1day_summed.ksh $YEAR private 0 $MERGEDAYS ahead
./run_gen_LET_1day_summed.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_1day_sectored.ksh $YEAR private 0 $MERGEDAYS ahead
./run_gen_LET_1day_sectored.ksh $YEAR private 0 $MERGEDAYS behind

./run_gen_LET_10min.ksh $YEAR private 0 $MERGEDAYS ahead
./run_gen_LET_10min.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_10min_summed.ksh $YEAR private 0 $MERGEDAYS ahead
./run_gen_LET_10min_summed.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_10min_sectored.ksh $YEAR private 0 $MERGEDAYS ahead
./run_gen_LET_10min_sectored.ksh $YEAR private 0 $MERGEDAYS behind

#   cd 27day_averages
#   BART=`./bartelsfmyyyyddd.pl $EYEAR $EDOY`;
#   BART=$(( $BART - 1 ))
#   ./run_27day_averages private $BART
#   cd ..

/bin/rm -f running_daily.txt

sleep 10

./plots/update_l1_plots.bash

