#!/bin/bash
# Daily LET Level 1 processing, for both public and private data sets
#
# June 2007, A. Davis, Caltech

. /home/stereo/Software/procenv

if [ $# -ne 1 ]; then
   echo Usage: run_daily.bash NBACKPRIVATE
   exit
fi

. /usr/local/rsi/idl71/bin/idl_setup.bash

cd $STEREOIDL/LETLevel1

if [ -f running_daily.txt ]; then
   echo $0: Exiting - previous instance of run_daily appears to be still running
   exit 1
fi

idl -quiet testidl.bat > testidl.out 2>&1
if [ -s testidl.out ]; then
   echo $0: Exiting - idl does not appear to be available
   exit 1
fi

if [ ! -d /users/asc/utils ]; then
   echo run_daily: /users/asc/utils does not exist
   exit 1
fi

/bin/touch running_daily.txt

MERGEDAYS=75

# do private 1-minute data files update
NBACKPRIVATE=$1
read SYEAR SDOY < <( ./ndays_ago.pl $NBACKPRIVATE )
read EYEAR EDOY < <( ./ndays_ago.pl 0 )
CYEAR=$EYEAR
CDOY=$EDOY

export DOPLOTS=1

./update_l1_files.bash ahead private $SYEAR $SDOY $EYEAR $EDOY
# ./update_l1_files.bash behind private $SYEAR $SDOY $EYEAR $EDOY

# Once SRLONLY daily files for a new year begin to accumulate in
# $LETL1SRLONLYDATAHOME/$SC/1Minute/$YEAR/Standard,
# and DOY >2, change YEAR here
YEAR=2022

if [ $YEAR -lt $EYEAR -a $CDOY -gt 2 ]; then
   echo $0: Reminder: Update YEAR variable for SRLONLY hourly/daily averaging...
fi

if [ $EDOY -eq 35 ]; then
   echo $0: Reminder: Redo SRLONLY Level 1 data for previous year...
fi

./run_gen_LET_1hr.ksh $YEAR private 0 $MERGEDAYS ahead
if [ $? -ne 0 ]; then
   echo $0: Bad run_gen_LET_1hr.ksh exit status: Exiting...
   /bin/rm -f running_daily.txt
   exit
fi
# ./run_gen_LET_1hr.ksh $YEAR private 0 $MERGEDAYS behind

./run_gen_LET_1hr_summed.ksh $YEAR private 0 $MERGEDAYS ahead
# ./run_gen_LET_1hr_summed.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_1hr_sectored.ksh $YEAR private 0 $MERGEDAYS ahead
# ./run_gen_LET_1hr_sectored.ksh $YEAR private 0 $MERGEDAYS behind

./run_gen_LET_1day.ksh $YEAR private 0 $MERGEDAYS ahead
# ./run_gen_LET_1day.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_1day_summed.ksh $YEAR private 0 $MERGEDAYS ahead
# ./run_gen_LET_1day_summed.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_1day_sectored.ksh $YEAR private 0 $MERGEDAYS ahead
# ./run_gen_LET_1day_sectored.ksh $YEAR private 0 $MERGEDAYS behind

./run_gen_LET_10min.ksh $YEAR private 0 $MERGEDAYS ahead
# ./run_gen_LET_10min.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_10min_summed.ksh $YEAR private 0 $MERGEDAYS ahead
# ./run_gen_LET_10min_summed.ksh $YEAR private 0 $MERGEDAYS behind
./run_gen_LET_10min_sectored.ksh $YEAR private 0 $MERGEDAYS ahead
# ./run_gen_LET_10min_sectored.ksh $YEAR private 0 $MERGEDAYS behind

cd 27day_averages
BART=`./bartelsfmyyyyddd.pl $EYEAR $EDOY`;
BART=$(( $BART - 1 ))
./run_27day_averages private $BART
cd ..


# do public 1-minute data files update
read SYEAR SDOY EYEAR EDOY < <( ./getpubprocdates.pl < ./PublicProcDates.txt )
./update_l1_files.bash ahead public $SYEAR $SDOY $EYEAR $EDOY
# ./update_l1_files.bash behind public $SYEAR $SDOY $EYEAR $EDOY


# Have to change YEAR separately for public data, since
# the public data are about 1 month behind...
YEAR=2022

DCDOY=$(( 10#$CDOY ))
if [ $YEAR -lt $CYEAR -a $DCDOY -gt 36 ]; then
   echo $0: Reminder: Validate another month of LET L1 data and Update Public YEAR variable after December is done
fi

DDIFF=$(( 10#$CDOY - 10#$EDOY ))
if [ $CYEAR -eq $YEAR -a $DDIFF -lt 0 ]; then
   if [ $EDOY -eq 365 -o $EDOY -eq 366 ]; then
      DDIFF=$(( $DDIFF + $EDOY ))
   fi
fi

nopub=0

# No need to re-compute public averages if start and end days are equal
if [ $SYEAR -eq $EYEAR -a $SDOY -eq $EDOY ]; then
   nopub=1
fi

# echo $nopub $YEAR $CYEAR $CDOY $EDOY $DDIFF
if [ $CYEAR -eq $YEAR -a $DDIFF -ge 65 ]; then
   if [ $nopub -eq 0 ]; then
      echo run_daily: need to run a modified version of me to process data this old
      echo $nopub $YEAR $CYEAR $CDOY $EDOY $DDIFF      
   else
      echo run_daily: Reminder: Need to validate another month of LET L1 data
      echo $nopub $YEAR $CYEAR $CDOY $EDOY $DDIFF
   fi
   nopub=1
fi

if [ $nopub -eq 0 ]; then
   MERGEDAYS=90

   ./run_gen_LET_1hr.ksh $YEAR public 0 $MERGEDAYS ahead
#   ./run_gen_LET_1hr.ksh $YEAR public 0 $MERGEDAYS behind
   ./run_gen_LET_1hr_summed.ksh $YEAR public 0 $MERGEDAYS ahead
#   ./run_gen_LET_1hr_summed.ksh $YEAR public 0 $MERGEDAYS behind
   ./run_gen_LET_1hr_sectored.ksh $YEAR public 0 $MERGEDAYS ahead
#   ./run_gen_LET_1hr_sectored.ksh $YEAR public 0 $MERGEDAYS behind

   ./run_gen_LET_1day.ksh $YEAR public 0 $MERGEDAYS ahead
#   ./run_gen_LET_1day.ksh $YEAR public 0 $MERGEDAYS behind
   ./run_gen_LET_1day_summed.ksh $YEAR public 0 $MERGEDAYS ahead
#   ./run_gen_LET_1day_summed.ksh $YEAR public 0 $MERGEDAYS behind
   ./run_gen_LET_1day_sectored.ksh $YEAR public 0 $MERGEDAYS ahead
#   ./run_gen_LET_1day_sectored.ksh $YEAR public 0 $MERGEDAYS behind

   ./run_gen_LET_10min.ksh $YEAR public 0 $MERGEDAYS ahead
#   ./run_gen_LET_10min.ksh $YEAR public 0 $MERGEDAYS behind
   ./run_gen_LET_10min_summed.ksh $YEAR public 0 $MERGEDAYS ahead
#   ./run_gen_LET_10min_summed.ksh $YEAR public 0 $MERGEDAYS behind
   ./run_gen_LET_10min_sectored.ksh $YEAR public 0 $MERGEDAYS ahead
#   ./run_gen_LET_10min_sectored.ksh $YEAR public 0 $MERGEDAYS behind

   cd 27day_averages
   BART=`./bartelsfmyyyyddd.pl $SYEAR $SDOY`;
   ./run_27day_averages public $BART
   cd ..
fi

/bin/rm -f running_daily.txt

sleep 60

./plots/update_l1_plots.bash

