#!/bin/bash

. /home/stereo/Software/procenv

cd $STEREOIDL/LETLevel1

if [ -f running_daily.txt ]; then
   echo $0: Exiting - previous instance of run_daily appears to be still running
   exit 1
fi

if [ ! -d /users/asc/utils ]; then
   echo run_daily: /users/asc/utils does not exist
   exit 1
fi

/bin/touch running_daily.txt

SYEAR=2010
SDOY=213
EYEAR=2010
EDOY=216
YEAR=2010
export DOPLOTS=0

BART=2420

/bin/touch running_daily.txt

# do private 1-minute data files update
./update_l1_files.bash ahead private $SYEAR $SDOY $EYEAR $EDOY
./update_l1_files.bash behind private $SYEAR $SDOY $EYEAR $EDOY

# exit

   MERGEDAYS=42	# ignored, for redo. 

./run_gen_LET_1hr.ksh $YEAR private 1 $MERGEDAYS ahead
./run_gen_LET_1hr.ksh $YEAR private 1 $MERGEDAYS behind
./run_gen_LET_1hr_summed.ksh $YEAR private 1 $MERGEDAYS ahead
./run_gen_LET_1hr_summed.ksh $YEAR private 1 $MERGEDAYS behind
./run_gen_LET_1hr_sectored.ksh $YEAR private 1 $MERGEDAYS ahead
./run_gen_LET_1hr_sectored.ksh $YEAR private 1 $MERGEDAYS behind

./run_gen_LET_1day.ksh $YEAR private 1 $MERGEDAYS ahead
./run_gen_LET_1day.ksh $YEAR private 1 $MERGEDAYS behind
./run_gen_LET_1day_summed.ksh $YEAR private 1 $MERGEDAYS ahead
./run_gen_LET_1day_summed.ksh $YEAR private 1 $MERGEDAYS behind
./run_gen_LET_1day_sectored.ksh $YEAR private 1 $MERGEDAYS ahead
./run_gen_LET_1day_sectored.ksh $YEAR private 1 $MERGEDAYS behind

./run_gen_LET_10min.ksh $YEAR private 1 $MERGEDAYS ahead
./run_gen_LET_10min.ksh $YEAR private 1 $MERGEDAYS behind
./run_gen_LET_10min_summed.ksh $YEAR private 1 $MERGEDAYS ahead
./run_gen_LET_10min_summed.ksh $YEAR private 1 $MERGEDAYS behind
./run_gen_LET_10min_sectored.ksh $YEAR private 1 $MERGEDAYS ahead
./run_gen_LET_10min_sectored.ksh $YEAR private 1 $MERGEDAYS behind

/bin/rm -f running_daily.txt

