#!/bin/bash

. /home/stereo/Software/procenv

cd $STEREOIDL/LETLevel1

# ./run_daily_private.bash

if [ -f running_daily.txt ]; then
   echo $0: Exiting - previous instance of run_daily appears to be still running
   exit 1
fi

if [ ! -d /users/asc/utils ]; then
   echo run_daily: /users/asc/utils does not exist
   exit 1
fi



/bin/touch running_daily.txt

YEAR=2013
SYEAR=$YEAR
SDOY=1
EYEAR=$YEAR
EDOY=365
export DOPLOTS=0

/bin/touch running_daily.txt

# do public 1-minute data files update
./update_l1_files.bash ahead public $SYEAR $SDOY $EYEAR $EDOY
./update_l1_files.bash behind public $SYEAR $SDOY $EYEAR $EDOY

# exit

   MERGEDAYS=42	# ignored, for redo. 

./run_gen_LET_1hr.ksh $YEAR public 1 $MERGEDAYS ahead
./run_gen_LET_1hr.ksh $YEAR public 1 $MERGEDAYS behind
./run_gen_LET_1hr_summed.ksh $YEAR public 1 $MERGEDAYS ahead
./run_gen_LET_1hr_summed.ksh $YEAR public 1 $MERGEDAYS behind
./run_gen_LET_1hr_sectored.ksh $YEAR public 1 $MERGEDAYS ahead
./run_gen_LET_1hr_sectored.ksh $YEAR public 1 $MERGEDAYS behind

./run_gen_LET_1day.ksh $YEAR public 1 $MERGEDAYS ahead
./run_gen_LET_1day.ksh $YEAR public 1 $MERGEDAYS behind
./run_gen_LET_1day_summed.ksh $YEAR public 1 $MERGEDAYS ahead
./run_gen_LET_1day_summed.ksh $YEAR public 1 $MERGEDAYS behind
./run_gen_LET_1day_sectored.ksh $YEAR public 1 $MERGEDAYS ahead
./run_gen_LET_1day_sectored.ksh $YEAR public 1 $MERGEDAYS behind

./run_gen_LET_10min.ksh $YEAR public 1 $MERGEDAYS ahead
./run_gen_LET_10min.ksh $YEAR public 1 $MERGEDAYS behind
./run_gen_LET_10min_summed.ksh $YEAR public 1 $MERGEDAYS ahead
./run_gen_LET_10min_summed.ksh $YEAR public 1 $MERGEDAYS behind
./run_gen_LET_10min_sectored.ksh $YEAR public 1 $MERGEDAYS ahead
./run_gen_LET_10min_sectored.ksh $YEAR public 1 $MERGEDAYS behind


/bin/rm -f running_daily.txt

