#!/bin/bash
# Redo LET Level 1 10min data processing
#
# Sept 2007, A. Davis, Caltech

. /home/stereo/Software/procenv

cd $STEREOIDL/LETLevel1

if [ -f running_daily.txt ]; then
   echo $0: Exiting - previous instance of run_daily appears to be still running
   exit 1
fi

MERGEDAYS=75

/bin/touch running_daily.txt

for YEAR in 2006 2007 2008 2009
do
   ./run_gen_LET_10min.ksh $YEAR public 1 $MERGEDAYS ahead
   ./run_gen_LET_10min.ksh $YEAR public 1 $MERGEDAYS behind
   ./run_gen_LET_10min_summed.ksh $YEAR public 1 $MERGEDAYS ahead
   ./run_gen_LET_10min_summed.ksh $YEAR public 1 $MERGEDAYS behind
   ./run_gen_LET_10min_sectored.ksh $YEAR public 1 $MERGEDAYS ahead
   ./run_gen_LET_10min_sectored.ksh $YEAR public 1 $MERGEDAYS behind
done
/bin/rm -f running_daily.txt

