PRO READ_LET_SECTORED_MASKS, SECTOREDMASKSFILE

; open sectored rates masks file and read in all the masks
; June   1 2007, Andrew Davis, Caltech - copied from factors version

common let_l1

openr, f_unit, SECTOREDMASKSFILE, /get_lun, error = error_flag
IF (error_flag ne 0) then BEGIN
    printf, -2, !err_string
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 

tmp = ''
WHILE (tmp ne 'BEGIN') DO BEGIN
   READF, f_unit, tmp
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Sectored Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   

FOR i=0,159 DO BEGIN
   READF, f_unit,a1, a4, a5, a6, $
   	FORMAT= '(I0,D0,D0,D0)'
;   printf, -2, a1, a4, a5, a6
   IF a1 NE i THEN BEGIN
      printf,-2, 'Oops - Munged Sectored Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF EOF(f_unit) AND i LT 159 THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Sectored Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   SMasks[i].Elo = a4
   SMasks[i].Ehi = a5
   SMasks[i].mask = a6
ENDFOR


; printf,-2, 'Done reading in ', a1

free_lun, f_unit

END
