PRO READ_LET_SECTORED_FACTORS, SECTOREDFACTORSFILE

; open sectored rates factors file and read in all the factors
; May   29 2007, Andrew Davis, Caltech - sectored code move from read_let_factors.pro

common let_l1

openr, f_unit, SECTOREDFACTORSFILE, /get_lun, error = error_flag
IF (error_flag ne 0) then BEGIN
    printf, -2, !err_string
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 

tmp = ''
WHILE (tmp ne 'BEGIN') DO BEGIN
   READF, f_unit, tmp
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Sectored Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   

READF, f_unit,Sgeom, FORMAT= '(16D0)'
IF EOF(f_unit) THEN BEGIN
   printf,-2, 'READ_LET_FACTORS: Premature EOF reading Sectored Factors file...exiting'
   free_lun, f_unit
   exit, /NO_CONFIRM, STATUS=-1
ENDIF

a4 = 0.0D
a5 = 0.0D
a6 = DBLARR(4)
FOR i=0,159 DO BEGIN
   READF, f_unit,a1, a4, a5, a6, $
   	FORMAT= '(I0,D0,D0,4D0)'
;   printf, -2, a1, a4, a5, a6
   IF a1 NE i THEN BEGIN
      printf,-2, 'Oops - Munged Sectored Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF EOF(f_unit) AND i LT 159 THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Sectored Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   SFactors[i].Elo = a4
   SFactors[i].Ehi = a5
   SFactors[i].effic = a6
;   print,  SFactors[i]
ENDFOR


; printf,-2, 'Done reading in ', a1

free_lun, f_unit

END
