PRO READ_LET_MASKS, MASKSFILE

; open masks file and read in all the factors
; June 1 2007, Andrew Davis, Caltech. Copied from factors version.

common let_l1

openr, f_unit, MASKSFILE, /get_lun, error = error_flag
IF (error_flag ne 0) then BEGIN
    printf, -2, !err_string
    printf,-2, 'READ_LET_MASKS: exiting...'
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 

tmp = ''
WHILE (tmp ne 'BEGIN') DO BEGIN
   READF, f_unit, tmp
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   

a1 = 0L
a2 = 0L
a3 = 0L
a4 = 0.0D
a5 = 0.0D
a6 = 0.0D

FOR i=0,Enum[0] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 0 THEN BEGIN
      printf,-2, 'Oops - Munged masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.H_masks[i].speciesnum = a1
   Masks.H_masks[i].Z = a2
   Masks.H_masks[i].A = a3
   Masks.H_masks[i].Elo = a4	
   Masks.H_masks[i].Ehi = a5
   Masks.H_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[1] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 1 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.He3_masks[i].speciesnum = a1
   Masks.He3_masks[i].Z = a2
   Masks.He3_masks[i].A = a3
   Masks.He3_masks[i].Elo = a4	
   Masks.He3_masks[i].Ehi = a5
   Masks.He3_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[2] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 2 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.He4_masks[i].speciesnum = a1
   Masks.He4_masks[i].Z = a2
   Masks.He4_masks[i].A = a3
   Masks.He4_masks[i].Elo = a4	
   Masks.He4_masks[i].Ehi = a5
   Masks.He4_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[3] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 3 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.C_masks[i].speciesnum = a1
   Masks.C_masks[i].Z = a2
   Masks.C_masks[i].A = a3
   Masks.C_masks[i].Elo = a4	
   Masks.C_masks[i].Ehi = a5
   Masks.C_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[4] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 4 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.N_masks[i].speciesnum = a1
   Masks.N_masks[i].Z = a2
   Masks.N_masks[i].A = a3
   Masks.N_masks[i].Elo = a4	
   Masks.N_masks[i].Ehi = a5
   Masks.N_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[5] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 5 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.O_masks[i].speciesnum = a1
   Masks.O_masks[i].Z = a2
   Masks.O_masks[i].A = a3
   Masks.O_masks[i].Elo = a4	
   Masks.O_masks[i].Ehi = a5
   Masks.O_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[6] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 6 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.Ne_masks[i].speciesnum = a1
   Masks.Ne_masks[i].Z = a2
   Masks.Ne_masks[i].A = a3
   Masks.Ne_masks[i].Elo = a4	
   Masks.Ne_masks[i].Ehi = a5
   Masks.Ne_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[7] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 7 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.Na_masks[i].speciesnum = a1
   Masks.Na_masks[i].Z = a2
   Masks.Na_masks[i].A = a3
   Masks.Na_masks[i].Elo = a4	
   Masks.Na_masks[i].Ehi = a5
   Masks.Na_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[8] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 8 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.Mg_masks[i].speciesnum = a1
   Masks.Mg_masks[i].Z = a2
   Masks.Mg_masks[i].A = a3
   Masks.Mg_masks[i].Elo = a4	
   Masks.Mg_masks[i].Ehi = a5
   Masks.Mg_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[9] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 9 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.Al_masks[i].speciesnum = a1
   Masks.Al_masks[i].Z = a2
   Masks.Al_masks[i].A = a3
   Masks.Al_masks[i].Elo = a4	
   Masks.Al_masks[i].Ehi = a5
   Masks.Al_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[10] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 10 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.Si_masks[i].speciesnum = a1
   Masks.Si_masks[i].Z = a2
   Masks.Si_masks[i].A = a3
   Masks.Si_masks[i].Elo = a4	
   Masks.Si_masks[i].Ehi = a5
   Masks.Si_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[11] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 11 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.S_masks[i].speciesnum = a1
   Masks.S_masks[i].Z = a2
   Masks.S_masks[i].A = a3
   Masks.S_masks[i].Elo = a4	
   Masks.S_masks[i].Ehi = a5
   Masks.S_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[12] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 12 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.Ar_masks[i].speciesnum = a1
   Masks.Ar_masks[i].Z = a2
   Masks.Ar_masks[i].A = a3
   Masks.Ar_masks[i].Elo = a4	
   Masks.Ar_masks[i].Ehi = a5
   Masks.Ar_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[13] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 13 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.Ca_masks[i].speciesnum = a1
   Masks.Ca_masks[i].Z = a2
   Masks.Ca_masks[i].A = a3
   Masks.Ca_masks[i].Elo = a4	
   Masks.Ca_masks[i].Ehi = a5
   Masks.Ca_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[14] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 14 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.Fe_masks[i].speciesnum = a1
   Masks.Fe_masks[i].Z = a2
   Masks.Fe_masks[i].A = a3
   Masks.Fe_masks[i].Elo = a4	
   Masks.Fe_masks[i].Ehi = a5
   Masks.Fe_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[15] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 15 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.Ni_masks[i].speciesnum = a1
   Masks.Ni_masks[i].Z = a2
   Masks.Ni_masks[i].A = a3
   Masks.Ni_masks[i].Elo = a4	
   Masks.Ni_masks[i].Ehi = a5
   Masks.Ni_masks[i].mask = a6	
ENDFOR
; printf,-2, 'Done reading in ', a1

; He elemental - same number of bins as He3
FOR i=0,Enum[1] -1 DO BEGIN
;   print, "Got here...", masksfile, i
   READF, f_unit,a1,a2,a3,a4,a5,a6, FORMAT= '(I0,I0,I0,D0,D0,D0)'
   IF EOF(f_unit) AND i LT Enum[1] -1 THEN BEGIN
      printf,-2, 'READ_LET_MASKS: Premature EOF reading Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 16 THEN BEGIN
      printf,-2, 'Oops - Munged Masks file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Masks.He_masks[i].speciesnum = a1
   Masks.He_masks[i].Z = a2
   Masks.He_masks[i].A = a3
   Masks.He_masks[i].Elo = a4	
   Masks.He_masks[i].Ehi = a5
   Masks.He_masks[i].mask = a6
;   print, Masks.He_masks[i]
ENDFOR
; printf,-2, 'Done reading in ', a1

free_lun, f_unit

END
