PRO READ_LET_L1_CALDB

; open LET Level 1 caldb files for ahead and behind, read in database info
; May 29 2007, Andrew Davis, Caltech. Copied from SEP Beacon software version, with minor edits
; 	and addition of code for sectored caldb
common let_l1

openr, Aunit, LETL1CALDB_A, /get_lun, error = error_flag
IF (error_flag ne 0) then BEGIN
    printf, -2, !err_string
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 

openr, Bunit, LETL1CALDB_B, /get_lun, error = error_flag
IF (error_flag ne 0) then BEGIN
    printf, -2, !err_string
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 

openr, Asec_unit, LETL1SECCALDB_A, /get_lun, error = error_flag
IF (error_flag ne 0) then BEGIN
    printf, -2, !err_string
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 

openr, Bsec_unit, LETL1SECCALDB_B, /get_lun, error = error_flag
IF (error_flag ne 0) then BEGIN
    printf, -2, !err_string
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 

tmp=''
WHILE (tmp ne 'BEGIN') DO BEGIN
   READF, Aunit, tmp
   IF EOF(Aunit) THEN BEGIN
      printf,-2, 'Premature EOF reading LET Ahead caldb...exiting'
      free_lun, Aunit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   

tmp=''
WHILE (tmp ne 'BEGIN') DO BEGIN
   READF, Bunit, tmp
   IF EOF(Bunit) THEN BEGIN
      printf,-2, 'Premature EOF reading LET Behind caldb...exiting'
      free_lun, Bunit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   

tmp=''
WHILE (tmp ne 'BEGIN') DO BEGIN
   READF, Asec_unit, tmp
   IF EOF(Asec_unit) THEN BEGIN
      printf,-2, 'Premature EOF reading LET Ahead sectored caldb...exiting'
      free_lun, Asec_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   

tmp=''
WHILE (tmp ne 'BEGIN') DO BEGIN
   READF, Bsec_unit, tmp
   IF EOF(Bsec_unit) THEN BEGIN
      printf,-2, 'Premature EOF reading LET Behind sectored caldb...exiting'
      free_lun, Bsec_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   

ii=0
timestr = ''
filenm = ''
WHILE (ii lt MAXCALDB) DO BEGIN
   READF, Aunit,timestr,filenm, FORMAT= '(A23,1X,A32)'
;   print, timestr, '   ',  filenm
   IF (EOF(Aunit) or (timestr eq 'ENDENDENDENDENDENDENDEN')) THEN BEGIN
;      IF (timestr eq 'ENDENDENDENDENDENDENDEN') THEN print, 'Found END'
      BREAK
   ENDIF
   timeutc = str2utc(timestr)
   caltimes_a[ii] = utc2tai(timeutc, /NOCORRECT)
   calfnames_a[ii] = filenm
   ii = ii + 1
ENDWHILE
IF (ii eq MAXCALDB) then BEGIN
    printf, -2, 'ERROR - Too many entries in LET Ahead caldb. Max = ', MAXCALDB
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 
caln_a = ii

ii=0
timestr = ''
filenm = ''
WHILE (ii lt MAXCALDB) DO BEGIN
   READF, Bunit,timestr,filenm, FORMAT= '(A23,1X,A33)'
;   print, timestr, '   ',  filenm
   IF (EOF(Bunit) or (timestr eq 'ENDENDENDENDENDENDENDEN')) THEN BEGIN
      BREAK
   ENDIF
   timeutc = str2utc(timestr)
   caltimes_b[ii] = utc2tai(timeutc, /NOCORRECT)
   calfnames_b[ii] = filenm
   ii = ii + 1
ENDWHILE
IF (ii eq MAXCALDB) then BEGIN
    printf, -2, 'ERROR - Too many entries in LET Behind caldb. Max = ', MAXCALDB
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 
caln_b = ii

ii=0
timestr = ''
filenm = ''
WHILE (ii lt MAXCALDB) DO BEGIN
   READF, Asec_unit,timestr,filenm, FORMAT= '(A23,1X,A41)'
;   print, timestr, '   ',  filenm
   IF (EOF(Asec_unit) or (timestr eq 'ENDENDENDENDENDENDENDEN')) THEN BEGIN
;      IF (timestr eq 'ENDENDENDENDENDENDENDEN') THEN print, 'Found END'
      BREAK
   ENDIF
   timeutc = str2utc(timestr)
   sec_caltimes_a[ii] = utc2tai(timeutc, /NOCORRECT)
   sec_calfnames_a[ii] = filenm
   ii = ii + 1
ENDWHILE
IF (ii eq MAXCALDB) then BEGIN
    printf, -2, 'ERROR - Too many entries in LET Ahead sectored caldb. Max = ', MAXCALDB
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 
sec_caln_a = ii

ii=0
timestr = ''
filenm = ''
WHILE (ii lt MAXCALDB) DO BEGIN
   READF, Bsec_unit,timestr,filenm, FORMAT= '(A23,1X,A42)'
;   print, timestr, '   ',  filenm
   IF (EOF(Bsec_unit) or (timestr eq 'ENDENDENDENDENDENDENDEN')) THEN BEGIN
      BREAK
   ENDIF
   timeutc = str2utc(timestr)
   sec_caltimes_b[ii] = utc2tai(timeutc, /NOCORRECT)
   sec_calfnames_b[ii] = filenm
   ii = ii + 1
ENDWHILE
IF (ii eq MAXCALDB) then BEGIN
    printf, -2, 'ERROR - Too many entries in LET Behind sectored caldb. Max = ', MAXCALDB
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 
sec_caln_b = ii

free_lun, Aunit, Bunit, Asec_unit, Bsec_unit

END
