PRO READ_LET_FACTORS, FACTORSFILE

; open factors file and read in all the factors
; April 18 2005, Andrew Davis, Caltech
; Sept  26 2005, Andrew Davis, Caltech - added sectored rates
; May   29 2007, Andrew Davis, Caltech - moved sectored rates to separate file
common let_l1

openr, f_unit, FACTORSFILE, /get_lun, error = error_flag
IF (error_flag ne 0) then BEGIN
    printf, -2, !err_string
    printf,-2, 'READ_LET_FACTORS: exiting...'
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 

tmp = ''
WHILE (tmp ne 'BEGIN') DO BEGIN
   READF, f_unit, tmp
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   

a1 = 0L
a2 = 0L
a3 = 0L
a4 = 0D
a5 = 0D
a6 = DINDGEN(4)
a7 = DINDGEN(4)

FOR i=0,Enum[0] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 0 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.H_fctrs[i].speciesnum = a1
   Factors.H_fctrs[i].Z = a2
   Factors.H_fctrs[i].A = a3
   Factors.H_fctrs[i].Elo = a4	
   Factors.H_fctrs[i].Ehi = a5
   Factors.H_fctrs[i].geom = a6	
   Factors.H_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[1] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 1 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.He3_fctrs[i].speciesnum = a1
   Factors.He3_fctrs[i].Z = a2
   Factors.He3_fctrs[i].A = a3
   Factors.He3_fctrs[i].Elo = a4	
   Factors.He3_fctrs[i].Ehi = a5
   Factors.He3_fctrs[i].geom = a6	
   Factors.He3_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[2] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 2 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.He4_fctrs[i].speciesnum = a1
   Factors.He4_fctrs[i].Z = a2
   Factors.He4_fctrs[i].A = a3
   Factors.He4_fctrs[i].Elo = a4	
   Factors.He4_fctrs[i].Ehi = a5
   Factors.He4_fctrs[i].geom = a6	
   Factors.He4_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[3] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 3 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.C_fctrs[i].speciesnum = a1
   Factors.C_fctrs[i].Z = a2
   Factors.C_fctrs[i].A = a3
   Factors.C_fctrs[i].Elo = a4	
   Factors.C_fctrs[i].Ehi = a5
   Factors.C_fctrs[i].geom = a6	
   Factors.C_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[4] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 4 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.N_fctrs[i].speciesnum = a1
   Factors.N_fctrs[i].Z = a2
   Factors.N_fctrs[i].A = a3
   Factors.N_fctrs[i].Elo = a4	
   Factors.N_fctrs[i].Ehi = a5
   Factors.N_fctrs[i].geom = a6	
   Factors.N_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[5] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 5 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.O_fctrs[i].speciesnum = a1
   Factors.O_fctrs[i].Z = a2
   Factors.O_fctrs[i].A = a3
   Factors.O_fctrs[i].Elo = a4	
   Factors.O_fctrs[i].Ehi = a5
   Factors.O_fctrs[i].geom = a6	
   Factors.O_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[6] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 6 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.Ne_fctrs[i].speciesnum = a1
   Factors.Ne_fctrs[i].Z = a2
   Factors.Ne_fctrs[i].A = a3
   Factors.Ne_fctrs[i].Elo = a4	
   Factors.Ne_fctrs[i].Ehi = a5
   Factors.Ne_fctrs[i].geom = a6	
   Factors.Ne_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[7] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 7 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.Na_fctrs[i].speciesnum = a1
   Factors.Na_fctrs[i].Z = a2
   Factors.Na_fctrs[i].A = a3
   Factors.Na_fctrs[i].Elo = a4	
   Factors.Na_fctrs[i].Ehi = a5
   Factors.Na_fctrs[i].geom = a6	
   Factors.Na_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[8] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 8 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.Mg_fctrs[i].speciesnum = a1
   Factors.Mg_fctrs[i].Z = a2
   Factors.Mg_fctrs[i].A = a3
   Factors.Mg_fctrs[i].Elo = a4	
   Factors.Mg_fctrs[i].Ehi = a5
   Factors.Mg_fctrs[i].geom = a6	
   Factors.Mg_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[9] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 9 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.Al_fctrs[i].speciesnum = a1
   Factors.Al_fctrs[i].Z = a2
   Factors.Al_fctrs[i].A = a3
   Factors.Al_fctrs[i].Elo = a4	
   Factors.Al_fctrs[i].Ehi = a5
   Factors.Al_fctrs[i].geom = a6	
   Factors.Al_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[10] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 10 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.Si_fctrs[i].speciesnum = a1
   Factors.Si_fctrs[i].Z = a2
   Factors.Si_fctrs[i].A = a3
   Factors.Si_fctrs[i].Elo = a4	
   Factors.Si_fctrs[i].Ehi = a5
   Factors.Si_fctrs[i].geom = a6	
   Factors.Si_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[11] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 11 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.S_fctrs[i].speciesnum = a1
   Factors.S_fctrs[i].Z = a2
   Factors.S_fctrs[i].A = a3
   Factors.S_fctrs[i].Elo = a4	
   Factors.S_fctrs[i].Ehi = a5
   Factors.S_fctrs[i].geom = a6	
   Factors.S_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[12] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 12 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.Ar_fctrs[i].speciesnum = a1
   Factors.Ar_fctrs[i].Z = a2
   Factors.Ar_fctrs[i].A = a3
   Factors.Ar_fctrs[i].Elo = a4	
   Factors.Ar_fctrs[i].Ehi = a5
   Factors.Ar_fctrs[i].geom = a6	
   Factors.Ar_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[13] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 13 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.Ca_fctrs[i].speciesnum = a1
   Factors.Ca_fctrs[i].Z = a2
   Factors.Ca_fctrs[i].A = a3
   Factors.Ca_fctrs[i].Elo = a4	
   Factors.Ca_fctrs[i].Ehi = a5
   Factors.Ca_fctrs[i].geom = a6	
   Factors.Ca_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[14] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 14 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.Fe_fctrs[i].speciesnum = a1
   Factors.Fe_fctrs[i].Z = a2
   Factors.Fe_fctrs[i].A = a3
   Factors.Fe_fctrs[i].Elo = a4	
   Factors.Fe_fctrs[i].Ehi = a5
   Factors.Fe_fctrs[i].geom = a6	
   Factors.Fe_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1
FOR i=0,Enum[15] -1 DO BEGIN
   READF, f_unit,a1,a2,a3,a4,a5,a6,a7, FORMAT= '(I0,I0,I0,D0,D0,4D0,4D0)'
   IF EOF(f_unit) AND i LT Enum[15] -1 THEN BEGIN
      printf,-2, 'READ_LET_FACTORS: Premature EOF reading Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   IF a1 NE 15 THEN BEGIN
      printf,-2, 'Oops - Munged Factors file...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.Ni_fctrs[i].speciesnum = a1
   Factors.Ni_fctrs[i].Z = a2
   Factors.Ni_fctrs[i].A = a3
   Factors.Ni_fctrs[i].Elo = a4	
   Factors.Ni_fctrs[i].Ehi = a5
   Factors.Ni_fctrs[i].geom = a6	
   Factors.Ni_fctrs[i].effic = a7	
ENDFOR
; printf,-2, 'Done reading in ', a1

free_lun, f_unit

END
