#!/bin/bash

if [ ! -d /home/stereo/Software/idl/LETLevel1/plots ]; then
   echo LET Level 1 plot directory does not exist
   exit
fi

cd /home/stereo/Software/idl/LETLevel1/plots

read YEAR MONTH < <( ./month_prev_month.pl 0 )
MONTH=$((10#$MONTH+0))
read PYEAR PMONTH < <( ./month_prev_month.pl 1 )
PMONTH=$((10#$PMONTH+0))

# echo $YEAR $MONTH
# echo $PYEAR $PMONTH

/bin/rm -f *.ps

./monthly_plot_driver.bash $PYEAR $PMONTH ahead private
./monthly_plot_driver.bash $PYEAR $PMONTH behind private
sleep 2
./mk_monthly_plot_pdfs $PYEAR $PMONTH private
sleep 2
/bin/rm -f *.ps

./monthly_plot_driver.bash $YEAR $MONTH ahead private
./monthly_plot_driver.bash $YEAR $MONTH behind private
sleep 2
./mk_monthly_plot_pdfs $YEAR $MONTH private
sleep 2
/bin/rm -f *.ps

# only produce public plots for the most recently released month, plus one previous
read YEAR DOY MONTH DOM < <( ./getpubprocym.pl < PublicProcDates.txt )
./monthly_plot_driver.bash $YEAR $MONTH ahead public
./monthly_plot_driver.bash $YEAR $MONTH behind public
sleep 2
./mk_monthly_plot_pdfs $YEAR $MONTH public
sleep 2
/bin/rm -f *.ps

read YEAR DOY MONTH DOM < <( ./getprevpubprocym.pl < PublicProcDates.txt )
./monthly_plot_driver.bash $YEAR $MONTH ahead public
./monthly_plot_driver.bash $YEAR $MONTH behind public
sleep 2
./mk_monthly_plot_pdfs $YEAR $MONTH public
sleep 2
/bin/rm -f *.ps

