#!/usr/local/bin/perl -w
#
# Return the doy of the start-day and end-day
# of the given year/month.
# Also returns name of the month.
#
# June 25, 2007, Andrew Davis, Caltech SRL.
#
use Date::EzDate;

my ($year,$month) = @ARGV;

my $startdate = Date::EzDate->new('12pm');
$startdate->set_warnings(0);
$startdate->{'year'} = $year;
$startdate->{'month number base 1'} = $month;
$startdate->{'day of month'} = 1;


my $enddate = $startdate->clone();
$enddate->set_warnings(0);
$enddate->{'month number base 1'} = 1;
$enddate->{'day of month'} = 31;			# January 31st
$enddate->{'month number base 1'} = $month;	# sets to last day of required month

# return days-of-year without leading zeros
printf("%3d %3d %s\n",$startdate->{'day of year base 1'},
		$enddate->{'day of year base 1'},
		$enddate->{'month long'});

