#!/usr/local/bin/perl -w
#
# Return the Bartels rotation for given year, month, day-of-month
#
# A. Davis, Caltech, June 2007

use Date::EzDate;

  my ($year, $month, $day) =  @ARGV;

  my $today = Date::EzDate->new('12 pm');
  $today->set_warnings(0);
  $today->{'year'} = $year;
  $today->{'month number base 1'} = $month;
  $today->{'day of month'} = $day;
#  print "$today\n";

  my $bart2394 = $today->clone();
  $bart2394->{'full'} = '12:00:00 pm, January 1, 2009';
#  print "$bart2394\n";
  
  my $diff = $bart2394->{'epoch day'} - $today->{'epoch day'};

#  print "$diff\n";

  if ($diff > 1) {
     $diff--;
  }

  my $nbart = int $diff/27;

  my $pbart = 2394 - $nbart; 

  if ($diff > 0) {
     $pbart--;
  }
  print "$pbart\n";

  exit(0);
