#!/bin/bash
. /home/stereo/Software/procenv

BART=$1
SC=$2
PUBPRI=$3

read SYEAR SDOY EYEAR EDOY < <( ./yyyydddfmbartels.pl $BART )

if [ $PUBPRI != "public" -a $PUBPRI != "private" ]; then
   echo Usage: $0 BART SC pubpri, where pubpri is public or private
   exit 1
fi

# Don't look for BEHIND data past 2014
NOB=0
if [ $SC == "behind" -a $BART -ge 2476 ]; then
   NOB=1
fi

if [ "$ARCH" == "Linux" ]; then
   SIS_L2_BARTELS_RD=./sis_l2_bartels_rd_linux
else
   SIS_L2_BARTELS_RD=./sis_l2_bartels_rd
fi

DATE=`date`

if [ $PUBPRI == "public" ]; then
   WEBDIR=$WEBPLOTS/Level1/Public/Bartels/$SC/$BART
   SRCDIR=$LETL1PUBDATAHOME/$SC/
   export LEGEND="Public Level 1 Data. $DATE"
else
   WEBDIR=$WEBPLOTS/Level1/SRLonly/Bartels/$SC/$BART
   SRCDIR=$LETL1SRLONLYDATAHOME/$SC/
   export LEGEND="SRL-only Data - do not distribute. $DATE"
fi

if [ ! -d $WEBDIR ]; then
   mkdir -p $WEBDIR
fi

# LET Level 1 data Version number
L1VERSIONSTR=`$GAWK '($1=="VERSION"){print $3; exit}' $STEREOIDL/LETLevel1/let_l1_common.pro`
L1VERSION=`expr "$L1VERSIONSTR" : '\([0-9]*\)'`
if [ $L1VERSION -lt 10 ]; then L1VERSION=0$L1VERSION; fi
# L1VERSION=08
export L1VERSION

cd $STEREOIDL/LETLevel1/plots

export XMIN=1
export XMAX=100

export TITLE="LET $SC. ${SYEAR}-${SDOY} thru ${EYEAR}-${EDOY}, bartels rot $BART"
export XLABEL="Energy (MeV/n)"
export UNITS="1/(cm\\sp2\\ep s sr MeV/n)"

# Generic function to prepare the data, average the data, call the plotting routine, convert plots to jpg
# SPECIES SPECIESLONG YMIN YMAX must all be set 
function doallthework {
   export SRCNARROW=${SPECIES}_narrow.dat
   export SRCSUMMED=${SPECIES}_summed.dat
   PLOTFILE=let_${SC}_${BART}_${SPECIES}_spect
   /bin/rm -f $SRCSUMMED $SRCNARROW tmp.dat tmp2.dat
   touch tmp.dat tmp2.dat
   for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
      SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/${SPECIES}_summed_${SC}_${yr}_1hr_level1_*.txt 2> /dev/null | tail -1`
      if [ !  $SRCFILE ]; then
         if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
            echo $0: $SRCFILE does not exist...exiting
            exit 1
         fi
      else
         $BEHEAD $SRCFILE >> tmp.dat
      fi
      SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Standard/${SPECIES}_${SC}_${yr}_1hr_level1_*.txt 2> /dev/null | tail -1`      
      if [ !  $SRCFILE ]; then
         if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
            echo $0: $SRCFILE does not exist...exiting
            exit 1
         fi
      else
         $BEHEAD $SRCFILE >> tmp2.dat
      fi
   done

   ./average_fluxes.bash $SPECIES $SYEAR $SDOY $EYEAR $EDOY ebins_summed.txt tmp.dat $SRCSUMMED
   if [ $? -ne 0 ]; then
      echo $0: ERROR: bad exit status from average_fluxes.bash summed
      exit 1
   fi
   ./average_fluxes.bash $SPECIES $SYEAR $SDOY $EYEAR $EDOY ebins_narrow.txt tmp2.dat $SRCNARROW
   if [ $? -ne 0 ]; then
      echo $0: ERROR: bad exit status from average_fluxes.bash narrow
      exit 1
   fi

   if [ $PUBPRI == "public" ]; then
      ./gen_bartels_spectra_public.bash $SRCSUMMED $SRCNARROW > ${PLOTFILE}.dat
   else
      # Set some flags so the spectra-plotting
      # code can plot different symbols if the point is masked-off in the public data.
      # 1. Figure out which masks file to use (SC and date)
      # 2. For each record in $SRCNARROW Figure out which record in masks file (species , emin, emax)
      # 3. Add flag to each record in $SRCNARROW
      ./check_masks.bash $SRCNARROW $SC $SYEAR $SDOY $SPECIES 
      if [ $? -ne 0 ]; then
         echo $0: ERROR: bad exit status from check_masks.bash $SRCNARROW $SC $SYEAR $SDOY $SPECIES
         exit 1
      fi
      ./gen_bartels_spectra_private.bash $SRCSUMMED ${SRCNARROW}_masked > ${PLOTFILE}.dat
   fi   
   cat ${PLOTFILE}.dat | $PLOT2PST -p 1 > ${PLOTFILE}.ps
   $CONVERT -density 400 -quality 90 -trim -page letter ${PLOTFILE}.ps xxx.jpg
   $CONVERT -quality 90 -resize 550x xxx.jpg $WEBDIR/${PLOTFILE}.jpg
   $CONVERT $WEBDIR/${PLOTFILE}.jpg -resize 241x -quality 95 $WEBDIR/${PLOTFILE}_small.jpg
   /bin/rm -f ${PLOTFILE}.dat
   # /bin/rm -f ${PLOTFILE}.ps 
   /bin/rm -f $SRCSUMMED $SRCNARROW
}

function getsisdata {
   /bin/rm -f tmp3.dat tmp4.dat SIS_${SPECIES}.dat
   SDOYDEC=$((10#$SDOY+0))
   $SIS_L2_BARTELS_RD /home/mussel5/level2/sis/sis_data_Bartels.hdf $SPECIES | \
   	$GAWK '($1=='$SYEAR')&&($2=='$SDOYDEC'){
           for (i=0;i<8;i++) print $(i+3),$(i+11); 
	}' > tmp3.dat
   if [ -s tmp3.dat ]; then
      $GAWK 'BEGIN{species="'$SPECIESLONG'"; Go=0; range=0}{
         if (Go) {print $4; range++} if (range==8) exit; if ($1==species) Go=1
      }' sis_level2_table.txt > tmp4.dat
      $COMBINE tmp4.dat tmp3.dat | \
         $GAWK '{e=$1; i=$2; if ($3>0) u=i/sqrt($3); else u=0; print e,i,u}' > SIS_${SPECIES}.dat
   fi
}

# Protons
export SPECIES=H
export SPECIESLONG=Protons
export YMIN=1E-6
export YMAX=1E+5
doallthework

# 3He
export SPECIES=He3
export SPECIESLONG=He3
export YMIN=1E-8
export YMAX=1E+2
doallthework

# 4He
export SPECIES=He4
export SPECIESLONG=He4
export YMIN=1E-7
export YMAX=1E+3
doallthework

# Helium
export SPECIES=He
export SPECIESLONG=Helium
export YMIN=1E-7
export YMAX=1E+3
getsisdata
doallthework

# C
export SPECIES=C
export SPECIESLONG=Carbon
export YMIN=1E-9
export YMAX=1E+1
getsisdata
doallthework

# N
export SPECIES=N
export SPECIESLONG=Nitrogen
export YMIN=1E-9
export YMAX=1E+1
getsisdata
doallthework

# O
export SPECIES=O
export SPECIESLONG=Oxygen
export YMIN=1E-9
export YMAX=1E+1
getsisdata
doallthework

# Ne
export SPECIES=Ne
export SPECIESLONG=Neon
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

# Na
export SPECIES=Na
export SPECIESLONG=Sodium
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

# Mg
export SPECIES=Mg
export SPECIESLONG=Magnesium
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

# Al
export SPECIES=Al
export SPECIESLONG=Aluminum
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

# Si
export SPECIES=Si
export SPECIESLONG=Silicon
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

# S
export SPECIES=S
export SPECIESLONG=Sulfur
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

# Ar
export SPECIES=Ar
export SPECIESLONG=Argon
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

# Ca
export SPECIES=Ca
export SPECIESLONG=Calcium
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

# Fe
export SPECIES=Fe
export SPECIESLONG=Iron
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

# Ni
export SPECIES=Ni
export SPECIESLONG=Nickel
export YMIN=1E-10
export YMAX=1E+0
getsisdata
doallthework

