#!/bin/bash

if [ ! -d /home/stereo/Software/idl/LETLevel1/plots ]; then
   echo LET Level 1 plot directory does not exist
   exit
fi

cd /home/stereo/Software/idl/LETLevel1/plots

YEAR=`date +%Y`
MONTH=`date +%m`
DAY=`date +%d`

read curr_bart < <( ./bartelsfmymd.pl $YEAR $MONTH $DAY )

/bin/rm -f *.ps

for (( bart=curr_bart-2; bart <= curr_bart; bart++ )); do
      # echo $bart
      ./bartels_plot_driver.bash $bart ahead private
      ./bartels_plot_driver.bash $bart behind private
      sleep 2
      ./mk_bartels_plot_pdfs $bart private
      sleep 2
      /bin/rm -f *.ps

      ./bartels_spectra_driver.bash $bart ahead private
      ./bartels_spectra_driver.bash $bart behind private
      sleep 2
      ./mk_bartels_spectra_pdfs $bart private
      sleep 2
      /bin/rm -f *.ps
done

# Produce NO 27-day spectra plots for public data

# only produce public 27-day spectra plots for the bartels rotations
# prior to the last public data release date
read YEAR DOY MONTH DAY < <( ./getpubprocym.pl < PublicProcDates.txt )
read curr_bart < <( ./bartelsfmymd.pl $YEAR $MONTH $DAY )

#bart=$(( $curr_bart - 1 ))
#./bartels_spectra_driver.bash $bart ahead public
#./bartels_spectra_driver.bash $bart behind public
#sleep 2
#./mk_bartels_spectra_pdfs $bart public
#sleep 2
#/bin/rm -f *.ps
#bart=$(( $curr_bart - 2 ))
#./bartels_spectra_driver.bash $bart ahead public
#./bartels_spectra_driver.bash $bart behind public
#sleep 2
#./mk_bartels_spectra_pdfs $bart public
#sleep 2
#/bin/rm -f *.ps

# If near end-of-year, then curr_bart will extend into the next year,
# for which no directories/files yet exist
if [ $DOY -gt 338 ]; then
   curr_bart=$(( $curr_bart - 1 ))   
fi

# make 27-day time-series plots up to the last public release date
for (( bart=curr_bart-2; bart <= curr_bart; bart++ )); do
      # echo $bart
      ./bartels_plot_driver.bash $bart ahead public
      ./bartels_plot_driver.bash $bart behind public
      sleep 2
      ./mk_bartels_plot_pdfs $bart public
      sleep 2
      /bin/rm -f *.ps
done
