#!/usr/local/bin/bash

if [ ! -d /home/stereo/Software/idl/LETLevel1/plots ]; then
   echo LET Level 1 plot directory does not exist
   exit
fi

cd /home/stereo/Software/idl/LETLevel1/plots

YEAR=`date +%Y`

read YEAR MONTH < <( ./month_prev_month.pl 0 )
MONTH=$((10#$MONTH+0))

# echo $YEAR $MONTH

/bin/rm -f *.ps

for (( yr=2006; yr <= YEAR; yr++ )); do
   smonth=1
   emonth=12
   if [ $yr -eq 2006 ]; then smonth=11; fi
   if [ $yr -eq $YEAR ]; then emonth=$MONTH; fi
   # echo $smonth $emonth
   for (( mo=smonth; mo <= emonth; mo++ )); do
      ./monthly_plot_driver.bash $yr $mo ahead private
      ./monthly_plot_driver.bash $yr $mo behind private
      sleep 2
      ./mk_monthly_plot_pdfs $yr $mo private
      sleep 2
      /bin/rm -f *.ps

      ./monthly_plot_driver.bash $yr $mo ahead public
      ./monthly_plot_driver.bash $yr $mo behind public
      sleep 2
      ./mk_monthly_plot_pdfs $yr $mo public
      sleep 2
      /bin/rm -f *.ps

   done
done
