#!/usr/local/bin/bash

if [ ! -d /home/stereo/Software/idl/LETLevel1/plots ]; then
   echo LET Level 1 plot directory does not exist
   exit
fi

cd /home/stereo/Software/idl/LETLevel1/plots

YEAR=`date +%Y`
MONTH=`date +%m`
DAY=`date +%d`

read curr_bart < <( ./bartelsfmymd.pl $YEAR $MONTH $DAY )

# echo $BART

/bin/rm -f *.ps

for (( bart=2365; bart <= curr_bart; bart++ )); do

      ./bartels_spectra_driver.bash $bart ahead private
      ./bartels_spectra_driver.bash $bart behind private
      sleep 2
      ./mk_bartels_spectra_pdfs $bart private
      sleep 2
      /bin/rm -f *.ps

      ./bartels_spectra_driver.bash $bart ahead public
      ./bartels_spectra_driver.bash $bart behind public
      sleep 2
      ./mk_bartels_spectra_pdfs $bart public
      sleep 2
      /bin/rm -f *.ps

done
