#!/usr/local/bin/bash
. /home/stereo/Software/procenv

YEAR=$1
MONTH=$2
SC=$3
PUBPRI=$4

read XMIN XMAX MONTHNAME < <( ./monthdays.pl $YEAR $MONTH )
INTXMAX=$XMAX
XMAX=${XMAX}.99999

if [ $PUBPRI != "public" -a $PUBPRI != "private" ]; then
   echo Usage: $0 BART SC pubpri, where pubpri is public or private
   exit 1
fi

# Don't look for BEHIND data past 2014
NOB=0
if [ $SC == "behind" -a $YEAR -ge 2015 ]; then
   NOB=1
fi

DATE=`date`

if [ $PUBPRI == "public" ]; then
   WEBDIR=$WEBPLOTS/Level1/Public/Monthly/$SC/$YEAR/$MONTHNAME
   SRCDIR=$LETL1PUBDATAHOME/$SC/Hourly/$YEAR/Summed
   export NOTE="Public Level 1 Data. $DATE"
else
   WEBDIR=$WEBPLOTS/Level1/SRLonly/Monthly/$SC/$YEAR/$MONTHNAME
   SRCDIR=$LETL1SRLONLYDATAHOME/$SC/Hourly/$YEAR/Summed
   export NOTE="SRL-only Data - do not distribute. $DATE"
fi

if [ ! -d $WEBDIR ]; then
   mkdir -p $WEBDIR
fi


# LET Level 1 data Version number
L1VERSIONSTR=`awk '($1=="VERSION"){print $3; exit}' $STEREOIDL/LETLevel1/let_l1_common.pro`
L1VERSION=`expr "$L1VERSIONSTR" : '\([0-9]*\)'`
if [ $L1VERSION -lt 10 ]; then L1VERSION=0$L1VERSION; fi
export L1VERSION

cd $STEREOIDL/LETLevel1/plots


export LEGEND1="1.8-3.6 MeV/n"
export LEGEND2="4-6"
export LEGEND3="6-10"
export LEGEND4="10-15"
export LEGEND5="15-27"
export LEGEND6="27-40"

export YEAR
export MONTHNAME
export XMIN
export XMAX
export INTXMAX
export XSTEP=5

export NPANELS=4
export TITLE="STEREO LET $SC Hourly Averages - $MONTHNAME $YEAR"
export XLABEL="Day of Year $YEAR"


# Plot1
PLOTFILE=let_${SC}_${YEAR}_${MONTHNAME}_1

# Protons
SRCFILE=`/bin/ls $SRCDIR/H_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Protons SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESA=Protons
export SRCA=${SPECIESA}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 > $SRCA

export YMINA=1E-5
export YMAXA=1E+6
export UNITSA="1/(cm\\sp2\\ep s sr MeV)"
export NTRACEA=4
export IDXA=1	# indicates the lowest summed energy range for the species

# 4He
SRCFILE=`/bin/ls $SRCDIR/He4_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: 4He SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESB=4He
export SRCB=${SPECIESB}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 > $SRCB

export YMINB=1E-5
export YMAXB=1E+6
export UNITSB="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEB=4
export IDXB=1	# indicates the lowest summed energy range for the species

# He
SRCFILE=`/bin/ls $SRCDIR/He_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: He SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESC=Helium
export SRCC=${SPECIESC}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 > $SRCC

export YMINC=1E-5
export YMAXC=1E+6
export UNITSC="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEC=3
export IDXC=2	# indicates the lowest summed energy range for the species

# C
SRCFILE=`/bin/ls $SRCDIR/C_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: C SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESD=Carbon
export SRCD=${SPECIESD}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 > $SRCD

export YMIND=1E-6
export YMAXD=1E+4
export UNITSD="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACED=4
export IDXD=2	# indicates the lowest summed energy range for the species

./gen_monthly_plot.bash > ${PLOTFILE}.dat
cat ${PLOTFILE}.dat | $PLOT2PST -p 1 > ${PLOTFILE}.ps
$CONVERT -quality 90 -trim -page letter ${PLOTFILE}.ps $WEBDIR/${PLOTFILE}.jpg
$CONVERT $WEBDIR/${PLOTFILE}.jpg -resize 241x -quality 95 $WEBDIR/${PLOTFILE}_small.jpg
rm ${PLOTFILE}.dat ${SPECIESA}.dat ${SPECIESB}.dat ${SPECIESC}.dat ${SPECIESD}.dat



# Plot2
PLOTFILE=let_${SC}_${YEAR}_${MONTHNAME}_2

# Nitrogen
SRCFILE=`/bin/ls $SRCDIR/N_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: N SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESA=Nitrogen
export SRCA=${SPECIESA}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 > $SRCA

export YMINA=1E-6
export YMAXA=1E+4
export UNITSA="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEA=4
export IDXA=2	# indicates the lowest summed energy range for the species

# Oxygen
SRCFILE=`/bin/ls $SRCDIR/O_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: O SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESB=Oxygen
export SRCB=${SPECIESB}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 > $SRCB

export YMINB=1E-6
export YMAXB=1E+4
export UNITSB="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEB=4
export IDXB=2	# indicates the lowest summed energy range for the species

# Neon
SRCFILE=`/bin/ls $SRCDIR/Ne_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Ne SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESC=Neon
export SRCC=${SPECIESC}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 > $SRCC

export YMINC=1E-6
export YMAXC=1E+4
export UNITSC="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEC=4
export IDXC=2	# indicates the lowest summed energy range for the species

# Na
SRCFILE=`/bin/ls $SRCDIR/Na_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Na SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESD=Sodium
export SRCD=${SPECIESD}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 > $SRCD

export YMIND=1E-6
export YMAXD=1E+4
export UNITSD="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACED=2
export IDXD=4	# indicates the lowest summed energy range for the species

./gen_monthly_plot.bash > ${PLOTFILE}.dat
cat ${PLOTFILE}.dat | $PLOT2PST -p 1 > ${PLOTFILE}.ps
$CONVERT -quality 90 -trim -page letter ${PLOTFILE}.ps $WEBDIR/${PLOTFILE}.jpg
$CONVERT $WEBDIR/${PLOTFILE}.jpg -resize 241x -quality 95 $WEBDIR/${PLOTFILE}_small.jpg
rm ${PLOTFILE}.dat ${SPECIESA}.dat ${SPECIESB}.dat ${SPECIESC}.dat ${SPECIESD}.dat


# Plot3
PLOTFILE=let_${SC}_${YEAR}_${MONTHNAME}_3

# Magnesium
SRCFILE=`/bin/ls $SRCDIR/Mg_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Mg SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESA=Magnesium
export SRCA=${SPECIESA}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 > $SRCA

export YMINA=1E-6
export YMAXA=1E+2
export UNITSA="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEA=4
export IDXA=2	# indicates the lowest summed energy range for the species

# Aluminum
SRCFILE=`/bin/ls $SRCDIR/Al_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Al SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESB=Aluminum
export SRCB=${SPECIESB}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 > $SRCB

export YMINB=1E-6
export YMAXB=1E+2
export UNITSB="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEB=3
export IDXB=3	# indicates the lowest summed energy range for the species

# Silicon
SRCFILE=`/bin/ls $SRCDIR/Si_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Si SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESC=Silicon
export SRCC=${SPECIESC}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 11 > $SRCC

export YMINC=1E-6
export YMAXC=1E+2
export UNITSC="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEC=5
export IDXC=2	# indicates the lowest summed energy range for the species

# Sulfur
SRCFILE=`/bin/ls $SRCDIR/S_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: S SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESD=Sulfur
export SRCD=${SPECIESD}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 11 > $SRCD

export YMIND=1E-6
export YMAXD=1E+4
export UNITSD="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACED=5
export IDXD=2	# indicates the lowest summed energy range for the species

./gen_monthly_plot.bash > ${PLOTFILE}.dat
cat ${PLOTFILE}.dat | $PLOT2PST -p 1 > ${PLOTFILE}.ps
$CONVERT -quality 90 -trim -page letter ${PLOTFILE}.ps $WEBDIR/${PLOTFILE}.jpg
$CONVERT $WEBDIR/${PLOTFILE}.jpg -resize 241x -quality 95 $WEBDIR/${PLOTFILE}_small.jpg
rm ${PLOTFILE}.dat ${SPECIESA}.dat ${SPECIESB}.dat ${SPECIESC}.dat ${SPECIESD}.dat



# Plot4
PLOTFILE=let_${SC}_${YEAR}_${MONTHNAME}_4

# Argon
SRCFILE=`/bin/ls $SRCDIR/Ar_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Ar SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESA=Argon
export SRCA=${SPECIESA}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 11 > $SRCA

export YMINA=1E-6
export YMAXA=1E+2
export UNITSA="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEA=5
export IDXA=2	# indicates the lowest summed energy range for the species

# Calcium
SRCFILE=`/bin/ls $SRCDIR/Ca_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Ca SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESB=Calcium
export SRCB=${SPECIESB}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 11 > $SRCB

export YMINB=1E-6
export YMAXB=1E+2
export UNITSB="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEB=5
export IDXB=2	# indicates the lowest summed energy range for the species

# Iron
SRCFILE=`/bin/ls $SRCDIR/Fe_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Fe SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESC=Iron
export SRCC=${SPECIESC}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 10 11 > $SRCC

export YMINC=1E-6
export YMAXC=1E+2
export UNITSC="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEC=5
export IDXC=2	# indicates the lowest summed energy range for the species

# Nickel
SRCFILE=`/bin/ls $SRCDIR/Ni_summed_${SC}_${YEAR}_1hr_level1_*.txt  2> /dev/null | tail -1`
if [ ! $SRCFILE ]; then
   if [ $NOB -eq 0 ]; then
      echo $0: Warning: Ni SRCFILE does not exist...continuing
   fi
   /bin/rm -f tmp.dat ; touch tmp.dat ; SRCFILE=tmp.dat
fi

export SPECIESD=Nickel
export SRCD=${SPECIESD}.dat
$BEHEAD $SRCFILE | $COLFIL -c 2 7 8 9 > $SRCD

export YMIND=1E-6
export YMAXD=1E+2
export UNITSD="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACED=3
export IDXD=4	# indicates the lowest summed energy range for the species

./gen_monthly_plot.bash > ${PLOTFILE}.dat
cat ${PLOTFILE}.dat | $PLOT2PST -p 1 > ${PLOTFILE}.ps
$CONVERT -quality 90 -trim -page letter ${PLOTFILE}.ps $WEBDIR/${PLOTFILE}.jpg
$CONVERT $WEBDIR/${PLOTFILE}.jpg -resize 241x -quality 95 $WEBDIR/${PLOTFILE}_small.jpg
rm ${PLOTFILE}.dat ${SPECIESA}.dat ${SPECIESB}.dat ${SPECIESC}.dat ${SPECIESD}.dat
