#!/usr/local/bin/bash
# Assume proper environment is inherited

SCALE="-h 1.0 -w 1.0 -r -0.05 -u -0.05 -sc 1.0"
SCALEB="-h 1.0 -w 1.0 -r -0.05 -u -0.02 -sc 1.0"

COLOR1="-C 0 0 0"	# COLOR1 must be black
COLOR2="-C 40000 0 0"
COLOR3="-C 65535 0 0"
COLOR4="-C 30000 30000 30000"
COLOR5="-C 0 0 65535"
COLOR6="-C 0 0 0"

echo 0.11 0.999 | \
$AXIS $COLOR1 -L 65535 -g 0 -m 0 -s -sg 0.6 \
-ltx 0.25 -lty 1.00 -lts 1.1 -lt "Summed bins" \
-lsty -0.15 -lsts 0.7 -lst "$LEGEND" \
-c "\oc" -cs 0.9 \
-x 0 1 -y 0 1 \
$SCALEB

echo 0.523 0.999 | \
$AXIS $COLOR3 -L 65535 -g 0 -m 0 -s -sg 0.6 \
-c "\pl" -cs 1.0 \
-x 0 1 -y 0 1 \
$SCALEB

echo 0.442 0.999 | \
$AXIS $COLOR3 -L 65535 -g 0 -m 0 -s -sg 0.6 \
-ltx 0.564 -lty 1.00 -lts 1.1 -lt "Narrow bins" \
-c "\oc" -cs 0.9 \
-x 0 1 -y 0 1 \
$SCALEB

echo 0.72 0.999 | \
$AXIS $COLOR5 -L 65535 -g 0 -m 0 -s -sg 0.6 \
-ltx 0.8 -lty 1.00 -lts 1.1 -lt "ACE/SIS" \
-c "\di" -cs 0.9 \
-x 0 1 -y 0 1 \
$SCALEB

$GAWK '($2>0){print $1,$2,$3}' $1 | \
$AXIS $COLOR1 -g 0 -e -E -L 65535 -m 0 -s -sg 0.6 \
-c "\oc" -cs 0.9 \
-x l $XMIN $XMAX -y l $YMIN $YMAX \
$SCALE

$GAWK '(($2>0)&&($6==1)){print $1,$2,$3}' $2 | \
$AXIS $COLOR3 -g 0 -e -E -L 65535 -m 0 -s -sg 0.6 \
-c "\oc" -cs 0.9 \
-x l $XMIN $XMAX -y l $YMIN $YMAX \
$SCALE

$GAWK '(($2>0)&&($6<1)){print $1,$2,$3}' $2 | \
$AXIS $COLOR3 -g 0 -e -E -L 65535 -m 0 -s -sg 0.6 \
-c "\pl" -cs 1.0 \
-x l $XMIN $XMAX -y l $YMIN $YMAX \
$SCALE

if [ -f SIS_${SPECIES}.dat ]; then
   $GAWK '($2>0){print}' SIS_${SPECIES}.dat | \
   $AXIS $COLOR5 -g 0 -e -E -L 65535 -m 0 -s -sg 0.6 \
   -c "\di" -cs 0.9 \
   -x l $XMIN $XMAX -y l $YMIN $YMAX \
   $SCALE
fi

echo -1 1 | \
$AXIS $COLOR1 -L 65535 -m 0 -s -ls 1.1 -sg 0.6 \
-x l $XMIN $XMAX -y l $YMIN $YMAX \
-lty 1.07 -lts 1.05 -lt "$TITLE" \
-lstx 0.8 -lsty 0.93 -lsts 1.3 -lst "$SPECIESLONG" \
$SCALE -lys 1.0 -ly "$UNITS" \
-lxs 1.0 -lx "$XLABEL" 

