#!/usr/local/bin/bash
# Assume proper environment is inherited

SCALEA="-h 0.32 -w 1.1 -r -0.1 -u 1.07 -sc 1.0"	# panel position/size setup
SCALEB="-h 0.32 -w 1.1 -r -0.1 -u 0.68 -sc 1.0"
SCALEC="-h 0.32 -w 1.1 -r -0.1 -u 0.29 -sc 1.0"
SCALED="-h 0.32 -w 1.1 -r -0.1 -u -0.1 -sc 1.0"

SCALEE="-h 0.32 -w 1.1 -r -0.1 -u -0.17 -sc 1.0" # position the day-month-year labels

SPOS="-lstx 0.05 -lsty 1.04 -lsts 0.78"	# species label setup

LPOS1="-lstx 0.2 -lsty 1.04 -lsts 0.78"	# energy-band label setup
LPOS2="-lstx 0.35 -lsty 1.04 -lsts 0.78"
LPOS3="-lstx 0.45 -lsty 1.04 -lsts 0.78"
LPOS4="-lstx 0.55 -lsty 1.04 -lsts 0.78"
LPOS5="-lstx 0.65 -lsty 1.04 -lsts 0.78"
LPOS6="-lstx 0.75 -lsty 1.04 -lsts 0.78"

COLOR1="-C 0 0 0"	# COLOR1 must be black
COLOR2="-C 40000 0 0"
COLOR3="-C 65535 0 0"
COLOR4="-C 30000 30000 30000"
COLOR5="-C 0 0 65535"
COLOR6="-C 0 0 0"

# Plot Panel A
# if [ $NPANELS -eq 1 ]; then
#   XSTUFF="-nox -lxs 0.85 -lxx 0.37 -lxy -0.1 -lx"
# else
#    XSTUFF="-nox -lxs 1.0 -lxx -10.0 -lx"
# fi

XSTUFF="-nox"

# Panel frame, tickmarks, species label, Y-axis label
echo -1 1 | \
$AXIS $COLOR1 -L 65535 -m 0 -s -ls 0.85 -sg 0.6 \
-x $XMIN $XMAX $XSTEP -y l $YMINA $YMAXA \
-lty 1.2 -lts 1.2 -lt "$TITLE" \
$SCALEA $SPOS -lst $SPECIESA -lys 1.0 -ly "$UNITSA" \
$XSTUFF

# plot each trace
for (( i=1; i <= NTRACEA; i++ )); do
   COLOR=COLOR$IDXA
   LPOS=LPOS$IDXA
   LEGEND=LEGEND$IDXA
   $GAWK 'BEGIN{x='$i'+1}($3>=0){print $1,$x}' $SRCA | \
   $AXIS ${!COLOR} -L 65535 -m 0 -g 0 -s -ls 0.85 \
   -x $XMIN $XMAX $XSTEP -y l $YMINA $YMAXA \
   $SCALEA ${!LPOS} -lst "${!LEGEND}"
   (( IDXA++ ))
done

# Plot Panel B
# if [ $NPANELS -eq 2 ]; then
#   XSTUFF="-nox -lxs 0.85 -lxx 0.37 -lxy -0.1 -lx"
# else
#    XSTUFF="-nox -lxs 1.0 -lxx -10.0 -lx"
# fi

# Panel frame, tickmarks, species label, Y-axis label
echo -1 1 | \
$AXIS $COLOR1 -L 65535 -m 0 -s -ls 0.85 -sg 0.6 \
-x $XMIN $XMAX $XSTEP -y l $YMINB $YMAXB \
$SCALEB $SPOS -lst $SPECIESB -lys 1.0 -ly "$UNITSB" \
$XSTUFF

# plot each trace
for (( i=1; i <= NTRACEB; i++ )); do
   COLOR=COLOR$IDXB
   LPOS=LPOS$IDXB
   LEGEND=LEGEND$IDXB
   $GAWK 'BEGIN{x='$i'+1}($3>=0){print $1,$x}' $SRCB | \
   $AXIS ${!COLOR} -L 65535 -m 0 -g 0 -s -ls 0.85 \
   -x $XMIN $XMAX $XSTEP -y l $YMINB $YMAXB \
   $SCALEB ${!LPOS} -lst "${!LEGEND}"
   (( IDXB++ ))
done

# Plot Panel C
# if [ $NPANELS -eq 3 ]; then
#   XSTUFF="-nox -lxs 0.85 -lxx 0.37 -lxy -0.1 -lx"
# else
#    XSTUFF="-nox -lxs 1.0 -lxx -10.0 -lx"
# fi

# Panel frame, tickmarks, species label, Y-axis label
echo -1 1 | \
$AXIS $COLOR1 -L 65535 -m 0 -s -ls 0.85 -sg 0.6 \
-x $XMIN $XMAX $XSTEP -y l $YMINC $YMAXC \
$SCALEC $SPOS -lst $SPECIESC -lys 1.0 -ly "$UNITSC" \
$XSTUFF

# plot each trace
for (( i=1; i <= NTRACEC; i++ )); do
   COLOR=COLOR$IDXC
   LPOS=LPOS$IDXC
   LEGEND=LEGEND$IDXC
   $GAWK 'BEGIN{x='$i'+1}($3>=0){print $1,$x}' $SRCC | \
   $AXIS ${!COLOR} -L 65535 -m 0 -g 0 -s -ls 0.85 \
   -x $XMIN $XMAX $XSTEP -y l $YMINC $YMAXC \
   $SCALEC ${!LPOS} -lst "${!LEGEND}"
   (( IDXC++ ))
done

# Plot Panel D
# if [ $NPANELS -eq 4 ]; then
#   XSTUFF="-nox -lxs 0.85 -lxx 0.37 -lxy -0.1 -lx"
# else
#    XSTUFF="-nox -lxs 1.0 -lxx -10.0 -lx"
# fi

# Panel frame, tickmarks, species label, Y-axis label
echo -1 1 | \
$AXIS $COLOR1 -L 65535 -m 0 -s -ls 0.85 -sg 0.6 \
-x $XMIN $XMAX $XSTEP -y l $YMIND $YMAXD \
$SCALED $SPOS -lst $SPECIESD -lys 1.0 -ly "$UNITSD" \
$XSTUFF

# plot each trace
for (( i=1; i <= NTRACED; i++ )); do
   COLOR=COLOR$IDXD
   LPOS=LPOS$IDXD
   LEGEND=LEGEND$IDXD
   $GAWK 'BEGIN{x='$i'+1}($3>=0){print $1,$x}' $SRCD | \
   $AXIS ${!COLOR} -L 65535 -m 0 -g 0 -s -ls 0.85 \
   -x $XMIN $XMAX $XSTEP -y l $YMIND $YMAXD \
   $SCALED ${!LPOS} -lst "${!LEGEND}"
   (( IDXD++ ))
done


# echo $XLABEL > foooo
# echo $BXLABEL >> foooo

echo -1 1 | \
$AXIS $COLOR0 -L 0 -m 0 -g 0 -s \
-x $XMIN $XMAX $XSTEP -y 0 1 \
-lts 0.875 -ltx 0.455 -lty 0.005 -lt "$XLABEL" \
-lsts 0.85 -lstx 0.46 -lsty 0.09 -lst "$BXLABEL" \
$SCALEE



echo -1 1 | \
$AXIS $COLOR0 -L 0 -m 0 -g 0 -s \
-x $XMIN $XMAX $XSTEP -y 0 1 \
-lsty -0.11 -lsts 0.7 -lst "$NOTE" \
$SCALEE
