#!/usr/local/bin/bash
# figure out the public mask for each of a set of species/energy-bins 
# 1. Figure out which masks file to use (SC and date)
# 2. For each record in $INFILE Figure out corresponding record in masks file (species , emin, emax)
# 3. Add public maks flag to each record in $INFILE

. /home/stereo/Software/procenv

INFILE=$1
SC=$2
YEAR=$3
DOY=$4
species=$5


CALDIR=$STEREOIDL/LETLevel1/calfiles_public
MASKDB=$CALDIR/LET_Level1_maskdb_${SC}.txt
if [ ! -f $MASKDB ]; then
   echo $0: ERROR: $MASKDB does not exist.
   exit 1
fi

read FOO MONTHNAME DAY MONTHNUM < <( ./ymdfmyyyyddd.pl $YEAR $DOY )

# echo $MASKDB
# echo $YEAR $MONTHNUM $DAY

DATE=${YEAR}-${MONTHNUM}-${DAY}T00:00:00.000

sed -e '1,/BEGIN/d' -e '/ENDEND*/d' $MASKDB > chkmasks.tmp
read Nentries FOO FOO2 < <( wc chkmasks.tmp )

# echo $Nentries

for (( entry=1; entry <= Nentries; entry++ )); do
   read DBDATE MASKSFN < <( $GAWK '(NR=='$entry'){print}' chkmasks.tmp )
   read FOUND < <( ./diffdates.pl $DBDATE $DATE )
   # echo $FOUND $DBDATE $DATE
   if  [ $FOUND -ne 0 ]; then
      break
   fi
done

# echo $MASKSFN
MASKSFILE=$CALDIR/$MASKSFN
sed -e '1,/BEGIN/d' $MASKSFILE > chkmasks.tmp2

case "$species" in
	H)
	specnum=0
	;;
	He3)
	specnum=1
	;;
	He4)
	specnum=2
	;;
	C)
	specnum=3
	;;
	N)
	specnum=4
	;;
	O)
	specnum=5
	;;
	Ne)
	specnum=6
	;;
	Na)
	specnum=7
	;;
	Mg)
	specnum=8
	;;
	Al)
	specnum=9
	;;
	Si)
	specnum=10
	;;
	S)
	specnum=11
	;;
	Ar)
	specnum=12
	;;
	Ca)
	specnum=13
	;;
	Fe)
	specnum=14
	;;
	Ni)
	specnum=15
	;;
	He)
	specnum=16
	;;
	*)
	specnum=100
	;;
esac

# echo specnum= $specnum
if [ $specnum -eq 100 ]; then
   echo $0: ERROR: bad species input: $species
   exit 1
fi

# FINALLY!!! we get to lookup the entry in the masksfile corresponding to each entry in
# $INFILE...

$GAWK 'BEGIN{
   masksfile="chkmasks.tmp2"; specnum='$specnum'; idx=0;
   while ( getline < masksfile ) {
      if ($1==specnum) {
         Elo[idx]=$4; Ehi[idx]=$5;mask[idx]=$6;
         idx++;
      } else {
         if (idx>0) break;
      }
   }
   if (idx==0) exit 1;
}{
   matched==0;
   for (ii=0;ii<idx;ii++) {
      if (($4==Elo[ii])&&($5==Ehi[ii])) {
         matched=1;
         print $1,$2,$3,$4,$5,mask[ii];
      }
   }
   if (!matched) exit 1;
}' $INFILE > ${INFILE}_masked

if [ $? -ne 0 ]; then
   echo $0: ERROR: bad exit status from masks lookup
   exit 1
fi


#END{
#   for (ii=0;ii<idx;ii++) {
#      print Elo[ii], Ehi[ii], mask[ii];
#   }
#}


