#!/usr/local/bin/bash
. /home/stereo/Software/procenv

BART=$1
SC=$2
PUBPRI=$3


read SYEAR SDOY EYEAR EDOY < <( ./yyyydddfmbartels.pl $BART )
read XLAB1 XLAB2 XLAB3 XLAB4 XLAB5 XLAB6 < <( ./bartelslabels.pl $SYEAR $SDOY 1 )
read BXLAB1 BXLAB2 BXLAB3 BXLAB4 BXLAB5 BXLAB6 < <( ./bartelslabels.pl $SYEAR $SDOY 0 )

# Don't look for BEHIND data past 2014
NOB=0
if [ $SC == "behind" -a $BART -ge 2476 ]; then
   NOB=1
fi

# get rid of possible leading zeros in DOY variables
SDOY=$((10#$SDOY+0))
EDOY=$((10#$EDOY+0))

if [ $PUBPRI != "public" -a $PUBPRI != "private" ]; then
   echo Usage: $0 BART SC pubpri, where pubpri is public or private
   exit 1
fi

DATE=`date`

if [ $PUBPRI == "public" ]; then
   WEBDIR=$WEBPLOTS/Level1/Public/Bartels/$SC/$YEAR/$BART
   SRCDIR=$LETL1PUBDATAHOME/$SC
   export NOTE="Public Level 1 Data. $DATE"
else
   WEBDIR=$WEBPLOTS/Level1/SRLonly/Bartels/$SC/$YEAR/$BART
   SRCDIR=$LETL1SRLONLYDATAHOME/$SC
   export NOTE="SRL-only Data - do not distribute. $DATE"
fi

if [ ! -d $WEBDIR ]; then
   mkdir -p $WEBDIR
fi

# LET Level 1 data Version number
L1VERSIONSTR=`awk '($1=="VERSION"){print $3; exit}' $STEREOIDL/LETLevel1/let_l1_common.pro`
L1VERSION=`expr "$L1VERSIONSTR" : '\([0-9]*\)'`
if [ $L1VERSION -lt 10 ]; then L1VERSION=0$L1VERSION; fi
export L1VERSION

cd $STEREOIDL/LETLevel1/plots

export LEGEND1="1.8-3.6 MeV/n"
export LEGEND2="4-6"
export LEGEND3="6-10"
export LEGEND4="10-15"
export LEGEND5="15-27"
export LEGEND6="27-40"

export XMIN=0
export XMAX=27
export XSTEP=5

export NPANELS=4
export TITLE="STEREO LET $SC Hourly Averages - Bartels Rotation $BART"
# export XLAB1 XLAB2 XLAB3 XLAB4 XLAB5 XLAB6
# export BXLAB1 BXLAB2 BXLAB3 BXLAB4 BXLAB5 BXLAB6
GAP="     "
export XLABEL="$XLAB1$GAP$XLAB2$GAP$XLAB3$GAP$XLAB4$GAP$XLAB5$GAP$XLAB6"
GAP="      "
export BXLABEL="$BXLAB1$GAP$BXLAB2$GAP$BXLAB3$GAP$BXLAB4$GAP$BXLAB5$GAP$BXLAB6"

# Plot1
PLOTFILE=let_${SC}_${BART}_1


# Protons
export SPECIESA=Protons
export SRCA=${SPECIESA}.dat
/bin/rm -f $SRCA tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/H_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10}' tmp.dat >> $SRCA

export YMINA=1E-5
export YMAXA=1E+6
export UNITSA="1/(cm\\sp2\\ep s sr MeV)"
export NTRACEA=4
export IDXA=1	# indicates the lowest summed energy range for the species


# 4He
export SPECIESB=4He
export SRCB=${SPECIESB}.dat
/bin/rm -f $SRCB tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/He4_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10}' tmp.dat >> $SRCB

export YMINB=1E-5
export YMAXB=1E+6
export UNITSB="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEB=4
export IDXB=1	# indicates the lowest summed energy range for the species

# He
export SPECIESC=Helium
export SRCC=${SPECIESC}.dat
/bin/rm -f $SRCC tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/He_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9}' tmp.dat >> $SRCC


export YMINC=1E-5
export YMAXC=1E+6
export UNITSC="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEC=3
export IDXC=2	# indicates the lowest summed energy range for the species

# C
export SPECIESD=Carbon
export SRCD=${SPECIESD}.dat
/bin/rm -f $SRCD tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/C_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10}' tmp.dat >> $SRCD
										       
export YMIND=1E-6
export YMAXD=1E+4
export UNITSD="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACED=4
export IDXD=2	# indicates the lowest summed energy range for the species

./gen_bartels_plot.bash > ${PLOTFILE}.dat
cat ${PLOTFILE}.dat | $PLOT2PST -p 1 > ${PLOTFILE}.ps
$CONVERT -quality 90 -trim -page letter ${PLOTFILE}.ps $WEBDIR/${PLOTFILE}.jpg
$CONVERT $WEBDIR/${PLOTFILE}.jpg -resize 241x -quality 95 $WEBDIR/${PLOTFILE}_small.jpg
rm ${PLOTFILE}.dat ${SPECIESA}.dat ${SPECIESB}.dat ${SPECIESC}.dat ${SPECIESD}.dat


# Plot2
PLOTFILE=let_${SC}_${BART}_2

# Nitrogen
export SPECIESA=Nitrogen
export SRCA=${SPECIESA}.dat
/bin/rm -f $SRCA tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/N_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10}' tmp.dat >> $SRCA

export YMINA=1E-6
export YMAXA=1E+4
export UNITSA="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEA=4
export IDXA=2	# indicates the lowest summed energy range for the species

# Oxygen
export SPECIESB=Oxygen
export SRCB=${SPECIESB}.dat
/bin/rm -f $SRCB tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/O_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10}' tmp.dat >> $SRCB

export YMINB=1E-6
export YMAXB=1E+4
export UNITSB="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEB=4
export IDXB=2	# indicates the lowest summed energy range for the species

# Neon
export SPECIESC=Neon
export SRCC=${SPECIESC}.dat
/bin/rm -f $SRCC tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/Ne_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10}' tmp.dat >> $SRCC

export YMINC=1E-6
export YMAXC=1E+4
export UNITSC="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEC=4
export IDXC=2	# indicates the lowest summed energy range for the species

# Na
export SPECIESD=Sodium
export SRCD=${SPECIESD}.dat
/bin/rm -f $SRCD tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/Na_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10}' tmp.dat >> $SRCD

export YMIND=1E-6
export YMAXD=1E+4
export UNITSD="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACED=2
export IDXD=4	# indicates the lowest summed energy range for the species

./gen_bartels_plot.bash > ${PLOTFILE}.dat
cat ${PLOTFILE}.dat | $PLOT2PST -p 1 > ${PLOTFILE}.ps
$CONVERT -quality 90 -trim -page letter ${PLOTFILE}.ps $WEBDIR/${PLOTFILE}.jpg
$CONVERT $WEBDIR/${PLOTFILE}.jpg -resize 241x -quality 95 $WEBDIR/${PLOTFILE}_small.jpg
rm ${PLOTFILE}.dat ${SPECIESA}.dat ${SPECIESB}.dat ${SPECIESC}.dat ${SPECIESD}.dat


# Plot3
PLOTFILE=let_${SC}_${BART}_3

# Magnesium
export SPECIESA=Magnesium
export SRCA=${SPECIESA}.dat
/bin/rm -f $SRCA tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/Mg_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10}' tmp.dat >> $SRCA

export YMINA=1E-6
export YMAXA=1E+2
export UNITSA="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEA=4
export IDXA=2	# indicates the lowest summed energy range for the species

# Aluminum
export SPECIESB=Aluminum
export SRCB=${SPECIESB}.dat
/bin/rm -f $SRCB tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/Al_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9}' tmp.dat >> $SRCB

export YMINB=1E-6
export YMAXB=1E+2
export UNITSB="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEB=3
export IDXB=3	# indicates the lowest summed energy range for the species

# Silicon
export SPECIESC=Silicon
export SRCC=${SPECIESC}.dat
/bin/rm -f $SRCC tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/Si_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10}' tmp.dat >> $SRCC

export YMINC=1E-6
export YMAXC=1E+2
export UNITSC="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEC=5
export IDXC=2	# indicates the lowest summed energy range for the species

# Sulfur
export SPECIESD=Sulfur
export SRCD=${SPECIESD}.dat
/bin/rm -f $SRCD tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/S_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10,$11}' tmp.dat >> $SRCD

export YMIND=1E-6
export YMAXD=1E+4
export UNITSD="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACED=5
export IDXD=2	# indicates the lowest summed energy range for the species

./gen_bartels_plot.bash > ${PLOTFILE}.dat
cat ${PLOTFILE}.dat | $PLOT2PST -p 1 > ${PLOTFILE}.ps
$CONVERT -quality 90 -trim -page letter ${PLOTFILE}.ps $WEBDIR/${PLOTFILE}.jpg
$CONVERT $WEBDIR/${PLOTFILE}.jpg -resize 241x -quality 95 $WEBDIR/${PLOTFILE}_small.jpg
rm ${PLOTFILE}.dat ${SPECIESA}.dat ${SPECIESB}.dat ${SPECIESC}.dat ${SPECIESD}.dat



# Plot4
PLOTFILE=let_${SC}_${BART}_4

# Argon
export SPECIESA=Argon
export SRCA=${SPECIESA}.dat
/bin/rm -f $SRCA tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/Ar_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10,$11}' tmp.dat >> $SRCA

export YMINA=1E-6
export YMAXA=1E+2
export UNITSA="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEA=5
export IDXA=2	# indicates the lowest summed energy range for the species

# Calcium
export SPECIESB=Calcium
export SRCB=${SPECIESB}.dat
/bin/rm -f $SRCB tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/Ca_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10,$11}' tmp.dat >> $SRCB

export YMINB=1E-6
export YMAXB=1E+2
export UNITSB="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEB=5
export IDXB=2	# indicates the lowest summed energy range for the species

# Iron
export SPECIESC=Iron
export SRCC=${SPECIESC}.dat
/bin/rm -f $SRCC tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/Fe_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9,$10,$11}' tmp.dat >> $SRCC

export YMINC=1E-6
export YMAXC=1E+2
export UNITSC="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACEC=5
export IDXC=2	# indicates the lowest summed energy range for the species

# Nickel
export SPECIESD=Nickel
export SRCD=${SPECIESD}.dat
/bin/rm -f $SRCD tmp.dat
touch tmp.dat
for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
   SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/Ni_summed_${SC}_${yr}_1hr_level1_*.txt  2> /dev/null | tail -1`
   if [ !  $SRCFILE ]; then
      if [ $yr -eq $SYEAR -a $NOB -eq 0 ]; then
         echo $0: $SRCFILE does not exist...exiting
         exit 1
      fi
   else
      $BEHEAD $SRCFILE >> tmp.dat
   fi
done

$GAWK 'BEGIN{syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; }{ \
      if (($1==syear)&&($2<sdoy)) next;
      if (($1==eyear)&&($2>=edoy+1)) exit;
      if (eyear != syear) {
         if ($1==syear) {xval=$2 - sdoy; xvalsave=xval; }
         if ($1==eyear) xval=$2 + int(xvalsave);
      } else {
         xval = $2-sdoy;
      }
      print xval, $7,$8,$9}' tmp.dat >> $SRCD

export YMIND=1E-6
export YMAXD=1E+2
export UNITSD="1/(cm\\sp2\\ep s sr MeV/n)"
export NTRACED=3
export IDXD=4	# indicates the lowest summed energy range for the species

./gen_bartels_plot.bash > ${PLOTFILE}.dat
cat ${PLOTFILE}.dat | $PLOT2PST -p 1 > ${PLOTFILE}.ps
$CONVERT -quality 90 -trim -page letter ${PLOTFILE}.ps $WEBDIR/${PLOTFILE}.jpg
$CONVERT $WEBDIR/${PLOTFILE}.jpg -resize 241x -quality 95 $WEBDIR/${PLOTFILE}_small.jpg
rm ${PLOTFILE}.dat ${SPECIESA}.dat ${SPECIESB}.dat ${SPECIESC}.dat ${SPECIESD}.dat
