#!/usr/local/bin/bash
# Average LET Hourly fluxes over a period of days

. /home/stereo/Software/procenv

SPECIES=$1
SYEAR=$2
SDOY=$3
EYEAR=$4
EDOY=$5
BINSFILE=$6
SRCFILE=$7
OUTFILE=$8

# get rid of possible leading zeros in DOY variables
SDOY=$((10#$SDOY+0))
EDOY=$((10#$EDOY+0))

$GAWK 'BEGIN{
   binsfile="'$BINSFILE'"; species="'$SPECIES'"; syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY';
   nbins=0; matched=0;
   while ( getline < binsfile ) 
      if ($1==species) { matched=1; break; }
   if (!matched) exit 1;
   nbins=$2;
   for (i=0; i<nbins;i++) {
      elo[i]=$((i+1)*2 +1); ehi[i]=$((i+1)*2 +2);
      ebin[i] = sqrt(elo[i] * ehi[i]);
      cnt[i] = 0; avg[i]=0; unc[i]=0;
   }
   
}{ \
   if (($1==syear)&&($2<sdoy)) next;
   if (($1==eyear)&&($2>=edoy+1)) exit;
   for (i=0; i<nbins;i++) {
      f_idx=i+7; c_idx=f_idx+(1*nbins);
#      if (i==0) print f_idx, c_idx, $f_idx, $c_idx;
      if ($f_idx >=0) {
         cnt[i]++; avg[i]+=$f_idx;
	 if ($c_idx>0)
	    unc[i]+=($f_idx * $f_idx)/$c_idx;
      }
   }
}END{
   for (i=0; i<nbins;i++) {
      if (cnt[i] >0) {
         avg[i] = avg[i]/cnt[i];
	 unc[i] = sqrt(unc[i])/cnt[i];
      }
      else {
         avg[i] = -9999.9; unc[i] = 0.0;
      }
      printf("%7.3f % 10.4e % 10.4e %7.3f %7.3f\n",ebin[i],avg[i],unc[i],elo[i],ehi[i]);
   }
}' $SRCFILE >> $OUTFILE
