#!/bin/bash
# Create the header for a LET Level 1 ASCII data file, or LET rates file

species=$1

case $species in
	H)
		echo STEREO LET LEVEL 1 combined proton data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   1.8 -  3.6 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   4.0 -  6.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  6.0 - 10.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 10.0 - 15.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12 - 15: 4 proton counts , same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He3)
		echo STEREO LET LEVEL 1 combined 3He data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11 - 13: 3 3He counts , same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He4)
		echo STEREO LET LEVEL 1 combined 4He data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   1.8 -  3.6 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   4.0 -  6.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  6.0 - 10.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 10.0 - 15.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12 - 15: 4 4He counts , same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He)
		echo STEREO LET LEVEL 1 combined Helium data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11 - 13: 3 He counts , same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	C)
		echo STEREO LET LEVEL 1 combined carbon data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12 - 15: 4 carbon counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	N)
		echo STEREO LET LEVEL 1 combined nitrogen data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12 - 15: 4 nitrogen counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	O)
		echo STEREO LET LEVEL 1 combined oxygen data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12 - 15: 4 oxygen counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Ne)
		echo STEREO LET LEVEL 1 combined neon data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12 - 15: 4 neon counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Na)
		echo STEREO LET LEVEL 1 combined sodium data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8: 10.0 - 15.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9: 15.0 - 27.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10 - 11: 2 sodium counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Mg)
		echo STEREO LET LEVEL 1 combined magnesium data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12 - 15: 4 magnesium counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Al)
		echo STEREO LET LEVEL 1 combined aluminum data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:  6.0 - 10.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9: 10.0 - 15.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 15.0 - 27.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11 - 13: 3 aluminum counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Si)
		echo STEREO LET LEVEL 1 combined silicon data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12: 27.0 - 40.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13 - 17: 5 silicon counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	S)
		echo STEREO LET LEVEL 1 combined sulfur data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12: 27.0 - 40.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13 - 17: 5 sulfur counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Ar)
		echo STEREO LET LEVEL 1 combined argon data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12: 27.0 - 40.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13 - 17: 5 argon counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Ca)
		echo STEREO LET LEVEL 1 combined calcium data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12: 27.0 - 40.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13 - 17: 5 calcium counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Fe)
		echo STEREO LET LEVEL 1 combined iron data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   4.0 -  6.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   6.0 - 10.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 15.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 27.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12: 27.0 - 40.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13 - 17: 5 iron counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Ni)
		echo STEREO LET LEVEL 1 combined nickel data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into wider energy ranges than the raw data.
		echo They should be useful for plotting trends or computing ratios.
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:  10.0 - 15.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:  15.0 - 27.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 27.0 - 40.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11 - 13: 3 nickel counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	*)
		;;
esac

echo BEGIN DATA
