#!/bin/bash
# Create the header for a LET Level 1 ASCII data file, or LET rates file

species=$1

case $species in
	H_vlo)
		echo STEREO LET LEVEL 1 sectored 1.8 - 3.6 MeV proton data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored proton intensities, 1.8 - 3.6 MeV \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  proton counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	H_lo)
		echo STEREO LET LEVEL 1 sectored 4 - 6 MeV proton data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored proton intensities, 4 - 6 MeV \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  proton counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	H_hi)
		echo STEREO LET LEVEL 1 sectored 6 - 10 MeV proton data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored proton intensities, 6 - 10 MeV \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  proton counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He3_lo)
		echo STEREO LET LEVEL 1 sectored 4 - 6 MeV/nuc 3He data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored 3He intensities, 4 - 6 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  3He counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He4_lo)
		echo STEREO LET LEVEL 1 sectored 4 - 6 MeV/nuc 4He data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored 4He intensities, 4 - 6 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  4He counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He4_hi)
		echo STEREO LET LEVEL 1 sectored 6 - 12 MeV/nuc 4He data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored 4He intensities, 6 - 12 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  4He counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He_lo)
		echo STEREO LET LEVEL 1 sectored 4 - 6 MeV/nuc helium data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored helium intensities, 4 - 6 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  helium counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	CNO_lo)
		echo STEREO LET LEVEL 1 sectored 4 - 6 MeV/nuc CNO data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored CNO intensities, 4 - 6 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  CNO counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	CNO_hi)
		echo STEREO LET LEVEL 1 sectored 6 - 12 MeV/nuc CNO data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored CNO intensities, 6 - 12 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  CNO counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	NeMgSi_lo)
		echo STEREO LET LEVEL 1 sectored 4 - 6 MeV/nuc NeMgSi data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored NeMgSi intensities, 4 - 6 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  NeMgSi counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	NeMgSi_hi)
		echo STEREO LET LEVEL 1 sectored 6 - 12 MeV/nuc NeMgSi data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored NeMgSi intensities, 6 - 12 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  NeMgSi counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Fe_lo)
		echo STEREO LET LEVEL 1 sectored 4 - 6 MeV/nuc Fe data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored Fe intensities, 4 - 6 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  Fe counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Fe_hi)
		echo STEREO LET LEVEL 1 sectored 6 - 12 MeV/nuc Fe data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored Fe intensities, 6 - 12 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  Fe counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Fe)
		echo STEREO LET LEVEL 1 sectored 4 - 12 MeV/nuc Fe data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo These data are binned into 16 look-directions \(sectors\). 
		echo Detailed information about these sectored data may be found at
		echo http://www.srl.caltech.edu/STEREO/docs/LET_Level1.html
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8 - 23: 16 sectored Fe intensities, 4 - 12 MeV/nuc \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 sectored  Fe counts \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	*)
		;;
esac

echo BEGIN DATA
