#!/bin/bash
# Create the header for a LET Level 1 ASCII data file, or LET rates file

species=$1

case $species in
	H)
		echo STEREO LET LEVEL 1 proton data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   1.8 -  2.2 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   2.2 -  2.7 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  2.7 -  3.2 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  3.2 -  3.6 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  3.6 -  4.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  4.0 -  4.5 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  4.5 -  5.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15:  5.0 -  6.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16:  6.0 -  8.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17:  8.0 - 10.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 10.0 - 12.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 12.0 - 15.0 MeV proton intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20 - 31: 12 proton counts , same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He3)
		echo STEREO LET LEVEL 1 3He data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   2.2 -  2.7 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   2.7 -  3.2 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  3.2 -  3.6 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  3.6 -  4.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  4.0 -  4.5 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  4.5 -  5.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  5.0 -  6.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15:  6.0 -  8.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16:  8.0 - 10.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 10.0 - 12.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 12.0 - 15.0 MeV/n 3He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19 - 29: 11 3He counts , same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He4)
		echo STEREO LET LEVEL 1 4He data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   1.8 -  2.2 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   2.2 -  2.7 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  2.7 -  3.2 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  3.2 -  3.6 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  3.6 -  4.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  4.0 -  4.5 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  4.5 -  5.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15:  5.0 -  6.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16:  6.0 -  8.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17:  8.0 - 10.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 10.0 - 12.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 12.0 - 15.0 MeV/n 4He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20 - 31: 12 4He counts , same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	He)
		echo STEREO LET LEVEL 1 Helium data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   2.2 -  2.7 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   2.7 -  3.2 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  3.2 -  3.6 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  3.6 -  4.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  4.0 -  4.5 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  4.5 -  5.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  5.0 -  6.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15:  6.0 -  8.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16:  8.0 - 10.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 10.0 - 12.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 12.0 - 15.0 MeV/n He intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19 - 29: 11 He counts , same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	C)
		echo STEREO LET LEVEL 1 carbon data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   3.2 -  3.6 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   3.6 -  4.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  4.0 -  4.5 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  4.5 -  5.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  5.0 -  6.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  6.0 -  8.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  8.0 - 10.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 10.0 - 12.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 12.0 - 15.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 15.0 - 21.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 21.0 - 27.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 27.0 - 33.0 MeV/n carbon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20 - 31: 12 carbon counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	N)
		echo STEREO LET LEVEL 1 nitrogen data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   3.2 -  3.6 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   3.6 -  4.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  4.0 -  4.5 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  4.5 -  5.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  5.0 -  6.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  6.0 -  8.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  8.0 - 10.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 10.0 - 12.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 12.0 - 15.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 15.0 - 21.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 21.0 - 27.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 27.0 - 33.0 MeV/n nitrogen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20 - 31: 12 nitrogen counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	O)
		echo STEREO LET LEVEL 1 oxygen data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   3.2 -  3.6 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   3.6 -  4.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  4.0 -  4.5 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  4.5 -  5.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  5.0 -  6.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  6.0 -  8.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  8.0 - 10.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 10.0 - 12.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 12.0 - 15.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 15.0 - 21.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 21.0 - 27.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 27.0 - 33.0 MeV/n oxygen intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20 - 31: 12 oxygen counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Ne)
		echo STEREO LET LEVEL 1 neon data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   3.2 -  3.6 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   3.6 -  4.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  4.0 -  4.5 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  4.5 -  5.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  5.0 -  6.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  6.0 -  8.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  8.0 - 10.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 10.0 - 12.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 12.0 - 15.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 15.0 - 21.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 21.0 - 27.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 27.0 - 33.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20: 33.0 - 40.0 MeV/n neon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 21 - 33: 13 neon counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Na)
		echo STEREO LET LEVEL 1 sodium data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:  6.0 -  8.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:  8.0 - 10.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 12.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 12.0 - 15.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12: 15.0 - 21.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13: 21.0 - 27.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14: 27.0 - 33.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 33.0 - 40.0 MeV/n sodium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16 - 23: 8 sodium counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Mg)
		echo STEREO LET LEVEL 1 magnesium data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   3.2 -  3.6 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   3.6 -  4.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  4.0 -  4.5 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  4.5 -  5.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  5.0 -  6.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  6.0 -  8.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  8.0 - 10.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 10.0 - 12.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 12.0 - 15.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 15.0 - 21.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 21.0 - 27.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 27.0 - 33.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20: 33.0 - 40.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 21: 40.0 - 52.0 MeV/n magnesium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 22 - 35: 14 magnesium counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Al)
		echo STEREO LET LEVEL 1 aluminum data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:  6.0 -  8.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:  8.0 - 10.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 10.0 - 12.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 12.0 - 15.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12: 15.0 - 21.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13: 21.0 - 27.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14: 27.0 - 33.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 33.0 - 40.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 40.0 - 52.0 MeV/n aluminum intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17 - 25: 9 aluminum counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Si)
		echo STEREO LET LEVEL 1 silicon data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   3.2 -  3.6 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   3.6 -  4.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  4.0 -  4.5 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  4.5 -  5.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  5.0 -  6.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  6.0 -  8.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  8.0 - 10.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 10.0 - 12.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 12.0 - 15.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 15.0 - 21.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 21.0 - 27.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 27.0 - 33.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20: 33.0 - 40.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 21: 40.0 - 52.0 MeV/n silicon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 22 - 35: 14 silicon counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	S)
		echo STEREO LET LEVEL 1 sulfur data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   3.6 -  4.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   4.0 -  4.5 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  4.5 -  5.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  5.0 -  6.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  6.0 -  8.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  8.0 - 10.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14: 10.0 - 12.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 12.0 - 15.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 15.0 - 21.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 21.0 - 27.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 27.0 - 33.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 33.0 - 40.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20: 40.0 - 52.0 MeV/n sulfur intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 21 - 33: 13 sulfur counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Ar)
		echo STEREO LET LEVEL 1 argon data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   3.6 -  4.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   4.0 -  4.5 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  4.5 -  5.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  5.0 -  6.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  6.0 -  8.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  8.0 - 10.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14: 10.0 - 12.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 12.0 - 15.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 15.0 - 21.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 21.0 - 27.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 27.0 - 33.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 33.0 - 40.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20: 40.0 - 52.0 MeV/n argon intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 21 - 33: 13 argon counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Ca)
		echo STEREO LET LEVEL 1 calcium data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   3.6 -  4.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   4.0 -  4.5 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  4.5 -  5.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  5.0 -  6.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  6.0 -  8.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  8.0 - 10.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14: 10.0 - 12.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 12.0 - 15.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 15.0 - 21.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 21.0 - 27.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 27.0 - 33.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 33.0 - 40.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20: 40.0 - 52.0 MeV/n calcium intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 21 - 33: 13 calcium counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Fe)
		echo STEREO LET LEVEL 1 iron data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   2.7 -  3.2 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:   3.2 -  3.6 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10:  3.6 -  4.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11:  4.0 -  4.5 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12:  4.5 -  5.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13:  5.0 -  6.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14:  6.0 -  8.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15:  8.0 - 10.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 10.0 - 12.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17: 12.0 - 15.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 18: 15.0 - 21.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 19: 21.0 - 27.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 20: 27.0 - 33.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 21: 33.0 - 40.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 22: 40.0 - 52.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 23: 52.0 - 70.0 MeV/n iron intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 24 - 39: 16 iron counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	Ni)
		echo STEREO LET LEVEL 1 nickel data for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Note: Timestamps mark beginning of data accumulation interval
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6: LET dynamic threshold state \(0 - 3\)
		echo Column 7: LET Livetime \(seconds\)
		echo Column 8:   8.0 - 10.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 9:  10.0 - 12.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 10: 12.0 - 15.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 11: 15.0 - 21.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 12: 21.0 - 27.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 13: 27.0 - 33.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 14: 33.0 - 40.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 15: 40.0 - 52.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 16: 52.0 - 70.0 MeV/n nickel intensity \(1/\(cm^2 s sr MeV/nuc\)\)
		echo Column 17 - 25: 9 nickel counts, same energy ranges as above \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	EVP)
		echo STEREO LET Onboard event processing rates for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6 - 21: 16 EVPRATES \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	BUF)
		echo STEREO LET Onboard priority buffer rates for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6 - 34: 29 BUFRATES \(counts/minute\)
		echo Column 35: Livetime \(seconds\)
		echo Column 36: NTriggers \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	SINGLES)
		echo STEREO LET Singles rates for $SC spacecraft, for ${YEAR}-$DOY3
		echo $COMMENT
		echo File created: `date`
		echo Created by: Caltech Space Radiation Lab
		echo Level 1 software version $L1VERSION
		echo Time Resolution: 1 minute \(highest LET instrument resolution\)
		echo Column 1: Year
		echo Column 2: Day of year \(fractional\)
		echo Column 3: Hour of day
		echo Column 4: Minute of hour
		echo Column 5: Second of minute
		echo Column 6 - 113: 108 SINGLESRATES \(counts/minute\)
		echo Bad/missing data are filled with -1.0E+31 for floating point, -2147483647 for integers
		;;
	*)
		;;
esac

echo BEGIN DATA
