PRO LEVEL1_hdrprint,INFILENAME
;+
; Project     :	STEREO - IMPACT, LET
;
; Name        : LEVEL1_DRIVER
;
; Purpose     :	Test program to feed LET science packets to LET Level 1 processing routines
;
; Category    :	STEREO, IMPACT, LET
;
; Explanation :	reads STEREO telemetry data and passes
;               LET science packets (apid=580) to LET Level 1 processing.
;               Also, calls let_l1_common to setup LET Level 1 common block
;
; Syntax      :	
;
; Examples    :	
;
; Inputs      :	Filename of telemetry data file (PTP or STP).
;
; Opt. Inputs :	None.
;
; Outputs     :	None
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	let_l1_common, read_stereo_pkt, parse_stereo_pkt, let_level1
;
; Common      :
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 18-Apr-2005, Andrew Davis, Caltech
;
; Contact     :	ad@srl.caltech.edu
;-
;

  let_l1_common ; setup let level 1 global vars, is there a better way?

  ; Open input data file for reading.
  ; printf,-2,'Opening input file'

  openr, unit, infilename, /get_lun, error = error_flag
  IF (error_flag ne 0) then BEGIN
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
  ENDIF


  packet = 0
  letl1data = 0

  WHILE 1 DO BEGIN
     read_stereo_pkt, unit, packet
     if n_elements(packet) eq 0 then break
     apid = parse_stereo_pkt(packet, /APID )

     ; send LET science packets (apid=580) to LET level 1 processing.
     ; letdata structure is returned undefined unless let_level1 has
     ; all the info needed to process a LET science frame
     IF apid eq 580 THEN BEGIN
        let_level1, packet, letl1data

	; do something useful with the LET level 1 data structure here
	IF n_elements(letl1data) ne 0 THEN BEGIN
           utc = int2utc(letl1data.header.timeCDS)
           year = utc.year
	   doy = utc2doy(utc, /FRACTIONAL)
	   hour = utc.hour
	   min = utc.minute
	   sec = utc.second

	   dycnts = letl1data.raw_rates.SNGRATES[8]  + letl1data.raw_rates.SNGRATES[10] + $
	   letl1data.raw_rates.SNGRATES[20] + letl1data.raw_rates.SNGRATES[38] + $
	   letl1data.raw_rates.SNGRATES[68] + letl1data.raw_rates.SNGRATES[92] + $
	   letl1data.raw_rates.SNGRATES[94] + letl1data.raw_rates.SNGRATES[104]

	   dyrate = dycnts / letl1data.header.Livetime

	   printf, -2, year, doy, hour, min, sec, letl1data.header.DyThState, $
	        letl1data.header.CodeOK , $
	   	letl1data.header.Livetime, $
		letl1data.raw_rates.SNGRATES[8], $
		letl1data.raw_rates.SNGRATES[10], $
		letl1data.raw_rates.SNGRATES[20], $
		letl1data.raw_rates.SNGRATES[38], $
		letl1data.raw_rates.SNGRATES[68], $
		letl1data.raw_rates.SNGRATES[92], $
		letl1data.raw_rates.SNGRATES[94], $
		letl1data.raw_rates.SNGRATES[104], $
		dyrate, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),5X,I1,5X,I1,5X,F7.4,8(1x,I6),2X,F8.1)'
	ENDIF
     ENDIF
  ENDWHILE
  
end ; level1_hdrprint

