PRO LEVEL1_DRIVER,INFILENAME,OUTFILES, SUMFILES, SECTFILES, DOSTANDARD, DOSUMMED, DOSECTORED, DORATES
;+
; Project     :	STEREO - IMPACT, LET
;
; Name        : LEVEL1_DRIVER
;
; Purpose     :	Test program to feed LET science packets to LET Level 1 processing routines
;
; Category    :	STEREO, IMPACT, LET
;
; Explanation :	reads STEREO telemetry data and passes
;               LET science packets (apid=580) to LET Level 1 processing.
;               Also, calls let_l1_common to setup LET Level 1 common block
;
; Syntax      :	
;
; Examples    :	
;
; Inputs      :	Filename of telemetry data file (PTP or STP).
;
; Opt. Inputs :	None.
;
; Outputs     :	None
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	let_l1_common, read_stereo_pkt, parse_stereo_pkt, let_level1
;
; Common      :
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 18-Apr-2005, Andrew Davis, Caltech
;
; Contact     :	ad@srl.caltech.edu
;-
;

  let_l1_common ; setup let level 1 global vars, is there a better way?

  ; Open input data file for reading.
  ; printf,-2,'Opening input file'

  openr, unit, infilename, /get_lun, error = error_flag
  IF (error_flag ne 0) then BEGIN
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
  ENDIF

; can't use /get_lun for all these files, since get_lun can only use units 100 - 128, apparently...
   Hlun=10
   He3lun=11
   He4lun=12
   Helun=13
   Clun=14
   Nlun=15
   Olun=16
   Nelun=17
   Nalun=18
   Mglun=19
   Allun=20
   Silun=21
   Slun=22
   Arlun=23
   Calun=24
   Felun=25
   Nilun=26

   EVPlun=27
   BUFlun=28
   SNGlun=29
   
   Hsumlun=30
   He3sumlun=31
   He4sumlun=32
   Hesumlun=33
   Csumlun=34
   Nsumlun=35
   Osumlun=36
   Nesumlun=37
   Nasumlun=38
   Mgsumlun=39
   Alsumlun=40
   Sisumlun=41
   Ssumlun=42
   Arsumlun=43
   Casumlun=44
   Fesumlun=45
   Nisumlun=46

   IF ( DOSECTORED eq 2 ) THEN BEGIN
      Hvlosectlun=47
      Hlosectlun=48
      Hhisectlun=49
      He4losectlun=50
      He4hisectlun=51
      CNOlosectlun=52
      CNOhisectlun=53
      NeMgSilosectlun=54
      NeMgSihisectlun=55
      Fesectlun=56
   ENDIF ELSE BEGIN
      Hlosectlun=47
      He3losectlun=48
      He4losectlun=49
      He4hisectlun=50
      Helosectlun=51
      CNOlosectlun=52
      CNOhisectlun=53
      NeMgSilosectlun=54
      NeMgSihisectlun=55
      Felosectlun=56
      Fehisectlun=57
   ENDELSE

   ; open the output files for appending - the header has already been written to each file
   IF ( DOSTANDARD eq 1 ) THEN BEGIN
   openw, Hlun, OUTFILES.Hfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, He3lun, OUTFILES.He3file, /append, /get_lun, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, He4lun, OUTFILES.He4file, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Helun, OUTFILES.Hefile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Clun, OUTFILES.Cfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Nlun, OUTFILES.Nfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Olun, OUTFILES.Ofile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Nelun, OUTFILES.Nefile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Nalun, OUTFILES.Nafile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Mglun, OUTFILES.Mgfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Allun, OUTFILES.Alfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Silun, OUTFILES.Sifile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Slun, OUTFILES.Sfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Arlun, OUTFILES.Arfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Calun, OUTFILES.Cafile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Felun, OUTFILES.Fefile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Nilun, OUTFILES.Nifile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   ENDIF
   
   IF ( DORATES eq 1 ) THEN BEGIN
      openw, EVPlun, OUTFILES.EVPfile, /append, error = error_flag
      if (error_flag ne 0)then begin
         printf, -2, !err_string
         exit, /NO_CONFIRM, STATUS=-1
      endif
      openw, BUFlun, OUTFILES.BUFfile, /append, error = error_flag
      if (error_flag ne 0)then begin
         printf, -2, !err_string
         exit, /NO_CONFIRM, STATUS=-1
      endif
      openw, SNGlun, OUTFILES.SINGLESfile, /append, error = error_flag
      if (error_flag ne 0)then begin
         printf, -2, !err_string
         exit, /NO_CONFIRM, STATUS=-1
      endif
   ENDIF

   IF ( DOSUMMED eq 1 ) THEN BEGIN
   openw, Hsumlun, SUMFILES.Hfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, He3sumlun, SUMFILES.He3file, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, He4sumlun, SUMFILES.He4file, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Hesumlun, SUMFILES.Hefile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Csumlun, SUMFILES.Cfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Nsumlun, SUMFILES.Nfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Osumlun, SUMFILES.Ofile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Nesumlun, SUMFILES.Nefile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Nasumlun, SUMFILES.Nafile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Mgsumlun, SUMFILES.Mgfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Alsumlun, SUMFILES.Alfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Sisumlun, SUMFILES.Sifile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Ssumlun, SUMFILES.Sfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Arsumlun, SUMFILES.Arfile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Casumlun, SUMFILES.Cafile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Fesumlun, SUMFILES.Fefile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   openw, Nisumlun, SUMFILES.Nifile, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   ENDIF

   IF ( DOSECTORED gt 0 ) THEN BEGIN

   IF ( DOSECTORED eq 2 ) THEN BEGIN
   openw, Hvlosectlun, SECTFILES.H_vlo, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   ENDIF
   
   openw, Hlosectlun, SECTFILES.H_lo, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
  
   IF ( DOSECTORED eq 2 ) THEN BEGIN
   openw, Hhisectlun, SECTFILES.H_hi, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   ENDIF
   
   IF ( DOSECTORED eq 1 ) THEN BEGIN
   openw, He3losectlun, SECTFILES.He3_lo, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   ENDIF
  
   openw, He4losectlun, SECTFILES.He4_lo, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
  
   openw, He4hisectlun, SECTFILES.He4_hi, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
  
   IF ( DOSECTORED eq 1 ) THEN BEGIN
   openw, Helosectlun, SECTFILES.He_lo, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   ENDIF
   
   openw, CNOlosectlun, SECTFILES.CNO_lo, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
  
   openw, CNOhisectlun, SECTFILES.CNO_hi, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
  
   openw, NeMgSilosectlun, SECTFILES.NeMgSi_lo, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
  
   openw, NeMgSihisectlun, SECTFILES.NeMgSi_hi, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
  
   IF ( DOSECTORED eq 1 ) THEN BEGIN
   openw, Felosectlun, SECTFILES.Fe_lo, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
  
   openw, Fehisectlun, SECTFILES.Fe_hi, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   ENDIF
   
   IF ( DOSECTORED eq 2 ) THEN BEGIN
   openw, Fesectlun, SECTFILES.Fe, /append, error = error_flag
   if (error_flag ne 0)then begin
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
   endif
   ENDIF  
   ENDIF

  ; read in the 32-byte header at the start of each LET MSU accelerator
  ; calibration telemetry data file. Apart from this header, the file
  ; is in Payload telem pkt format.
  ; MSU_header=BYTARR(32)
  ; readu,unit,MSU_header

  packet = 0
  letl1data = 0

  WHILE 1 DO BEGIN
     read_stereo_pkt, unit, packet
     if n_elements(packet) eq 0 then break
     apid = parse_stereo_pkt(packet, /APID )

     ; send LET science packets (apid=580) to LET level 1 processing.
     ; letdata structure is returned undefined unless let_level1 has
     ; all the info needed to process a LET science frame
     IF apid eq 580 THEN BEGIN
        let_level1, packet, letl1data

	; do something useful with the LET level 1 data structure here
	IF n_elements(letl1data) ne 0 THEN BEGIN
;           printf,-2,letl1data.header.timeCDS
;         printf,-2,letl1data.header.SWversion ,letl1data.header.SCid, $
;	        letl1data.header.SCidLET, $
;		letl1data.header.SciFrmVersion, letl1data.header.DyThState, $
;		letl1data.header.Livetime, letl1data.header.Minute
;	   printf, -2, letl1data.unsectored_flux.N
;	   printf, -2, letl1data.unsectored_counts.N
           utc = int2utc(letl1data.header.timeCDS)
           year = utc.year
	   doy = utc2doy(utc, /FRACTIONAL)
	   hour = utc.hour
	   min = utc.minute
	   sec = utc.second
	   IF ( DOSTANDARD eq 1 ) THEN BEGIN
	   printf, Hlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.H, letl1data.unsectored_counts.H, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,12(1X,E11.4),12(1X,I11))'
	   printf, He3lun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.He3, letl1data.unsectored_counts.He3, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,11(1X,E11.4),11(1X,I11))'
	   printf, He4lun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.He4, letl1data.unsectored_counts.He4, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,12(1X,E11.4),12(1X,I11))'
	   printf, Helun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.He, letl1data.unsectored_counts.He, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,11(1X,E11.4),11(1X,I11))'
	   printf, Clun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.C, letl1data.unsectored_counts.C, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,12(1X,E11.4),12(1X,I11))'
	   printf, Nlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.N, letl1data.unsectored_counts.N, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,12(1X,E11.4),12(1X,I11))'
	   printf, Olun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.O, letl1data.unsectored_counts.O, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,12(1X,E11.4),12(1X,I11))'
	   printf, Nelun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.Neon, letl1data.unsectored_counts.Neon, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,13(1X,E11.4),13(1X,I11))'
	   printf, Nalun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.Na, letl1data.unsectored_counts.Na, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,8(1X,E11.4),8(1X,I11))'
	   printf, Mglun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.Mg, letl1data.unsectored_counts.Mg, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,14(1X,E11.4),14(1X,I11))'
	   printf, Allun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.Al, letl1data.unsectored_counts.Al, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,9(1X,E11.4),9(1X,I11))'
	   printf, Silun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.Si, letl1data.unsectored_counts.Si, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,14(1X,E11.4),14(1X,I11))'
	   printf, Slun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.S, letl1data.unsectored_counts.S, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,13(1X,E11.4),13(1X,I11))'
	   printf, Arlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.Ar, letl1data.unsectored_counts.Ar, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,13(1X,E11.4),13(1X,I11))'
	   printf, Calun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.Ca, letl1data.unsectored_counts.Ca, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,13(1X,E11.4),13(1X,I11))'
	   printf, Felun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.Fe, letl1data.unsectored_counts.Fe, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'
	   printf, Nilun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.unsectored_flux.Ni, letl1data.unsectored_counts.Ni, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,9(1X,E11.4),9(1X,I11))'
           ENDIF
	   
	   IF ( DORATES eq 1 ) THEN BEGIN
	   printf, EVPlun, year, doy, hour, min, sec, letl1data.raw_rates.EVPRATES, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),16(1X,I11))'
	   printf, BUFlun, year, doy, hour, min, sec, letl1data.raw_rates.BUFRATES, $
	   	letl1data.header.Livetime, 2 * letl1data.raw_rates.ERATES[0], $
		2 * letl1data.raw_rates.ERATES[1], 2 * letl1data.raw_rates.ERATES[2], $
		FORMAT='(I4,1X,F10.6,3(1X,I2),29(1X,I11),1X,F7.4,3(1X,I11))'
	   printf, SNGlun, year, doy, hour, min, sec, letl1data.raw_rates.SNGRATES, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),108(1X,I11))'
           ENDIF

	   IF ( DOSUMMED eq 1 ) THEN BEGIN	   
	   printf, Hsumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.H, letl1data.summed_counts.H, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,4(1X,E11.4),4(1X,I11))'
	   printf, He3sumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.He3, letl1data.summed_counts.He3, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,3(1X,E11.4),3(1X,I11))'
	   printf, He4sumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.He4, letl1data.summed_counts.He4, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,4(1X,E11.4),4(1X,I11))'
	   printf, Hesumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.He, letl1data.summed_counts.He, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,3(1X,E11.4),3(1X,I11))'
	   printf, Csumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.C, letl1data.summed_counts.C, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,4(1X,E11.4),4(1X,I11))'
	   printf, Nsumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.N, letl1data.summed_counts.N, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,4(1X,E11.4),4(1X,I11))'
	   printf, Osumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.O, letl1data.summed_counts.O, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,4(1X,E11.4),4(1X,I11))'
	   printf, Nesumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.Neon, letl1data.summed_counts.Neon, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,4(1X,E11.4),4(1X,I11))'

	   printf, Nasumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.Na, letl1data.summed_counts.Na, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,2(1X,E11.4),2(1X,I11))'

	   printf, Mgsumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.Mg, letl1data.summed_counts.Mg, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,4(1X,E11.4),4(1X,I11))'

	   printf, Alsumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.Al, letl1data.summed_counts.Al, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,3(1X,E11.4),3(1X,I11))'

	   printf, Sisumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.Si, letl1data.summed_counts.Si, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,5(1X,E11.4),5(1X,I11))'

	   printf, Ssumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.S, letl1data.summed_counts.S, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,5(1X,E11.4),5(1X,I11))'

	   printf, Arsumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.Ar, letl1data.summed_counts.Ar, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,5(1X,E11.4),5(1X,I11))'

	   printf, Casumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.Ca, letl1data.summed_counts.Ca, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,5(1X,E11.4),5(1X,I11))'

	   printf, Fesumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.Fe, letl1data.summed_counts.Fe, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,5(1X,E11.4),5(1X,I11))'

	   printf, Nisumlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.summed_flux.Ni, letl1data.summed_counts.Ni, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,3(1X,E11.4),3(1X,I11))'
           ENDIF

	   IF ( DOSECTORED gt 0 ) THEN BEGIN        
	   IF ( DOSECTORED eq 2 ) THEN BEGIN        
	   printf, Hvlosectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.H_vlo, letl1data.sectored_counts.H_vlo, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'
	   ENDIF

	   printf, Hlosectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.H_lo, letl1data.sectored_counts.H_lo, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'

	   IF ( DOSECTORED eq 2 ) THEN BEGIN        
	   printf, Hhisectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.H_hi, letl1data.sectored_counts.H_hi, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'
	   ENDIF

	   IF ( DOSECTORED eq 1 ) THEN BEGIN        
	   printf, He3losectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.He3_lo, letl1data.sectored_counts.He3_lo, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'
           ENDIF
	   
	   printf, He4losectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.He4_lo, letl1data.sectored_counts.He4_lo, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'

	   printf, He4hisectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.He4_hi, letl1data.sectored_counts.He4_hi, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'

	   IF ( DOSECTORED eq 1 ) THEN BEGIN        
	   printf, Helosectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.He_lo, letl1data.sectored_counts.He_lo, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'
           ENDIF
	   
	   printf, CNOlosectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.CNO_lo, letl1data.sectored_counts.CNO_lo, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'

	   printf, CNOhisectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.CNO_hi, letl1data.sectored_counts.CNO_hi, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'

	   printf, NeMgSilosectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.NeMgSi_lo, letl1data.sectored_counts.NeMgSi_lo, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'

	   printf, NeMgSihisectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.NeMgSi_hi, letl1data.sectored_counts.NeMgSi_hi, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'

	   IF ( DOSECTORED eq 1 ) THEN BEGIN        
	   printf, Felosectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.Fe_lo, letl1data.sectored_counts.Fe_lo, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'

	   printf, Fehisectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.Fe_hi, letl1data.sectored_counts.Fe_hi, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'
           ENDIF		
	   IF ( DOSECTORED eq 2 ) THEN BEGIN        
	   printf, Fesectlun, year, doy, hour, min, sec, letl1data.header.DyThState, $
	   	letl1data.header.Livetime, letl1data.sectored_flux.Fe_wide, letl1data.sectored_counts.Fe_wide, $
		FORMAT='(I4,1X,F10.6,3(1X,I2),1X,I1,1X,F7.4,16(1X,E11.4),16(1X,I11))'
           ENDIF		
           ENDIF
	ENDIF
     ENDIF
  ENDWHILE
  
  free_lun, unit
  IF ( DOSTANDARD eq 1 ) THEN close, Hlun, He3lun, He4lun, Helun, Clun, Nlun, $
  	Olun, Nelun, Nalun, Mglun, Allun, Silun, Slun, Arlun, Calun, Felun, Nilun
  IF ( DOSUMMED eq 1 ) THEN close, Hsumlun, He3sumlun, He4sumlun, Hesumlun, Csumlun, $
  	Nsumlun, Osumlun, Nesumlun, Nasumlun, Mgsumlun, Alsumlun, Sisumlun, Ssumlun, $
	Arsumlun, Casumlun, Fesumlun, Nisumlun
  IF ( DOSECTORED eq 1 ) THEN close, Hlosectlun,He3losectlun,He4losectlun,He4hisectlun, $
  	Helosectlun,CNOlosectlun,CNOhisectlun, NeMgSilosectlun,NeMgSihisectlun, $
	Felosectlun,Fehisectlun
  IF ( DOSECTORED eq 2 ) THEN close, Hvlosectlun,Hlosectlun,Hhisectlun,He4losectlun, $
  	He4hisectlun,CNOlosectlun,CNOhisectlun, NeMgSilosectlun,NeMgSihisectlun, $
	Fesectlun
  IF ( DORATES eq 1 ) THEN close, EVPlun, BUFlun, SNGlun
  
end ; level1_driver

