PRO LET_L1_COMMON
;+
; Project     :	STEREO - IMPACT, LET
;
; Name        : LET_L1_COMMON
;
; Purpose     :	setup let_l1 common block
;               (global constants and variables for LET Level 1 processing)
;
; Category    :	STEREO, IMPACT, LET
;
; Explanation :	
;
; Syntax      :	LET_L1_COMMON
;
; Examples    :	
;
; Inputs      :	
;
; Opt. Inputs :	None.
;
; Outputs     :	
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       : 
;
; Common      : let_l1
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 18-Apr-2005, Andrew Davis, Caltech.
;               Version 2, 26-Sep-2005, Andrew Davis, Caltech.
;               Version 3, 22-Feb-2006, Andrew Davis, Caltech.
;               Version 4, 26-Apr-2006, Andrew Davis, Caltech.
;               Version 5, 10-May-2006, Andrew Davis, Caltech.
;               Version 6, 22-Jan-2007, Andrew Davis, Caltech.
;               Version 7, 12-Mar-2007, Andrew Davis, Caltech.
;               Version 8, 02-Jul-2007, Andrew Davis, Caltech.
;               Version 9, 04-Sep-2007, Andrew Davis, Caltech.
;               See headers in let_process.pro for version details.
;
; Contact     :	ad@srl.caltech.edu
;-
;

common let_l1, pkt_times, scids, LETPKTDATASIZE, $
	LIVETIMESCALEFACTOR, LIVETIMECORRFACTOR, $
	letscifrm, VERSION, doext, first_frame, SaveDyThState, $
	OSCid, offile, osffile, omfile, osmfile, $
	NSPECIES, NEBINS, R2_ctrs, R3_ctrs, R4_ctrs, Emin, Enum, Esum, $
	Esumdefs, Factors, Masks, Sgeom, SFactors, SMasks, FILL_L, FILL_D, $
	caltimes_a, calfnames_a, caln_a, caltimes_b, calfnames_b, caln_b, $
	sec_caltimes_a, sec_calfnames_a, sec_caln_a, sec_caltimes_b, sec_calfnames_b, sec_caln_b, $
	MAXCALDB, LETL1CALDB_A, LETL1CALDB_B, LETL1SECCALDB_A, LETL1SECCALDB_B, $
	masktimes_a, maskfnames_a, maskn_a, masktimes_b, maskfnames_b, maskn_b, $
	sec_masktimes_a, sec_maskfnames_a, sec_maskn_a, sec_masktimes_b, sec_maskfnames_b, sec_maskn_b, $
	MAXMASKDB, LETL1MASKDB_A, LETL1MASKDB_B, LETL1SECMASKDB_A, LETL1SECMASKDB_B, $
	first_zero_seq, prev_pkt_seq

VERSION = 11B  ; LET level 1 software version

doext = 1 ; set to 1 to include raw rates in level 1 data structure

first_frame = 1; flag indicates we are processing the first frame of the session
SaveDyThState = 0B; 

OSCid = 0U             ; SCid from previous minute
offile = '';           ; factors file from previous minute
osffile = '';          ; sectored factors file from previous minute
omfile = '';           ; masks file from previous minute
osmfile = '';          ; sectored masks file from previous minute

; arrays to hold calibration database entries for LET Level 1 geom/efficiency factors
MAXCALDB=1000
caltimes_a = DBLARR(MAXCALDB)
calfnames_a = STRARR(MAXCALDB)
caln_a = 0

caltimes_b = DBLARR(MAXCALDB)
calfnames_b = STRARR(MAXCALDB)
caln_b = 0

sec_caltimes_a = DBLARR(MAXCALDB)
sec_calfnames_a = STRARR(MAXCALDB)
sec_caln_a = 0

sec_caltimes_b = DBLARR(MAXCALDB)
sec_calfnames_b = STRARR(MAXCALDB)
sec_caln_b = 0

LETL1CALDB_A = concat_dir('$LET_L1_CALIB_DATA' , 'LET_Level1_caldb_ahead.txt')
LETL1CALDB_B = concat_dir('$LET_L1_CALIB_DATA' , 'LET_Level1_caldb_behind.txt')
LETL1SECCALDB_A = concat_dir('$LET_L1_CALIB_DATA' , 'LET_Level1_sec_caldb_ahead.txt')
LETL1SECCALDB_B = concat_dir('$LET_L1_CALIB_DATA' , 'LET_Level1_sec_caldb_behind.txt')

; arrays to hold masks database entries for LET Level 1 species/energy-bin masks
MAXMASKDB=1000
masktimes_a = DBLARR(MAXMASKDB)
maskfnames_a = STRARR(MAXMASKDB)
maskn_a = 0

masktimes_b = DBLARR(MAXMASKDB)
maskfnames_b = STRARR(MAXMASKDB)
maskn_b = 0

sec_masktimes_a = DBLARR(MAXMASKDB)
sec_maskfnames_a = STRARR(MAXMASKDB)
sec_maskn_a = 0

sec_masktimes_b = DBLARR(MAXMASKDB)
sec_maskfnames_b = STRARR(MAXMASKDB)
sec_maskn_b = 0

LETL1MASKDB_A = concat_dir('$LET_L1_CALIB_DATA' , 'LET_Level1_maskdb_ahead.txt')
LETL1MASKDB_B = concat_dir('$LET_L1_CALIB_DATA' , 'LET_Level1_maskdb_behind.txt')
LETL1SECMASKDB_A = concat_dir('$LET_L1_CALIB_DATA' , 'LET_Level1_sec_maskdb_ahead.txt')
LETL1SECMASKDB_B = concat_dir('$LET_L1_CALIB_DATA' , 'LET_Level1_sec_maskdb_behind.txt')

pkt_times = lonarr(16) ; array to hold time-stamps (seconds)
                       ; of each LET packet in a LET science frame

scids = uintarr(16)    ; array to hold spacecraftIDs (from GRH headers)
                       ; of each LET packet in a LET science frame

LETPKTDATASIZE = 260   ; does not include checksum byte in each packet

LIVETIMESCALEFACTOR = 8192.0D / 3.84E8 ; converts raw livetime counter to fractional livetime
LIVETIMECORRFACTOR = 2.0D * 0.9E-6 ; LT_corr = LT + (LIVETIMECORRFACTOR * NUMTRIG)

letscifrm = BYTARR(LETPKTDATASIZE * 16)

NSPECIES = 16
NEBINS = 19
R2_ctrs = INTARR(NSPECIES,NEBINS) ; rate-counter array index lookup table for Range 2 events.
R3_ctrs = INTARR(NSPECIES,NEBINS)
R4_ctrs = INTARR(NSPECIES,NEBINS)

Emin = INTARR(NSPECIES)  ; index of lowest valid Ebin for each species
Enum = INTARR(NSPECIES)  ; number of valid E-bins for each species
Esum = INTARR(NSPECIES)  ; number of valid summed-E-bins for each species



FILL_L = -2147483647L ; long fill-data
FILL_D = -1.0E31 ; double fill-data

first_zero_seq=0
prev_pkt_seq=-1

; these could be filled-in automatically by scanning the tables below,
; but it's done manually for now...
Emin = [1,2,1,4,4,4,4,9,4,9,4,5,5,5,3,10]
Enum = [12,11,12,12,12,12,13,8,14,9,14,13,13,13,16,9]

; Number of summed energy bins for each species
Esum = [4,3,4,4,4,4,4,2,4,3,5,5,5,5,5,3]

; Define which of the original energy bins contribute to the summed bins, for each species
;         1.8 to 3.6	4 to 6		6 to 10		10 to 15	15 to 27	27 to 40
H_sums   = [[0,1,2,3],	[5,6,7,-1],	[8,9,-1,-1],	[10,11,-1,-1]];
He3_sums = [		[4,5,6,-1],	[7,8,-1,-1],	[9,10,-1,-1]];
He4_sums = [[0,1,2,3],	[5,6,7,-1],	[8,9,-1,-1],	[10,11,-1,-1]];
C_sums   = [		[2,3,4,-1],	[5,6,-1,-1],	[7,8,-1,-1],	[9,10,-1,-1]];
N_sums   = [		[2,3,4,-1],	[5,6,-1,-1],	[7,8,-1,-1],	[9,10,-1,-1]];
O_sums   = [		[2,3,4,-1],	[5,6,-1,-1],	[7,8,-1,-1],	[9,10,-1,-1]];
Ne_sums  = [		[2,3,4,-1],	[5,6,-1,-1],	[7,8,-1,-1],	[9,10,-1,-1]];
Na_sums  = [						[2,3,-1,-1],	[4,5,-1,-1]];
Mg_sums  = [		[2,3,4,-1],	[5,6,-1,-1],	[7,8,-1,-1],	[9,10,-1,-1]];
Al_sums  = [				[0,1,-1,-1],	[2,3,-1,-1],	[4,5,-1,-1]];
Si_sums  = [		[2,3,4,-1],	[5,6,-1,-1],	[7,8,-1,-1],	[9,10,-1,-1],	[11,12,-1,-1]];
S_sums   = [		[1,2,3,-1],	[4,5,-1,-1],	[6,7,-1,-1],	[8,9,-1,-1],	[10,11,-1,-1]];
Ar_sums  = [		[1,2,3,-1],	[4,5,-1,-1],	[6,7,-1,-1],	[8,9,-1,-1],	[10,11,-1,-1]];
Ca_sums  = [		[1,2,3,-1],	[4,5,-1,-1],	[6,7,-1,-1],	[8,9,-1,-1],	[10,11,-1,-1]];
Fe_sums  = [		[3,4,5,-1],	[6,7,-1,-1],	[8,9,-1,-1],	[10,11,-1,-1],	[12,13,-1,-1]];
Ni_sums  = [						[1,2,-1,-1],	[3,4,-1,-1],	[5,6,-1,-1]];

; structure to cart around all the summed energy-bin definitions
Esumdefs = { H_sums:H_sums, He3_sums:He3_sums, $
	He4_sums:He4_sums, C_sums:C_sums, $
	N_sums:N_sums, O_sums:O_sums, $
	Ne_sums:Ne_sums, Na_sums:Na_sums, $
	Mg_sums:Mg_sums, Al_sums:Al_sums, $
	Si_sums:Si_sums, S_sums:S_sums, $
	Ar_sums:Ar_sums, Ca_sums:Ca_sums, $
	Fe_sums:Fe_sums, Ni_sums:Ni_sums $
}


; structures to hold conversion factors for each species/energy combination
factor = { $
	speciesnum: 0L, $ 
	Z: 0L, $
	A: 0L, $
	Elo: 0.0D, $
	Ehi: 0.0D, $
	geom: DBLARR(4), $
	effic: DBLARR(4) $
}

H_fctrs   = replicate(factor,Enum[0])
He3_fctrs = replicate(factor,Enum[1])
He4_fctrs = replicate(factor,Enum[2])
C_fctrs   = replicate(factor,Enum[3])
N_fctrs   = replicate(factor,Enum[4])
O_fctrs   = replicate(factor,Enum[5])
Ne_fctrs  = replicate(factor,Enum[6])
Na_fctrs  = replicate(factor,Enum[7])
Mg_fctrs  = replicate(factor,Enum[8])
Al_fctrs  = replicate(factor,Enum[9])
Si_fctrs  = replicate(factor,Enum[10])
S_fctrs   = replicate(factor,Enum[11])
Ar_fctrs  = replicate(factor,Enum[12])
Ca_fctrs  = replicate(factor,Enum[13])
Fe_fctrs  = replicate(factor,Enum[14])
Ni_fctrs  = replicate(factor,Enum[15])


; this structure holds the conversion factors from raw counts to
; physical units for all the species/energy combinations
Factors = { H_fctrs:H_fctrs, He3_fctrs:He3_fctrs, $
	He4_fctrs:He4_fctrs, C_fctrs:C_fctrs, $
	N_fctrs:N_fctrs, O_fctrs:O_fctrs, $
	Ne_fctrs:Ne_fctrs, Na_fctrs:Na_fctrs, $
	Mg_fctrs:Mg_fctrs, Al_fctrs:Al_fctrs, $
	Si_fctrs:Si_fctrs, S_fctrs:S_fctrs, $
	Ar_fctrs:Ar_fctrs, Ca_fctrs:Ca_fctrs, $
	Fe_fctrs:Fe_fctrs, Ni_fctrs:Ni_fctrs $
}

; geometry factors for sectored rates
Sgeom = DBLARR(16)
; energy and efficiency factors for sectored rates
sfactor = { $
        Elo: 0.0D, $
        Ehi: 0.0D, $
        effic: DBLARR(4) $
}
SFactors = replicate(sfactor,160)


; structures to hold mask for each species/energy combination
mask = { $
	speciesnum: 0L, $ 
	Z: 0L, $
	A: 0L, $
	Elo: 0.0D, $
	Ehi: 0.0D, $
	mask: 0.0D $
}

H_masks   = replicate(mask,Enum[0])
He3_masks = replicate(mask,Enum[1])
He4_masks = replicate(mask,Enum[2])

He_masks = replicate(mask,Enum[1])	; number of He elemental bins is same as for He3

C_masks   = replicate(mask,Enum[3])
N_masks   = replicate(mask,Enum[4])
O_masks   = replicate(mask,Enum[5])
Ne_masks  = replicate(mask,Enum[6])
Na_masks  = replicate(mask,Enum[7])
Mg_masks  = replicate(mask,Enum[8])
Al_masks  = replicate(mask,Enum[9])
Si_masks  = replicate(mask,Enum[10])
S_masks   = replicate(mask,Enum[11])
Ar_masks  = replicate(mask,Enum[12])
Ca_masks  = replicate(mask,Enum[13])
Fe_masks  = replicate(mask,Enum[14])
Ni_masks  = replicate(mask,Enum[15])


; this structure holds the masks for all the species/energy combinations
Masks = { H_masks:H_masks, He3_masks:He3_masks, $
	He4_masks:He4_masks, He_masks:He_masks, C_masks:C_masks, $
	N_masks:N_masks, O_masks:O_masks, $
	Ne_masks:Ne_masks, Na_masks:Na_masks, $
	Mg_masks:Mg_masks, Al_masks:Al_masks, $
	Si_masks:Si_masks, S_masks:S_masks, $
	Ar_masks:Ar_masks, Ca_masks:Ca_masks, $
	Fe_masks:Fe_masks, Ni_masks:Ni_masks $
}

; masks for sectored rates
smask = { $
        Elo: 0.0D, $
        Ehi: 0.0D, $
        mask: 0.0D $
}
SMasks = replicate(smask,160)



; Created Mon Apr 11 14:25:10 PDT 2005 using ./mk_level1_rate_tables version 2 
; rate-counter array index lookup table for Range 2 events.
; Each non-negative entry is an index into the L2FGRATES array
;                   H 3He 4He   C   N   O  Ne  Na  Mg  Al  Si   S  Ar  Ca  Fe  Ni 
R2_ctrs[0:15, 0]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 1.0_1.8
R2_ctrs[0:15, 1]=[  1, -1, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 1.8_2.2
R2_ctrs[0:15, 2]=[  2, 10, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 2.2_2.7
R2_ctrs[0:15, 3]=[  3, 11, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,119, -1] ; 2.7_3.2
R2_ctrs[0:15, 4]=[  4, 12, 22, 28, 37, 46, 55, -1, 65, -1, 76, -1, -1, -1,120, -1] ; 3.2_3.6
R2_ctrs[0:15, 5]=[  5, 13, 23, 29, 38, 47, 56, -1, 66, -1, 77, 87, 97,108,121, -1] ; 3.6_4.0
R2_ctrs[0:15, 6]=[  6, 14, 24, 30, 39, 48, 57, -1, 67, -1, 78, 88, 98,109,122, -1] ; 4.0_4.5
R2_ctrs[0:15, 7]=[  7, 15, 25, 31, 40, 49, 58, -1, 68, -1, 79, 89, 99,110,123, -1] ; 4.5_5.0
R2_ctrs[0:15, 8]=[ -1, 16, -1, 32, 41, 50, 59, -1, 69, -1, 80, 90,100,111,124, -1] ; 5.0_6.0
R2_ctrs[0:15, 9]=[ -1, -1, -1, 33, 42, 51, 60, -1, 70, -1, 81, 91,101,112,125, -1] ; 6.0_8.0
R2_ctrs[0:15,10]=[ -1, -1, -1, 34, 43, 52, 61, -1, 71, -1, 82, 92,102,113,126, -1] ; 8.0_10
R2_ctrs[0:15,11]=[ -1, -1, -1, -1, -1, -1, 62, -1, 72, -1, 83, 93,103,114,127, -1] ; 10_12
R2_ctrs[0:15,12]=[ -1, -1, -1, -1, -1, -1, -1, -1, 73, -1, 84, 94,104,115,128, -1] ; 12_15
R2_ctrs[0:15,13]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,105,116,129, -1] ; 15_21
R2_ctrs[0:15,14]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 21_27
R2_ctrs[0:15,15]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 27_33
R2_ctrs[0:15,16]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 33_40
R2_ctrs[0:15,17]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 40_52
R2_ctrs[0:15,18]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 52_70

; rate-counter array index lookup table for Range 3 events.
; Each non-negative entry is an index into the L3FGRATES array
;                   H 3He 4He   C   N   O  Ne  Na  Mg  Al  Si   S  Ar  Ca  Fe  Ni 
R3_ctrs[0:15, 0]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 1.0_1.8
R3_ctrs[0:15, 1]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 1.8_2.2
R3_ctrs[0:15, 2]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 2.2_2.7
R3_ctrs[0:15, 3]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 2.7_3.2
R3_ctrs[0:15, 4]=[  1, -1, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 3.2_3.6
R3_ctrs[0:15, 5]=[  2, -1, 22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 3.6_4.0
R3_ctrs[0:15, 6]=[  3, 12, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 4.0_4.5
R3_ctrs[0:15, 7]=[  4, 13, 24, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 4.5_5.0
R3_ctrs[0:15, 8]=[  5, 14, 25, 33, 43, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 5.0_6.0
R3_ctrs[0:15, 9]=[  6, 15, 26, 34, 44, 54, 63, 73, 83, 94,105,116,127, -1, -1, -1] ; 6.0_8.0
R3_ctrs[0:15,10]=[  7, 16, 27, 35, 45, 55, 64, 74, 84, 95,106,117,128,138,148,158] ; 8.0_10
R3_ctrs[0:15,11]=[  8, 17, 28, 36, 46, 56, 65, 75, 85, 96,107,118,129,139,149,159] ; 10_12
R3_ctrs[0:15,12]=[  9, 18, 29, 37, 47, 57, 66, 76, 86, 97,108,119,130,140,150,160] ; 12_15
R3_ctrs[0:15,13]=[ -1, -1, -1, 38, 48, 58, 67, 77, 87, 98,109,120,131,141,151,161] ; 15_21
R3_ctrs[0:15,14]=[ -1, -1, -1, 39, 49, 59, 68, 78, 88, 99,110,121,132,142,152,162] ; 21_27
R3_ctrs[0:15,15]=[ -1, -1, -1, 40, 50, 60, 69, 79, 89,100,111,122,133,143,153,163] ; 27_33
R3_ctrs[0:15,16]=[ -1, -1, -1, -1, -1, -1, 70, 80, 90,101,112,123,134,144,154,164] ; 33_40
R3_ctrs[0:15,17]=[ -1, -1, -1, -1, -1, -1, -1, -1, 91,102,113,124,135,145,155,165] ; 40_52
R3_ctrs[0:15,18]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,156,166] ; 52_70
 
 
; rate-counter array index lookup table for Range 4 events.
; Each non-negative entry is an index into the PENFGRATES array
;                   H 3He 4He   C   N   O  Ne  Na  Mg  Al  Si   S  Ar  Ca  Fe  Ni 
R4_ctrs[0:15, 0]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 1.0_1.8
R4_ctrs[0:15, 1]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 1.8_2.2
R4_ctrs[0:15, 2]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 2.2_2.7
R4_ctrs[0:15, 3]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 2.7_3.2
R4_ctrs[0:15, 4]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 3.2_3.6
R4_ctrs[0:15, 5]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 3.6_4.0
R4_ctrs[0:15, 6]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 4.0_4.5
R4_ctrs[0:15, 7]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 4.5_5.0
R4_ctrs[0:15, 8]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 5.0_6.0
R4_ctrs[0:15, 9]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 6.0_8.0
R4_ctrs[0:15,10]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 8.0_10
R4_ctrs[0:15,11]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 10_12
R4_ctrs[0:15,12]=[  1, -1,  4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 12_15
R4_ctrs[0:15,13]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 15_21
R4_ctrs[0:15,14]=[ -1, -1, -1,  7, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 21_27
R4_ctrs[0:15,15]=[ -1, -1, -1,  8, 12, 15, 18, -1, -1, -1, -1, -1, -1, -1, -1, -1] ; 27_33
R4_ctrs[0:15,16]=[ -1, -1, -1, -1, -1, -1, 19, -1, 22, -1, 26, -1, -1, -1, -1, -1] ; 33_40
R4_ctrs[0:15,17]=[ -1, -1, -1, -1, -1, -1, -1, -1, 23, -1, 27, -1, -1, -1, 30, -1] ; 40_52
R4_ctrs[0:15,18]=[ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1] ; 52_70


end
