PRO FIND_LET_MASKS_FILES, SCid, tai_time, MASKS_FILENM, SECTORED_MASKS_FILENM, $
	masks_need_to_read, sectored_masks_need_to_read

; Figure out which LET Level 1 masks files to read in, if any
; 
; Jun1 1, 2007: Andrew Davis, Caltech. Copied from factors version, with slight edits


common let_l1

IF (first_frame eq 1) THEN BEGIN
   read_let_l1_maskdb
ENDIF

; First check the unsectored database
IF (SCid eq 235) then BEGIN
   FOR ii=0, maskn_b -1 DO BEGIN
      IF (tai_time lt masktimes_b[ii]) THEN BEGIN
         masks_filenm = concat_dir('$LET_L1_CALIB_DATA' , maskfnames_b[ii])
         break
      ENDIF
   ENDFOR
   IF (ii eq maskn_b) THEN BEGIN
      printf, -2, 'Warning: timestamp beyond end of Behind LET maskdb: Using Last Behind LET masks file'
      masks_filenm = concat_dir('$LET_L1_CALIB_DATA' , maskfnames_b[maskn_b -1])
   ENDIF
ENDIF ELSE BEGIN 
   FOR ii=0, maskn_a -1 DO BEGIN
      IF (tai_time lt masktimes_a[ii]) THEN BEGIN
         masks_filenm = concat_dir('$LET_L1_CALIB_DATA' , maskfnames_a[ii])
         break
      ENDIF
   ENDFOR
   IF (ii eq maskn_a) THEN BEGIN
      printf, -2, 'Warning: timestamp beyond end of Ahead LET maskdb: Using Last Ahead LET masks file'
      masks_filenm = concat_dir('$LET_L1_CALIB_DATA' , maskfnames_a[maskn_a -1])
   ENDIF
   IF (SCid ne 234) then BEGIN 
      printf, -2, 'Warning: Bad SCid:', SCid, '   Using Ahead LET masks file'
   ENDIF 
ENDELSE 

; Now check the sectored database
IF (SCid eq 235) then BEGIN
   FOR ii=0, sec_maskn_b -1 DO BEGIN
      IF (tai_time lt sec_masktimes_b[ii]) THEN BEGIN
         sectored_masks_filenm = concat_dir('$LET_L1_CALIB_DATA' , sec_maskfnames_b[ii])
         break
      ENDIF
   ENDFOR
   IF (ii eq sec_maskn_b) THEN BEGIN
      printf, -2, 'Warning: timestamp beyond end of Behind LET sectored maskdb: Using Last Behind LET sectored masks file'
      sectored_masks_filenm = concat_dir('$LET_L1_CALIB_DATA' , sec_maskfnames_b[sec_maskn_b -1])
   ENDIF
ENDIF ELSE BEGIN 
   FOR ii=0, sec_maskn_a -1 DO BEGIN
      IF (tai_time lt sec_masktimes_a[ii]) THEN BEGIN
         sectored_masks_filenm = concat_dir('$LET_L1_CALIB_DATA' , sec_maskfnames_a[ii])
         break
      ENDIF
   ENDFOR
   IF (ii eq sec_maskn_a) THEN BEGIN
      printf, -2, 'Warning: timestamp beyond end of Ahead LET sectored maskdb: Using Last Ahead LET sectored masks file'
      sectored_masks_filenm = concat_dir('$LET_L1_CALIB_DATA' , sec_maskfnames_a[sec_maskn_a -1])
   ENDIF
   IF (SCid ne 234) then BEGIN 
      printf, -2, 'Warning: Bad SCid:', SCid, '   Using Ahead LET sectored masks file'
   ENDIF 
ENDELSE 

IF ( (SCid eq OSCid ) AND (masks_filenm eq omfile) ) THEN $
   masks_need_to_read = 0
IF ( (SCid eq OSCid ) AND (sectored_masks_filenm eq osmfile) ) THEN $
   sectored_masks_need_to_read = 0

; print, utc2str(tai2utc(tai_time,/NOCORRECT)), "   ", masks_filenm, "   ", need_to_read

OSCid = SCid
omfile = masks_filenm
osmfile = sectored_masks_filenm

END
